;+
; Project     :	GEN
;
; Name        : UINT_FROM_BYTES
;
; Purpose     :	Transform a 2 byte array to an unsigned integer.
;
; Category    :	GENERAL
;
; Explanation :	
;
; Syntax      :	data_uint = uint_from_bytes( twobytes )
;
; Examples    :	
;
; Inputs      :	twobytes - a 2 element byte array
;
; Opt. Inputs :	None.
;
; Outputs     :	An unsigned integer.
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       :	None
;
; Common      : None.
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1, 03-Feb-2006, Peter Schroeder, UC-Berkeley.
;
; Contact     :	peters@ssl.berkeley.edu
;-
;

;quick function to turn bytes into uints
function uint_from_bytes, twobytes
return, ishft(uint(twobytes[1]), 8) + uint(twobytes[0])
end
