;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: tu_to_date.pro,v $, v $Revision: 1.1 $
;
;	Date	: $Date: 2006/08/16 07:57:28 $
;
;	Auteur	: $Author: stereo $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
FUNCTION check_tu, annee, mois, jour, heure, minute, seconde
;-------------------------------------------------------------------------------

ok=0
IF (jour GE 1) AND (jour LE 31) THEN $
  IF (mois GE 1) AND (mois LE 12) THEN $
    IF (annee GE 1958) AND (annee LE 9999) THEN $
      IF heure GE 0 THEN $ ; on accepte des heures qui depassent d'un jour
        IF (minute GE 0) AND (minute LE 59) THEN $
          IF (seconde GE 0) AND (seconde LE 59.999) THEN ok=1
RETURN, ok

END

;-------------------------------------------------------------------------------
FUNCTION tu_to_date, ann, moi, jou, heu, min, sec
;-------------------------------------------------------------------------------

nbjours = JULDAY (moi, jou, ann) - JULDAY (1, 1, 1958)
nbms    = heu*3600000d + min*60000d + LONG64(sec*1000d +0.5d) ; pb arrondi
date    = nbjours*86400000d + nbms

RETURN, date

END

;-------------------------------------------------------------------------------
PRO date_to_tu, date, ann, moi, jou, heu, min, sec
;-------------------------------------------------------------------------------

nbjours = LONG(date / 86400000d)
nbms    = LONG(date - nbjours*86400000d)

CALDAT, JULDAY (1, 1, 1958) + nbjours, moi, jou, ann, heu, min, sec

heu = LONG(nbms/3600000d)
tmp = nbms - heu*3600000d

min = LONG(tmp/60000d)
tmp = tmp - min*60000d

sec = tmp/1000d

END

;-------------------------------------------------------------------------------
FUNCTION date_to_nbjours, date
;-------------------------------------------------------------------------------

nbjours = LONG(date / 86400000d)

RETURN, nbjours

END

;-------------------------------------------------------------------------------
FUNCTION nbjours_to_date, nbjours
;-------------------------------------------------------------------------------

RETURN, DOUBLE (nbjours*86400000d)

END

;-------------------------------------------------------------------------------
FUNCTION date_to_secinday, date, t1
;-------------------------------------------------------------------------------

RETURN, (date-86400d*1000d*date_to_nbjours(t1))/1000d

END

;-------------------------------------------------------------------------------
FUNCTION mois_str, i
;-------------------------------------------------------------------------------
; i: entre 1 et 12

tab = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']

RETURN, tab[i-1]

END

;-------------------------------------------------------------------------------
FUNCTION tu_to_str, ann, moi, jou, heu, min, sec, format=format
;-------------------------------------------------------------------------------

IF N_ELEMENTS(format) EQ 0 THEN format=0

IF format EQ 1 THEN BEGIN
  str =   int_str_0(jou,2) + ' ' $
        + int_str_0(moi,2) + ' ' $
        + int_str_0(ann,4) + ' ' $
        + int_str_0(heu,2) + ' ' $
        + int_str_0(min,2) + ' ' $
        + int_str_0(LONG(sec),2) + '.' $
        + int_str_0(LONG(1000*sec+0.5)-1000*LONG(sec),3) ; pb arrondi
END ELSE IF format EQ 0 THEN BEGIN
  str =   int_str_0(jou,2) + '/' $
        + mois_str(moi) + '/' $
        + int_str_0(ann,4) + ' ' $
        + int_str_0(heu,2) + ':' $
        + int_str_0(min,2) + ':' $
        + int_str_0(LONG(sec),2) + '.' $
        + int_str_0(LONG(1000*sec+0.5)-1000*LONG(sec),3) ; pb arrondi
END ELSE IF format EQ 2 THEN BEGIN
  str =   int_str_0(jou,2) + '/' $
        + int_str_0(moi,2) + '/' $
        + int_str_0(ann,4) + ' ' $
        + int_str_0(heu,2) + ':' $
        + int_str_0(min,2) + ':' $
        + int_str_0(LONG(sec),2) + '.' $
        + int_str_0(LONG(1000*sec+0.5)-1000*LONG(sec),3) ; pb arrondi
END ELSE IF format EQ 3 THEN BEGIN
  str =   int_str_0(ann,4) + '-' $
        + int_str_0(moi,2) + '-' $
        + int_str_0(jou,2) + 'T' $
        + int_str_0(heu,2) + ':' $
        + int_str_0(min,2) + ':' $
        + int_str_0(LONG(sec),2) + '.' $
        + int_str_0(LONG(1000*sec+0.5)-1000*LONG(sec),3)+'Z' ; pb arrondi
END ELSE IF format EQ 4 THEN BEGIN
  str =   int_str_0(ann,4) + ' ' $
        + int_str_0(moi,2) + ' ' $
        + int_str_0(jou,2) + ' ' $
        + int_str_0(heu,2) + ' ' $
        + int_str_0(min,2) + ' ' $
        + int_str_0(LONG(sec),2) + '.' $
        + int_str_0(LONG(1000*sec+0.5)-1000*LONG(sec),3) ; pb arrondi
END ELSE IF format EQ 5 THEN BEGIN
  str =   int_str_0(ann,4) + '-' $
        + int_str_0(moi,2) + '-' $
        + int_str_0(jou,2) + 'T' $
        + int_str_0(heu,2) + ':' $
        + int_str_0(min,2) + ':' $
        + int_str_0(LONG(sec),2) + 'Z'
END

RETURN, str

END

;-------------------------------------------------------------------------------
FUNCTION date_to_str, date, format = format
;-------------------------------------------------------------------------------

nbdate = N_ELEMENTS(date)
tabstr = REPLICATE('',nbdate)

IF N_ELEMENTS(format) EQ 0 THEN format=0

FOR i=0L,nbdate-1 DO BEGIN
  date_to_tu, date[i], ann, moi, jou, heu, min, sec
  tabstr[i] = tu_to_str (ann, moi, jou, heu, min, sec, format=format)
END

IF nbdate EQ 1 THEN RETURN, tabstr[0] ELSE RETURN, tabstr

END

;-------------------------------------------------------------------------------
FUNCTION str_to_date, str, format=format
;-------------------------------------------------------------------------------

ON_IOERROR, str_to_date_erreur

IF N_ELEMENTS(format) EQ 0 THEN format=0

jou=0
moi=0
ann=0
heu=0
min=0
sec=0.

IF format EQ 3 THEN BEGIN
  len = STRLEN(str)
  IF len LT 23 THEN GOTO, str_to_date_erreur
  ann = LONG(STRMID (str, 0,4))
  moi = LONG(STRMID (str, 5,2))
  jou = LONG(STRMID (str, 8,2))
  heu = LONG(STRMID (str,11,2))
  min = LONG(STRMID (str,14,2))
  sec = DOUBLE (STRMID (str,17,6))
END ELSE BEGIN
  tmp = str_to_ascii (str)
  nb = N_ELEMENTS(tmp)
  IF nb LT 3 THEN GOTO, str_to_date_erreur
  READS, tmp[0], jou
  READS, tmp[1], moi
  READS, tmp[2], ann
  IF nb GE 4 THEN READS, tmp[3], heu ELSE heu=0
  IF nb GE 5 THEN READS, tmp[4], min ELSE min=0
  IF nb GE 6 THEN READS, tmp[5], sec ELSE sec=0
END

IF check_tu (ann, moi, jou, heu, min, sec) EQ 0 THEN RETURN, !VALUES.D_INFINITY
date = tu_to_date (ann, moi, jou, heu, min, sec)
RETURN, date

str_to_date_erreur:

RETURN, !VALUES.D_INFINITY

END

;------------------------------------------------------------------------------
FUNCTION saisir_date, texte, date
;-------------------------------------------------------------------------------

PRINT,''
PRINT, texte
FOR i=0,STRLEN(texte)-1 DO PRINT, '-', FORMAT='(A,$)'
PRINT

date_to_tu, date, annee, mois, jour, heure, minute, seconde

REPEAT BEGIN
  saisir_entier_defaut,'Day ',jour,0
  ok = jour GE 1 AND jour LE 31
  IF NOT ok THEN PRINT, 'out of range ...'
END UNTIL ok 

REPEAT BEGIN
  saisir_entier_defaut,'Month ',mois,0
  ok = mois GE 1 AND mois LE 12
  IF NOT ok THEN PRINT, 'out of range ...'
END UNTIL ok 

REPEAT BEGIN
  saisir_entier_defaut,'Year (4 digits) ',annee,0
  ok = annee GE 1958 AND annee LE 9999
  IF NOT ok THEN PRINT, 'out of range ...'
END UNTIL ok 

REPEAT BEGIN
  saisir_entier_defaut,'Hour ',heure,0
  ok = heure GE 0 AND heure LE 23
  IF NOT ok THEN PRINT, 'out of range ...'
END UNTIL ok 

REPEAT BEGIN
  minute = 0
  saisir_entier_defaut,'Minute ',minute,0
  ok = minute GE 0 AND minute LE 59
  IF NOT ok THEN PRINT, 'out of range ...'
END UNTIL ok 

REPEAT BEGIN
  seconde = 0.
  saisir_reel_defaut,'Second ',seconde,0
  ok = seconde GE 0 AND seconde LT 60
  IF NOT ok THEN PRINT, 'out of range ...'
END UNTIL ok 

tmp = tu_to_date (annee, mois, jour, heure, minute, seconde)
RETURN, tmp

END

;-------------------------------------------------------------------------------
FUNCTION date1970_to_date, date1970
;-------------------------------------------------------------------------------

date = date1970*1000d + (JULDAY (1, 1, 1970) - JULDAY (1, 1, 1958))*86400*1000d

RETURN, date

END

;-------------------------------------------------------------------------------
FUNCTION date_to_YYYYMMDD, date
;-------------------------------------------------------------------------------

str=date_to_str(date,FORMAT=1)

YYYYMMDD = STRMID (str,6,4)+STRMID(str,3,2)+STRMID(str,0,2)
RETURN, YYYYMMDD

END

;-------------------------------------------------------------------------------
FUNCTION MMDDYYYY_to_date, MMDDYYYY
;-------------------------------------------------------------------------------

ann = STRMID(MMDDYYYY,6,4)
moi = STRMID(MMDDYYYY,3,2)
jou = STRMID(MMDDYYYY,0,2)
heu = 0
min = 0
sec = 0

date = tu_to_date (ann, moi, jou, heu, min, sec)
RETURN, date

END

;-------------------------------------------------------------------------------
FUNCTION date_to_jd, date
;-------------------------------------------------------------------------------

date_to_tu, date, ann, moi, jou, heu, min, sec
RETURN, ymd2jd (ann, moi, jou)

END

;-------------------------------------------------------------------------------
FUNCTION selection, tab_date, tab_time_t1, tab_time_t2, INVERSE=INVERSE
;-------------------------------------------------------------------------------

IF N_ELEMENTS(inverse) EQ 0 THEN inverse=0

ind = LINDGEN (N_ELEMENTS(tab_date))
IF tab_time_t1[0] EQ '' THEN RETURN, INVERSE EQ 1 ? -1 : ind

indok = -1

FOR i=0L,N_ELEMENTS(tab_time_t1)-1 DO BEGIN
	ind1 = WHERE ((tab_date GE str_to_date(tab_time_t1[i])) AND (tab_date LE str_to_date(tab_time_t2[i])))
	IF ind1[0] NE -1 THEN indok = indok[0] EQ -1 ? ind1 : [indok,ind1]
END

IF INVERSE EQ 1 THEN BEGIN
	tmp = REPLICATE (0, N_ELEMENTS(tab_date))
	IF indok[0] NE -1 THEN tmp[indok] = 1
	indok = WHERE (tmp EQ 0)
END

RETURN, indok

END
