PRO SWEA_L1_ENERGIES
;+
; Project     :	STEREO - IMPACT, SWEA
;
; Name        : COMPUTE_SWEA_ENERGIES
;
; Purpose     :	Calculate SWEA energy sweep values
;
; Category    :	STEREO, IMPACT, SWEA
;
; Explanation :	
;
; Syntax      :	SWEA_L1_ENERGIES
;
; Examples    :	
;
; Inputs      :	None.
;
; Opt. Inputs :	None.
;
; Outputs     :	None.
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       :	None
;
; Common      : swea_l1_common
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 3-Feb-2006, Peter Schroeder,
;                  UC-Berkeley.
;
; Contact     :	peters@ssl.berkeley.edu
;-
;
common swea_l1_common

h = 1.746d-7
k = 6.67d
scale = 5090d
dac0 = 41448d

dac = dblarr(48)
dac[0] = dac0
for i=1,47 do dac[i] = dac[i-1] - dac[i-1] * scale / 65536d

energies = dblarr(48)
energies = k * h * dac * dac

swea_energies = energies

return
end
