PRO SWEA_L1_COMMON
;+
; Project     :	STEREO - IMPACT, SWEA
;
; Name        : SWEASTE_L1_COMMON
;
; Purpose     :	setup SWEA Level 1 common block
;               (global constants and variables for SWEA Level 1 processing)
;
; Category    :	STEREO, IMPACT, SWEA
;
; Explanation :	
;
; Syntax      :	SWEA_L1_COMMON
;
; Examples    :	
;
; Inputs      :	
;
; Opt. Inputs :	None.
;
; Outputs     :	
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       : 
;
; Common      : swea_l1_common
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 03-Feb-2006, Peter Schroeder,
;                  UC-Berkeley.
;
; Contact     :	peters@ssl.berkeley.edu
;-
;

common swea_l1_common, swea_energies, SWEA_FULL_ENERGIES, SWEA_DIST_ENERGIES, SWEA_PAD_ENERGIES, SWEA_BEAC_ENERGIES, $
   SWEAV0_A1, SWEAV0_A0, SWEAMOMCOEFFS, $
   SWEATACC, SWEAH, SWEAK, SWEAPADE0, SWEAPADE1, SWEAE0, SWEAE1, $
   energmin, enermoy, energmax

SWEA_DIST_ENERGIES = [0,0,0,1,1,1,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,$
   9,9,9,10,10,10,11,11,11,12,12,12,13,13,13,14,14,14,15,15,15]
;SWEA_PAD_ENERGIES = [80h,80h,80h,80h,80h,80h,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5]
;SWEA_PAD_ENERGIES = [0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5]
SWEA_PAD_ENERGIES = [-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6]
SWEA_BEAC_ENERGIES = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]
SWEA_FULL_ENERGIES = [0,1,2,3,4,5,6,7,8,9,$
			10,11,12,13,14,15,16,17,18,19,$
			20,21,22,23,24,25,26,27,28,29,$
			30,31,32,33,34,35,36,37,38,39,$
			40,41,42,43,44,45,46,47]
SWEAV0_A1 = 0.01243d
SWEAV0_A0 = -24.91d
SWEAMOMCOEFFS = [22d, 10d, 4d, 19d]
SWEATACC = 5.8d-3
SWEAH = 1.746d-7
SWEAK = 6.67d
SWEAPADE0 = [6,7,8,9,10,11]
SWEAPADE1 = [24,25,26,27,28,29]

energmin = [ 323.60932, 122.75   , 46.486225, 17.61878,  6.6777102, 2.5309245, 1.1874535]
energmoy = [ 525.64824, 199.22638, 75.508959, 28.618714, 10.846803, 4.1110559, 1.5581348]
energmax = [ 1056.9518, 323.60932, 122.75   , 46.486225, 17.61878,  6.6777102, 2.5309245]

end
