;-------------------------------------------------------------------------------
;
;   Fichier : $RCSfile: swea_geom_factor.pro,v $, v $Revision: 1.3 $
;
;   Date    : $Date: 2007/04/26 15:18:32 $
;
;   Auteur  : $Author: stereo $
;
;   Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


function swea_geom_factor, sat, t1, t2

;if chksum ne 0 then return, -1

Gr = fltarr(6) ; geometric factor for each phi
Gf = fltarr(16) ; geometric factor for each anodes, phi=0
G = fltarr(16,6) ; geometric factor


;compute SWEA energies
;if not keyword_set(swea_energies) then swea_l1_energies

phimoy = [ 54.17, 32.50, 10.83, -10.83, -32.50, -54.17 ]

; Ahead satellite :
if ( (sat eq "a") or (sat eq "ahead") or (sat eq "sta") ) then begin 

    ;for i = 0, 15 do Gf[i] = 0.000524; geometric factor for phi = 0 degrees
    Gf = [ .000496, .0005835, .0005035, .000532, .0005485, .0005155, .0005715, .0005563, .0005412, .000526, .0005015, .0005885, .0005225, .000531, .000507, .000456]; geometric factor for phi = 0 degrees

    Gr0=1.48e-3 ; relative geometric factor for phii = 0 degrees

    for j = 1, 5 do begin 
        Gr[j] = 1.48e-3-2.31e-6*phimoy[j]+3.67e-7*phimoy[j]^2
    endfor
    Gr[0] = 1.2e-3 ; different for phi> 45 degrees

; Behind satellite :
end else if  ( (sat eq "b") or (sat eq "behind") or (sat eq "stb") ) then begin
    Gf = [ .000348, .000382, .000294, .000349, .000405, .000375, .000320, .000236, .000290, .000291, .000312, .000256, .000353, .0003, .000413, .000328]; geometric factor for phi = 0 degrees
    Gr0=8.8e-4 ; relative geometric factor for phii = 0 degrees

    for j = 0, 5 do begin 
        Gr[j] = 8.80e-4-1.15e-7*phimoy[j]+1.25e-7*phimoy[j]^2
    endfor
    ;Gr[0] = 1.2e-3 ; different for phi> 45 degrees

end else begin
    Gf0 = 0.0; geometric factor for phi = 0 degrees
    Gr0=1 ; relative geometric factor for phii = 0 degrees

    for j = 0, 5 do begin 
        Gr[j] = 0
    endfor
    print,"Error, unknown satellite!!!"
endelse

for i = 0, 15 do begin
    for j = 0, 5 do begin 
        G[i,j] = Gf[i]*Gr[j]/Gr0
    endfor
endfor

return, G

end
