PRO SWEA_CALIBR_NEW, pathtelem, infile, out_path, version, sat, year, month, day, dayofyear, defl, debug=debug, output1=output1
;+
; Project     :	STEREO - IMPACT/SWEA
;
; Name        : SWEA_CALIBR
;
; Purpose     :	Write SWEA data to ASCII file
;
; Category    :	STEREO, IMPACT, SWEA
;
; Explanation :	
;
; Syntax      :	SWEA_CALIBR , SCIDATA, SCID
;
; Examples    :	
;
; Inputs      :	SCIDATA - a structure including SWEA 210 science data
;               DATESTRING - the date string for the filename
;		SCID - the spacecraft ID
;		APID - number a the APID
;
; Opt. Inputs :	None.
;
; Outputs     :	None.
;
;
; History     :	Version 1 (preliminary), 07-Apr-2006, Nicolas Pene,
;                  CESR.
;
; Contact     :	nicolas.pene@cesr.fr
;-
;


swea_l1_common
sep_beacon_common
sweaste_b_common

cdfdir="/DATA/STEREO/DATA/L1_CDF/"+sat

; .............................
; calibration tabs :
calibr=fltarr(16,16,16)
calibr_count=dblarr(16,16,16)
calibr[*,*,*]=0
calibr_count[*,*,*]=0
; .............................
maxpitch=10. ; maximum angle value to take in count two pitch angles


; .............................
; geometric factor :
geom=fltarr(16,6)
geom=swea_geom_factor(sat,0,0)


nb_days=[0,31,28,31,30,31,30,31,31,30,31,30,31]
IF year MOD 4 EQ 0 THEN nb_days[2]=nb_days[2]+1

mth=long(month)
nb_mth=3
IF sat EQ 'ahead' THEN BEGIN
    fsat = 'sta'
    gsat = 'STA'
END ELSE BEGIN
    fsat = 'stb'
    gsat = 'STB'
END

; .............................
; 
; big loop for each month
FOR imonth = mth, mth+nb_mth DO BEGIN
    ;print,"month ",imonth,"    nb_days : ",nb_days[imonth]
    IF mth+1 gt 12 THEN BEGIN
        print,"ERROR : the month number is greater than 12!!!"
        exit
    END

    ; .............................
    ; 
    ; big loop for each days
    FOR iday=1,nb_days[imonth] DO BEGIN

        IF iday LT 10 THEN day = string(iday,'("0",I1)') ELSE day = string(iday,'(I2)')

        IF dayofyear LT 10 THEN doy = string(dayofyear,'("00",I1)') $
        ELSE IF dayofyear LT 100 THEN doy = string(dayofyear,'("0",I2)')  $
        ELSE doy = string(dayofyear,'(I3)') 

        IF imonth lt 10 THEN month = string(imonth,'("0",I1)') $
        ELSE month = string(imonth,'(I2)')

        print
        print, '--------------- '+day+'/'+month+'/'+year +'   --------------- ('+SYSTIME(0)+')'

        ; -----------------------
        ; Lecture MAG CDF V03
        ; -----------------------
        magfile="/DATA/STEREO/DATA/l1data/"+sat+"/mag/"+year+"/"+month+"/"+gsat+"_L1_MAG_"+year+month+day+"_V03.cdf"
        print, '............... MAG  CDF V03 ............... ' + magfile
        id = CDF_OPEN(magfile)
        lire_var_cdf, id,'Epoch',date,err,typ
        cdf_epoch, decalage, 1958, 1, 1, 0, 0, 0, /compute_epoch
        nb_date = N_ELEMENTS(date)
        magdate = date - decalage
        lire_var_cdf, id,'B_SC',mag,err,typ
        nb_rec = N_ELEMENTS(mag[*,0])
        IF nb_rec NE nb_date THEN BEGIN
            print,"ERROR : number of records and dates don't correspond"
            return
        END
        CDF_CLOSE,id
        PRINT, '............... MAG  CDF V03 ............... ('+SYSTIME(0)+')'

        IF 1 eq 0 THEN BEGIN
        ; -----------------------
        ; Lecture comptage telemesure
        ; -----------------------
        maxrec=3000
        julian=dblarr(maxrec)
        distr=fltarr(maxrec,16,80)
        openr, infilelun, ifile, /get_lun
        packet = 0
        common swea_210_common, swea_dist, starttime
        swea_dist=0
        ;print,"dayofyear",dayofyear
        ; ...........................................
        ; genere the "day of year" and L0 file name

        ifile=pathtelem+"/"+year+"/"+month+"/"+infile+doy+"_*.fin"
        ifile = findfile(ifile)
        ifile = ifile[N_ELEMENTS(ifile)-1]
        ; ...........................................
        print,ifile
        ; -------------------------------------------
        ;  Boucle de lecture du fichier d'entree
        i=0
        print,'debut boucle read_stereo_pkt',iday,' ',imonth,' ',year, systime(0)
        while (n_elements(packet) ne 0) do begin
            read_stereo_pkt, infilelun, packet
            if n_elements(packet) ne 0 then begin
                packet_apid = parse_stereo_pkt(packet,/apid)
                if (packet_apid eq '210'XU) then begin
                    ;[210] Distribution normal mode
                    foo = swea_210(packet)
                    if datatype(foo,2) eq 8 then begin

                        utcsec = utc2sec(foo.TIME)
                        utcpkttim = sec2utc(utcsec + double(foo.SWEADISTINT)/2d)
                        utc = anytim2utc(utcpkttim,/external)
                        julian[i] = tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond
                        distr[i,*,*] = foo.distribution
                        ;print,FORMAT = '(3("  ",F16.0))', julian[i]
                        i=i+1

                    endif
                endif
            endif
        endwhile
        free_lun, infilelun
        print,'fin boucle read_stereo_pkt', systime(0)
        nb_dist=i
        END

        IF 1 eq 1 THEN BEGIN
        ; -----------------------
        ; Lecture DIST CDF V02
        ; -----------------------
        countfile = cdfdir+"/"+gsat+"_L1_SWEA_DIST_"+year+month+day+"_V02.cdf"
        print, '............... DIST CDF V02 ............... ' + countfile
        id = CDF_OPEN(countfile)
        lire_var_cdf, id,'Epoch',date,err,typ
        cdf_epoch, decalage, 1958, 1, 1, 0, 0, 0, /compute_epoch
        distributioncdf_date = date - decalage
        julian = distributioncdf_date
        lire_var_cdf, id,'Distribution',distributioncdf,err,typ
        CDF_CLOSE,id
        nb_dist = N_ELEMENTS(distributioncdf[*,0,0])
        PRINT, '............... DIST CDF V02 ............... ('+SYSTIME(0)+')'
        END

        IF 1 eq 0 THEN BEGIN
        IF N_ELEMENTS(distributioncdf_date) NE nb_dist THEN BEGIN
            print,'pb n_elements'
            stop
        END
        ind = WHERE (julian[0:nb_dist] - distributioncdf_date NE 0)
        IF ind[0] NE -1 THEN BEGIN
            print,'pb date'
            stop
        END
        print,'debut boucle comparaison'
        FOR i=0,nb_dist-1 DO BEGIN
            coup_telem = TRANSPOSE(distr[i,*,*])
            coup_cdf   = distributioncdf[i,*,*]
            ind = WHERE (coup_telem - coup_cdf ne 0)
            IF ind[0] NE -1 THEN BEGIN
                print,'pb coup i=',i
                stop
            END
        END
        print,'fin boucle comparaison'
        END

        ; -----------------------
        ; Calcul Pitch-Angle
        ; -----------------------
        pitch = fltarr(nb_dist,16,6)
        ko=0.
        FOR j=0,nb_dist-1 DO BEGIN
            FOR k=ko,nb_date-1,1. DO BEGIN
                IF julian[j] LE magdate[k] THEN BEGIN
                    pitch_str = pitchangle(mag[k,*],sat)
                    pitch[j,*,*] = pitch_str.pitch
                    ko=k+1
                    BREAK
                END
            END
        END


        ; -----------------------
        ; Transfert 80 -> 96
        ; -----------------------
        distrib = fltarr(nb_dist,16,16,6) ; -> (record,energy,anode,elevation)
        FOR anod=0,15 DO BEGIN
            distrib[*, *, anod, 0        ] = distributioncdf[*, anod/2,                  *]/2. ;e=0
            distrib[*, *, anod, [1,2,3,4]] = distributioncdf[*, 8+([1,2,3,4]-1)*16+anod, *]
            distrib[*, *, anod, 5        ] = distributioncdf[*, 72+anod/2,               *]/2. ;e=5
        END


        ; -----------------------
        ; Calcul
        ; -----------------------
        FOR j=0,nb_dist-1 DO BEGIN

            FOR a1=0,15 DO BEGIN
                IF ABS(pitch[j,a1,defl]-90) LE maxpitch/2 THEN BEGIN
                    FOR a2=a1+1,15 DO BEGIN
                        IF ABS(pitch[j,a2,defl]-90) LE maxpitch/2 THEN BEGIN
                            FOR energ=0,15 DO BEGIN
                                IF (distrib[j,energ,a1,defl] NE 0) AND (distrib[j,energ,a2,defl] NE 0) THEN BEGIN

                                    calibr[energ,a1,a2] += distrib[j,energ,a1,defl]/distrib[j,energ,a2,defl]
                                    calibr_count[energ,a1,a2] ++

                                END
                            END
                        END
                    END
                END
            END

        END

        ; increment dayofyear :
        dayofyear=dayofyear+1

    END
    ; end of the days loop
    ;.................................

END
; end of the months loop
;.................................

; moyenne :
for energ=0,15 do $
   for a1=0,15 do $
       for a2=(a1+1),15 do $
        if ( calibr_count[energ,a1,a2] ne 0 ) then $ 
            calibr[energ,a1,a2]=calibr[energ,a1,a2]/calibr_count[energ,a1,a2]


;---------------------------------------
; Output :
if (mth lt 10) then month = string(mth,'("0",I1)') $
else  month = string(mth,'(I2)')

mth2=mth+nb_mth
if (mth2 lt 10) then month2 = string(mth2,'("0",I1)') $
else  month2 = string(mth2,'(I2)')

;---------------------------------------
; data file (for test) :
if keyword_set(output1) then begin
    datafile = out_path+'/'+fsat+'_swea_'+year+month+'-'+year+month2+'_def'+defl+'_v'+version+'.txt'

        filematch = file_search(datafile, count = filecount)

        openw,unit,datafile,/get_lun

        printf,unit, " ==================================="
        printf,unit, "        Calibr. table"
        printf,unit

        ; print calib table :
        for energ=0,15 do begin
           printf,unit, " ----------"
           printf,unit, " energy : ",energ
           printf,unit

           for a2=0,15 do begin
           ;a2=15
                printf,unit, format = '( ("a/",I2," | "), 16(" ",F4.2) )',a2,calibr[energ,*,a2]
           endfor

           printf,unit
       endfor

       ; print for each calib the number of records :
       printf,unit
       printf,unit, " ==================================="
       printf,unit, "        Coef. table"
       printf,unit


       for energ=0,15 do begin
           printf,unit, " ----------"
           printf,unit, " energy : ",energ
           printf,unit

           for a2=0,15 do begin
           ;a2=15
                printf,unit, format = '(I2, (" | "), 16(" ",F8.0) )',a1,calibr_count[energ,*,a2]
           endfor

           printf,unit
       endfor




    close, unit
    free_lun,unit
endif

;---------------------------------------
; energies data file (for test) :
energfile = out_path+'/'+fsat+'_energ_'+year+month+'-'+year+month2+'_def'+defl+'_v'+version+'.txt'

	filematch = file_search(energfile, count = filecount)

	openw,unit,energfile,/get_lun

    printf,unit, " ==================================="
    printf,unit, "        Calibr. table"
    printf,unit

    ; print calib table :
    ;for a2=0,15 do begin
    for a2=1,15 do begin
       printf,unit, " ----------"
       printf,unit, " anode : ",a2
       printf,unit

       ;for energ=0,15 do begin
       for energ=5,14 do begin
            printf,unit, format = '( ("e",I2," |"), 16(" ",F4.2) )',energ,calibr[energ,*,a2]
       endfor

       printf,unit
   endfor

close, unit
free_lun,unit

;---------------------------------------
; another interesting result
energfile = out_path+'/'+fsat+'_coef_'+year+month+'-'+year+month2+'_def'+defl+'_v'+version+'.txt'

	filematch = file_search(energfile, count = filecount)

	openw,unit,energfile,/get_lun


    coefo = fltarr(16)
    coefomin = fltarr(16)
    coefomax = fltarr(16)
    deltacoefo = fltarr(16)
    nbcount=8.
    for a2=1,15 do begin
       printf,unit, " ----------"
       printf,unit, " anode : ",a2

       ;calcul moy :
       deltacoefo[*]=0.
       coefomin[*]=3.
       coefomax[*]=0.
       coefo[*]=0.
       for energ=6,13 do begin
           for cf=0,(a2-1) do begin
               coefo[cf] = coefo[cf]+calibr[energ,cf,a2]
               if (calibr[energ,cf,a2] lt coefomin[cf]) then coefomin[cf]=calibr[energ,cf,a2]
               if (calibr[energ,cf,a2] gt coefomax[cf]) then coefomax[cf]=calibr[energ,cf,a2]
           endfor
       endfor
       for cf=0,(a2-1) do begin 
            coefo[cf] = coefo[cf]/nbcount
            deltacoefo[cf] = coefomax[cf]-coefomin[cf]
       endfor
       printf,unit, format = '( ("coefs :"), 16(" ",F4.2) )',coefo[*]
       printf,unit, format = '( ("delta :"), 16(" ",F4.2) )',deltacoefo[*]
       print, format = '( ("a",I2," :"), 16(" ",F4.2) )',a2,coefo[*]

       printf,unit
   endfor

close, unit
free_lun,unit


; ---------------
; debug
if keyword_set(debug) then begin
    energ=3
    anod=0

    ;for energ=0,15 do begin
    print,"--------------"
    print,"enregy : ",energ
    for e=0,5 do begin
        print,pitch[0,anod,e],distrib[0,energ,anod,e]
    endfor
    print
    ;endfor

    ; debug end
    ; ---------------
    print,"nb dist : ",nb_dist
endif


end
