PRO SWEA_CALIBR, pathtelem, infile, out_path, version, sat, year, month, day, dayofyear, defl, debug=debug, output1=output1
;+
; Project     :	STEREO - IMPACT/SWEA
;
; Name        : SWEA_CALIBR
;
; Purpose     :	Write SWEA data to ASCII file
;
; Category    :	STEREO, IMPACT, SWEA
;
; Explanation :	
;
; Syntax      :	SWEA_CALIBR , SCIDATA, SCID
;
; Examples    :	
;
; Inputs      :	SCIDATA - a structure including SWEA 210 science data
;               DATESTRING - the date string for the filename
;		SCID - the spacecraft ID
;		APID - number a the APID
;
; Opt. Inputs :	None.
;
; Outputs     :	None.
;
;
; History     :	Version 1 (preliminary), 07-Apr-2006, Nicolas Pene,
;                  CESR.
;
; Contact     :	nicolas.pene@cesr.fr
;-
;


swea_l1_common
sep_beacon_common
sweaste_b_common

cdfdir="/DATA/STEREO/DATA/L1_CDF/"+sat

; .............................
; calibration tabs :
calibr=fltarr(16,16,16)
calibr_count=dblarr(16,16,16)
calibr[*,*,*]=0
calibr_count[*,*,*]=0
; .............................
maxpitch=10. ; maximum angle value to take in count two pitch angles


; .............................
; geometric factor :
geom=fltarr(16,6)
geom=swea_geom_factor(sat,0,0)


nb_days=[0,31,28,31,30,31,30,31,31,30,31,30,31]
if ( (year mod 4) eq 0 ) then nb_days[2]=nb_days[2]+1

mth=long(month)
nb_mth=3
; .............................
; 
; big loop for each month
for imonth = mth, mth+nb_mth do begin
    print,"month ",imonth,"    nb_days : ",nb_days[imonth]
    if (mth+1 gt 12) then begin
        print,"ERROR : the month number is greater than 12!!!"
        exit
    endif    

    ; .............................
    ; 
    ; big loop for each days
    for iday=1,nb_days[imonth] do begin

        print,"dayofyear",dayofyear
        ; ...........................................
        ; genere the "day of year" and L0 file name
        if (dayofyear lt 10) then doy = string(dayofyear,'("00",I1)') $
        else if (dayofyear lt 100) then doy = string(dayofyear,'("0",I2)')  $
        else doy = string(dayofyear,'(I3)') 

        if (imonth lt 10) then month = string(imonth,'("0",I1)') $
        else  month = string(imonth,'(I2)')

        ifile=pathtelem+"/"+year+"/"+month+"/"+infile+doy+"_*.fin"
        ; ...........................................

        openr, infilelun, ifile, /get_lun
        packet = 0


        if (sat eq 'ahead') then begin 
            fsat = 'sta'
            gsat = 'STA'
        endif else begin 
            fsat = 'stb'
            gsat = 'STB'
        endelse

        ; -----------------------
        ; open the CDF MAG file :

        if (iday lt 10) then day = string(iday,'("0",I1)') $
        else day = string(iday,'(I2)')

        magfile=cdfdir+"/"+gsat+"_L1_MAG_"+year+month+day+"_V02.cdf"
        print, "magday : ",day

        id = CDF_OPEN(magfile)

        lire_var_cdf, id,'Epoch',date,err,typ
        cdf_epoch, decalage, 1958, 1, 1, 0, 0, 0, /compute_epoch
        nb_date = N_ELEMENTS(date)
        magdate = date - decalage

        lire_var_cdf, id,'B_SC',mag,err,typ
        nb_rec = N_ELEMENTS(mag)
        nb_rec = nb_rec/3
        if (nb_rec ne nb_date) then begin
            print,"ERROR : number of records and dates don't correspond"
            return
        endif

        CDF_CLOSE,id

        i=0
        ;maxrec=2880
        maxrec=3000
        julian=dblarr(maxrec)
        distr=fltarr(maxrec,16,80)
        ; -------------------------------------------
        ;  Boucle de lecture du fichier d'entree


        while (n_elements(packet) ne 0) do begin
            read_stereo_pkt, infilelun, packet
            if n_elements(packet) ne 0 then begin
                packet_apid = parse_stereo_pkt(packet,/apid)
                if (packet_apid eq '210'XU) then begin
                    ;[210] Distribution normal mode
                    foo = swea_210(packet)
                    if datatype(foo,2) eq 8 then begin

                        utcsec = utc2sec(foo.TIME)
                        utcpkttim = sec2utc(utcsec + double(foo.SWEADISTINT)/2d)
                        utc = anytim2utc(utcpkttim,/external)
                        julian[i] = tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond
                        distr[i,*,*] = foo.distribution
                        ;print,FORMAT = '(3("  ",F16.0))', julian[i]
                        i=i+1

                    endif
                endif
            endif
        endwhile


        close, infilelun
        free_lun, infilelun


        nb_dist=i

        ;---------------------------------------
        ; create pitch angles :
        ko=0.
        pitch=fltarr(nb_dist,16,6)
        distrib=fltarr(maxrec,16,16,6) ; -> (record,energy,anode,elevation)


        for j=0,nb_dist-1 do begin


            for k=ko,nb_date-1,1. do begin

               if ( julian[j] le magdate[k] ) then begin

                    ; now this is pitch-angle time :
                    ;print,ko,nb_date, mag[k,*]
                    pitch_str=pitchangle(mag[k,*],sat)
                    pitch[j,*,*]=pitch_str.pitch

                   ko=k+1
                   break
               endif

           endfor


           ;---------------------------------------
           ; create distrib table :
           for energ=0,15 do begin
               for anod=0,15 do begin
                       ; <--- ici
                       distrib[j,energ,anod,0] = distr[0,energ,anod/2]/2. ;e=0
                       for e=1,4 do distrib[j,energ,anod,e] = distr[0,energ, 8+(e-1)*16+anod]
                       distrib[j,energ,anod,5] = distr[0,energ, 72+anod/2]/2. ;e=5
               endfor
           endfor



           ;---------------------------------------
           ; star the calibration tab :

           for energ=0,15 do begin
               for a1=0,15 do begin
                   for a2=(a1+1),15 do begin
                       ; pour l'elevation, on ne traite pas les elevation extremes
                       ;for elev1=1,4 do begin
                         ;for elev2=1,4 do begin
                         elev1=defl
                         elev2=defl
                            ;diffpitch=abs(pitch[j,a1,elev1]-pitch[j,a2,elev2])
                            diffpitch1=abs(pitch[j,a1,elev1]-90)
                            diffpitch2=abs(pitch[j,a2,elev2]-90)
                            if ( ( diffpitch1 le maxpitch/2 ) && $
                                 ( diffpitch2 le maxpitch/2 ) && $
                                 ( distrib[j,energ,a1,elev1] gt 1e-7 ) && $
                                 ( distrib[j,energ,a2,elev2] gt 1e-7 ) ) then begin

                                     ;coef=maxpitch-diffpitch
                                     coef=1.
                                     calibr[energ,a1,a2]= $ 
                                      calibr[energ,a1,a2]+ $
                                      ( (distrib[j,energ,a1,elev1]*geom[a2,elev2])/(distrib[j,energ,a2,elev2]*geom[a1,elev1]) )*coef
                                     calibr_count[energ,a1,a2]=calibr_count[energ,a1,a2]+coef
                                     ;if (a1 eq 5 && a2 eq 6 && energ eq 12) then print,calibr_count[energ,a1,a2]

                            endif
                         ;endfor ; elev1
                       ;endfor ; elev2
                   endfor
               endfor
           endfor

        endfor

        ; increment dayofyear :
        dayofyear=dayofyear+1

    endfor
    ; end of the days loop
    ;.................................

endfor
; end of the months loop
;.................................

; moyenne :
for energ=0,15 do $
   for a1=0,15 do $
       for a2=(a1+1),15 do $
        if ( calibr_count[energ,a1,a2] ne 0 ) then $ 
            calibr[energ,a1,a2]=calibr[energ,a1,a2]/calibr_count[energ,a1,a2]


;---------------------------------------
; Output :
if (mth lt 10) then month = string(mth,'("0",I1)') $
else  month = string(mth,'(I2)')

mth2=mth+nb_mth
if (mth2 lt 10) then month2 = string(mth2,'("0",I1)') $
else  month2 = string(mth2,'(I2)')

;---------------------------------------
; data file (for test) :
if keyword_set(output1) then begin
    datafile = out_path+'/'+fsat+'_swea_'+year+month+'-'+year+month2+'_def'+defl+'_v'+version+'.txt'

        filematch = file_search(datafile, count = filecount)

        openw,unit,datafile,/get_lun

        printf,unit, " ==================================="
        printf,unit, "        Calibr. table"
        printf,unit

        ; print calib table :
        for energ=0,15 do begin
           printf,unit, " ----------"
           printf,unit, " energy : ",energ
           printf,unit

           for a2=0,15 do begin
           ;a2=15
                printf,unit, format = '( ("a/",I2," | "), 16(" ",F4.2) )',a2,calibr[energ,*,a2]
           endfor

           printf,unit
       endfor

       ; print for each calib the number of records :
       printf,unit
       printf,unit, " ==================================="
       printf,unit, "        Coef. table"
       printf,unit


       for energ=0,15 do begin
           printf,unit, " ----------"
           printf,unit, " energy : ",energ
           printf,unit

           for a2=0,15 do begin
           ;a2=15
                printf,unit, format = '(I2, (" | "), 16(" ",F8.0) )',a1,calibr_count[energ,*,a2]
           endfor

           printf,unit
       endfor




    close, unit
    free_lun,unit
endif

;---------------------------------------
; energies data file (for test) :
energfile = out_path+'/'+fsat+'_energ_'+year+month+'-'+year+month2+'_def'+defl+'_v'+version+'.txt'

	filematch = file_search(energfile, count = filecount)

	openw,unit,energfile,/get_lun

    printf,unit, " ==================================="
    printf,unit, "        Calibr. table"
    printf,unit

    ; print calib table :
    ;for a2=0,15 do begin
    for a2=1,15 do begin
       printf,unit, " ----------"
       printf,unit, " anode : ",a2
       printf,unit

       ;for energ=0,15 do begin
       for energ=5,14 do begin
            printf,unit, format = '( ("e",I2," |"), 16(" ",F4.2) )',energ,calibr[energ,*,a2]
       endfor

       printf,unit
   endfor

close, unit
free_lun,unit

;---------------------------------------
; another interesting result
energfile = out_path+'/'+fsat+'_coef_'+year+month+'-'+year+month2+'_def'+defl+'_v'+version+'.txt'

	filematch = file_search(energfile, count = filecount)

	openw,unit,energfile,/get_lun


    coefo = fltarr(16)
    coefomin = fltarr(16)
    coefomax = fltarr(16)
    deltacoefo = fltarr(16)
    nbcount=8.
    for a2=1,15 do begin
       printf,unit, " ----------"
       printf,unit, " anode : ",a2

       ;calcul moy :
       deltacoefo[*]=0.
       coefomin[*]=3.
       coefomax[*]=0.
       coefo[*]=0.
       for energ=6,13 do begin
           for cf=0,(a2-1) do begin
               coefo[cf] = coefo[cf]+calibr[energ,cf,a2]
               if (calibr[energ,cf,a2] lt coefomin[cf]) then coefomin[cf]=calibr[energ,cf,a2]
               if (calibr[energ,cf,a2] gt coefomax[cf]) then coefomax[cf]=calibr[energ,cf,a2]
           endfor
       endfor
       for cf=0,(a2-1) do begin 
            coefo[cf] = coefo[cf]/nbcount
            deltacoefo[cf] = coefomax[cf]-coefomin[cf]
       endfor
       printf,unit, format = '( ("coefs :"), 16(" ",F4.2) )',coefo[*]
       printf,unit, format = '( ("delta :"), 16(" ",F4.2) )',deltacoefo[*]
       print, format = '( ("a",I2," :"), 16(" ",F4.2) )',a2,coefo[*]

       printf,unit
   endfor

close, unit
free_lun,unit


; ---------------
; debug
if keyword_set(debug) then begin
    energ=3
    anod=0

    ;for energ=0,15 do begin
    print,"--------------"
    print,"enregy : ",energ
    for e=0,5 do begin
        print,pitch[0,anod,e],distrib[0,energ,anod,e]
    endfor
    print
    ;endfor

    ; debug end
    ; ---------------
    print,"nb dist : ",nb_dist
endif


end
