;+
; Project     :	STEREO - IMPACT, SWEA
;
; Name        : SWEA_215
;
; Purpose     :	Process SWEA Pkt 215 Into Physical Units
;
; Category    :	STEREO, IMPACT, SWEA
;
; Explanation :	
;
; Syntax      :	data = SWEA_215(PACKET)
;
; Examples    :	
;
; Inputs      :	PACKET - an IMPACT SWEA Spectra packet (apid=215h)
;
; Opt. Inputs :	None.
;
; Outputs     :	A structure containing SWEA PAD data
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       :	None
;
; Common      : swea_l1_common
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 03-Feb-2006, Peter Schroeder,
;                  UC-Berkeley.
;
; Contact     :	peters@ssl.berkeley.edu
;-
;

function swea_215, packet

common swea_l1_common ;use common block

;check checksum
chksum = 0b
hdrbytarray = bytarr(11)
load_bytarr,packet.pkt,hdrbytarray
for i = 0, 10 do chksum += hdrbytarray[i]
for i = 0, 260 do chksum += packet.dat[i]
if chksum ne 0 then return, -1

;compute SWEA energies
if not keyword_set(swea_energies) then swea_l1_energies

;figure out rotation matrix from SWEA to Spacecraft Coordinates
if (packet.grh.spacecraft_id eq 'EA'XU) then SWEATOSC = 40d else $
   SWEATOSC = -140d

SWEATOSC = SWEATOSC/!RADEG

SWEASCrotmat = [ [1, 0, 0], [0, cos(SWEATOSC), sin(SWEATOSC)], $
   [0, -sin(SWEATOSC), cos(SWEATOSC)] ]

;grab SWEA bytes from packet, swap bytes   
rawbytes = packet.dat
swap,rawbytes

;calculate packet time
utcpkttim = parse_stereo_pkt(packet,/pkt_date)

;raw byte values from packet
rawdatastr = { $
   SWEAMCPDACSet: rawbytes[0], $
   SWEAMCPHeater: rawbytes[1], $
   SWEADistInt: rawbytes[2], $
   SWEABurstInt: rawbytes[3], $
   SWEAPADInt: rawbytes[4], $
   SWEARot: rawbytes[5], $
   SWEAModeID: rawbytes[6], $
   SWEAManualV0: rawbytes[7], $
   SWEASweepMax: uint_from_bytes(rawbytes[8:9]), $
   SWEASweepRate: uint_from_bytes(rawbytes[10:11]), $
   SWEASweepOffset: uint_from_bytes(rawbytes[12:13]), $
   SWEASweepDefltStep: uint_from_bytes(rawbytes[14:15]), $
   SWEAMomInt: rawbytes[16], $
   SWEASpecInt: rawbytes[17], $
   IAutoLUT: rawbytes[18], $
   N: ulonarr(5,48), $
   Checksum: rawbytes[260] }

utcsec = utc2sec(utcpkttim)

for i = 0,4 do $
          for j =0,47 do rawdatastr.N[i,j] = impact_log_uncomp(rawbytes[19+i*48+j])*(2ul)^(10ul)


ret_struct = { $
  TIME: utcpkttim, $
  SWEAMCPDACSet: rawdatastr.SWEAMCPDACSet , $
  SWEAMCPHeater: rawdatastr.SWEAMCPHeater , $
  SWEADistInt: rawdatastr.SWEADistInt , $
  SWEABurstInt: rawdatastr.SWEABurstInt , $
  SWEAPADInt: rawdatastr.SWEAPADInt , $
  SWEARot: rawdatastr.SWEARot , $
  SWEAModeID: rawdatastr.SWEAModeID , $
  SWEAManualV0: rawdatastr.SWEAManualV0 , $
  SWEASweepMax: rawdatastr.SWEASweepMax , $
  SWEASweepRate: rawdatastr.SWEASweepRate , $
  SWEASweepOffset: rawdatastr.SWEASweepOffset , $
  SWEASweepDefltStep: rawdatastr.SWEASweepDefltStep , $
  SWEAMomInt: rawdatastr.SWEAMomInt , $
  SWEASpecInt: rawdatastr.SWEASpecInt , $
  IAutoLUT: rawdatastr.IAutoLUT , $
  N: rawdatastr.N }

return, ret_struct

end
