;+
; Project     :	STEREO - IMPACT, SWEA
;
; Name        : SWEA_214
;
; Purpose     :	Process SWEA Pkt 214 Into Physical Units
;
; Category    :	STEREO, IMPACT, SWEA
;
; Explanation :	
;
; Syntax      :	data = SWEA_214(PACKET)
;
; Examples    :	
;
; Inputs      :	PACKET - an IMPACT SWEA Fast Housekeeping packet (apid=214h)
;
; Opt. Inputs :	None.
;
; Outputs     :	A structure containing SWEA Distribution data
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       :	None
;
; Common      : swea_l1_common
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 03-Feb-2006, Peter Schroeder,
;                  UC-Berkeley.
;
; Contact     :	peters@ssl.berkeley.edu
;-
;

function swea_214, packet

common swea_l1_common ;use common block
common swea_214_common, swea_dist, starttime ;need common block for distribution

;check checksum
chksum = 0b
hdrbytarray = bytarr(11)
load_bytarr,packet.pkt,hdrbytarray
for i = 0, 10 do chksum += hdrbytarray[i]
for i = 0, 260 do chksum += packet.dat[i]
if chksum ne 0 then return, -1


;grab SWEA bytes from packet, swap bytes   
rawbytes = packet.dat
swap,rawbytes

;calculate packet time
utcpkttim = parse_stereo_pkt(packet,/pkt_date)

;raw byte values from packet
rawdatastr = { $
   SWEAModeID: rawbytes[0], $
   SWEALSB: rawbytes[1], $
   SWEAMSB: rawbytes[2], $
   SWEAHkpMSB: bytarr(128), $
   SWEAHkpLSB: intarr(128), $
   Checksum: rawbytes[260] }

starttime = utcpkttim

nb = 3
;for i = 0, 255 do rawdatastr.SWEAHkp[i] = rawbytes[4+i]
for i = 0,127 do begin
		rawdatastr.SWEAHkpLSB[i] = 0

	; first octet treatment :
	for j = 0,7 do begin
		if ( (rawbytes[nb+2*i]/2^(7-j)) ne 0 ) then begin
			rawdatastr.SWEAHkpLSB[i] = rawdatastr.SWEAHkpLSB[i]+2^(11-j)
			rawbytes[nb+2*i] = rawbytes[nb+2*i]-2^(7-j)
		endif
	endfor

	; second octet treatment :
	for j = 0,3 do begin
		if ( (rawbytes[nb+2*i+1]/2^(7-j)) ne 0 ) then begin
			rawdatastr.SWEAHkpLSB[i] = rawdatastr.SWEAHkpLSB[i]+2^(3-j)
			rawbytes[nb+2*i+1] = rawbytes[nb+2*i+1]-2^(7-j)
		endif
	endfor
	rawdatastr.SWEAHkpMSB[i] = rawbytes[nb+2*i+1]


endfor

ret_struct = { $
 time: starttime, $
 SWEAModeID: rawdatastr.SWEAModeID, $
 SWEALSB: rawdatastr.SWEALSB, $
 SWEAMSB: rawdatastr.SWEAMSB, $
 SWEAHkpLSB: rawdatastr.SWEAHkpLSB, $
 SWEAHkpMSB: rawdatastr.SWEAHkpMSB }

return, ret_struct

end
