PRO SWEA2BIN, SCIDATA, SCID, APID, out_path, version, nom, fd, manu=manu
;+
; Project     :	STEREO - IMPACT/SWEA
;
; Name        : SWEA_TO_ASCII
;
; Purpose     :	Write SWEA data to ASCII file
;
; Category    :	STEREO, IMPACT, SWEA
;
; Explanation :	
;
; Syntax      :	SWEA_TO_ASCII , SCIDATA, SCID
;
; Examples    :	
;
; Inputs      :	SCIDATA - a structure including SWEA 210 science data
;               DATESTRING - the date string for the filename
;		SCID - the spacecraft ID
;		APID - number a the APID
;
; Opt. Inputs :	None.
;
; Outputs     :	None.
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       :	None
;
; Common      : None
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 07-Apr-2006, Nicolas Pene,
;                  CESR.
;
; Contact     :	nicolas.pene@cesr.fr
;-
;

IF N_ELEMENTS(manu) EQ 0 THEN BEGIN

	ext='bin' ; output file name extention

	if (SCID eq 'EA'XU) then SCSTRING = 'sta' $
	else SCSTRING = 'stb'

	; get the packet date :
	utc_d = anytim2utc(SCIDATA.TIME,/external)
	if ((utc_d.day lt 10) and (utc_d.month lt 10)) then datestr = string(utc_d.year,utc_d.month,utc_d.day,'(I4,"0",I1,"0",I1)') $
	else if ((utc_d.day lt 10) and (utc_d.month ge 10)) then datestr=string(utc_d.year,utc_d.month,utc_d.day,'(I4,I2,"0",I1)') $
	else if ((utc_d.day ge 10) and (utc_d.month lt 10)) then datestr=string(utc_d.year,utc_d.month,utc_d.day,'(I4,"0",I1,I2)') $
	else datestr=string(utc_d.year,utc_d.month,utc_d.day,'(I4,I2,I2)')

	;---------------------------------------

	if      (APID eq '210'XU) then filename = SCSTRING+'_l1_swea_dist_'+datestr+'_v'+version+'.'+ext $
	else if (APID eq '211'XU) then filename = SCSTRING+'_l1_swea_disb_'+datestr+'_v'+version+'.'+ext $
	else if (APID eq '212'XU) then filename = SCSTRING+'_l1_swea_padx_'+datestr+'_v'+version+'.'+ext $
	else if (APID eq '213'XU) then filename = SCSTRING+'_l1_swea_momx_'+datestr+'_v'+version+'.'+ext $
	else if (APID eq '214'XU) then filename = SCSTRING+'_l1_swea_fhkp_'+datestr+'_v'+version+'.'+ext $
	else if (APID eq '215'XU) then filename = SCSTRING+'_l1_swea_spec_'+datestr+'_v'+version+'.'+ext $
	else exit 

	; Patch 25 mai 2019: à cause des common dans swea_210 et swea_211 qui ont un effet mémoire, on peut se retrouver
	; avec des données datées de la veille.
	; Ce test permet de supprimer ces données
	; Ca n'arrive pas si on traite juste un jour de données (ex: 20190305) mais ca arrive si on traite 2 jours (exp: 20190304 à 20190305)
	if datestr NE STRMID(out_path,STRLEN(out_path)-8,8) then RETURN

	;SOURCE_FILE = concat_dir('$SWEA_CALIB_DATA', SOURCE_FILE)

	filename=out_path+'/'+filename
	if filename NE nom then stop
	;filematch = file_search(filename, count = filecount)
	OPENU,unit,filename,/append,/SWAP_IF_LITTLE_ENDIAN,/GET_LUN

END


; Distribution packet :
if ((APID eq '210'XU) or (APID eq '211'XU)) then begin

	utcsec = utc2sec(SCIDATA.TIME)
	utcpkttim = sec2utc(utcsec + double(SCIDATA.SWEADISTINT)/2d)
	utc = anytim2utc(utcpkttim,/external)

	julian= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond

	IF N_ELEMENTS(manu) EQ 0 THEN BEGIN
		for a = 0,79 do for e = 0,15 do writeu, unit, SCIDATA.DISTRIBUTION[e,a]
	END ELSE BEGIN
		IF fd EQ -1 THEN OPENW, fd, nom, /SWAP_IF_LITTLE_ENDIAN, /GET_LUN
		WRITEU, fd, julian, SCIDATA.SWEAModeID, SCIDATA.DISTRIBUTION
	END

; Pitch Angle packet :
endif else if (APID eq '212'XU) then begin

	utcsec = utc2sec(SCIDATA.TIME)

	for i=0,2 do begin
		utcpkttim = sec2utc(utcsec + double(SCIDATA.SWEAPADINT)*(double(i)+0.5d))
		utc = anytim2utc(utcpkttim,/external)
		julian= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond

		writeu, unit,$
			julian, SCIDATA.SWEAMODEID,$
			SCIDATA.SWEAPAD[i].MagAz,SCIDATA.SWEAPAD[i].MagEl
		for e = 0,6 do $
		   for d = 0,5 do $
		     for a =0,1 do writeu, unit, SCIDATA.SWEAPAD[i].PAD[e,d,a] 

	endfor


; Moment packet :
endif else if (APID eq '213'XU) then begin

	julian = dblarr(9)
	utcsec = utc2sec(SCIDATA.TIME)

	for i=0,8 do begin
		utcpkttim = sec2utc(utcsec + double(SCIDATA.SWEAMOMINT)*(double(i)+0.5d))
		utc = anytim2utc(utcpkttim,/external)
		julian[i]= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond
	endfor


	Ve = fltarr(3,9)
	Ve[0,*] = SCIDATA.MOMENTS.NVx
	Ve[1,*] = SCIDATA.MOMENTS.NVy
	Ve[2,*] = SCIDATA.MOMENTS.NVz

	Pe = fltarr(6,9)
	Pe[0,*] = SCIDATA.MOMENTS.NPxx
	Pe[1,*] = SCIDATA.MOMENTS.NPyy
	Pe[2,*] = SCIDATA.MOMENTS.NPzz
	Pe[3,*] = SCIDATA.MOMENTS.NPxy
	Pe[4,*] = SCIDATA.MOMENTS.NPxz
	Pe[5,*] = SCIDATA.MOMENTS.NPyz

	He = fltarr(3,9)
	He[0,*] = SCIDATA.MOMENTS.NHx
	He[1,*] = SCIDATA.MOMENTS.NHy
	He[2,*] = SCIDATA.MOMENTS.NHz

	N = fltarr(9)
	V0 = bytarr(9)
	hkp = bytarr(9)
	N[*] = SCIDATA.MOMENTS.N
	V0[*] = SCIDATA.MOMENTS.V0
	hkp[*] = SCIDATA.MOMENTS.SWEADHKP


	for i=0,8 do begin

		writeu, unit,$
			julian[i], SCIDATA.SWEAMODEID,$
			SCIDATA.SWEASWEEPMAX, SCIDATA.SWEASWEEPRATE,$
			SCIDATA.SWEASWEEPDEFLSTEP, N[i], Ve[*,i],$
			Pe[*,i], He[*,i], V0[i], hkp[i]

	endfor
    ;print,"VO 213 : ",V0[0], 


; Housekeeping packet :
endif else if (APID eq '214'XU) then begin


	utc = anytim2utc(SCIDATA.TIME,/external)
	julian= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond

	writeu, unit, $
		julian, SCIDATA.SWEAModeID,SCIDATA.SWEAMSB,SCIDATA.SWEALSB
	;Housekeeping :
	writeu, unit, SCIDATA.SWEAHkpMSB,SCIDATA.SWEAHkpLSB


; Spectra packet :
endif else if (APID eq '215'XU) then begin


	utcsec = utc2sec(SCIDATA.TIME)

	;------------------------------------------
	;	Write SWEA spectra
			
	for i=0,4 do begin
		utcpkttim = sec2utc(utcsec + double(SCIDATA.SWEASPECINT)*(double(i)+0.5d))
		utc = anytim2utc(utcpkttim,/external)

		julian= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond

		writeu, unit, julian, SCIDATA.SWEAMCPDACSet, SCIDATA.SWEAMCPHeater, $
			      SCIDATA.SWEARot, SCIDATA.SWEAModeID, SCIDATA.SWEAManualV0, $
			      SCIDATA.SWEASweepMax, SCIDATA.SWEASweepRate, SCIDATA.SWEASweepOffset, SCIDATA.SWEASweepDefltStep, $
			      SCIDATA.IAutoLUT
		writeu, unit, SCIDATA.N[i,*]

	end

endif

IF N_ELEMENTS(manu) EQ 0 THEN BEGIN
	free_lun,unit
END

end
