PRO PITCHGEN, SCIDATA, SCID, out_path, version, energy=energy, pitchtime=pitchtime, pitch1=pitch1, cl_pitch=cl_pitch, cl_pad=cl_pad
;+
; Project     :	STEREO - IMPACT/SWEA
;
; Name        : SWEA_TO_ASCII
;
; Purpose     :	Write SWEA data to ASCII file
;
; Category    :	STEREO, IMPACT, SWEA
;
; Explanation :	
;
; Syntax      :	SWEA_TO_ASCII , SCIDATA, SCID
;
; Examples    :	
;
; Inputs      :	SCIDATA - a structure including SWEA 210 science data
;               DATESTRING - the date string for the filename
;		SCID - the spacecraft ID
;
; Opt. Inputs :	None.
;
; Outputs     :	None.
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       :	None
;
; Common      : None
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 08-11-2006, Nicolas Pene,
;                  CESR.
;
; Contact     :	nicolas.pene@cesr.fr
;-
;

common swea_l1_common ;use common block


if (SCID eq 'EA'XU) then SCSTRING = 'sta' $
else SCSTRING = 'stb'

;if (SCID eq 'EA'XU) then begin 
;    thetamin = [  0.00, 22.50, 45.00, 67.50,  90.00, 112.50, 135.00, 157.50, 180.00, 202.50, 225.00, 247.50, 270.00, 292.50, 315.00, 337.50 ]
;    thetamoy = [ 11.25, 33.75, 56.25, 78.75, 101.25, 123.75, 146.25, 168.75, 191.25, 213.75, 236.25, 258.75, 281.25, 303.75, 326.25, 348.75 ]
;    thetamax = [ 22.50, 45.00, 67.50, 90.00, 112.50, 135.00, 157.50, 180.00, 202.50, 225.00, 247.50, 270.00, 292.50, 315.00, 337.50, 360.00 ]
;endif else begin
;    thetamin = [ 180.00, 202.50, 225.00, 247.50, 270.00, 292.50, 315.00, 337.50,  0.00, 22.50, 45.00, 67.50,  90.00, 112.50, 135.00, 157.50 ]
;    thetamoy = [ 191.25, 213.75, 236.25, 258.75, 281.25, 303.75, 326.25, 348.75, 11.25, 33.75, 56.25, 78.75, 101.25, 123.75, 146.25, 168.75 ]
;    thetamax = [ 202.50, 225.00, 247.50, 270.00, 292.50, 315.00, 337.50, 360.00, 22.50, 45.00, 67.50, 90.00, 112.50, 135.00, 157.50, 180.00 ]
;endelse

    thetamin = [  0.00, 22.50, 45.00, 67.50,  90.00, 112.50, 135.00, 157.50, 180.00, 202.50, 225.00, 247.50, 270.00, 292.50, 315.00, 337.50 ]
    thetamoy = [ 11.25, 33.75, 56.25, 78.75, 101.25, 123.75, 146.25, 168.75, 191.25, 213.75, 236.25, 258.75, 281.25, 303.75, 326.25, 348.75 ]
    thetamax = [ 22.50, 45.00, 67.50, 90.00, 112.50, 135.00, 157.50, 180.00, 202.50, 225.00, 247.50, 270.00, 292.50, 315.00, 337.50, 360.00 ]

phimin = [ 133.33, 111.67,  90.00, 68.33, 46.67, 25.00 ]
phimoy = [ 144.17, 122.50, 100.83, 79.17, 57.50, 35.83 ]
phimax = [ 155.00, 133.33, 111.67, 90.00, 68.33, 46.67 ]

energmin = [ 323.60932, 122.75   , 46.486225, 17.61878,  6.6777102, 2.5309245, 1.1874535]
energmoy = [ 525.64824, 199.22638, 75.508959, 28.618714, 10.846803, 4.1110559, 1.5581348]
energmax = [ 1056.9518, 323.60932, 122.75   , 46.486225, 17.61878,  6.6777102, 2.5309245]


phi = fltarr(6,3)
for d=0,5 do begin
	phi[d,0] = phimin[d]
	phi[d,1] = phimoy[d]
	phi[d,2] = phimax[d]
endfor

pitch = fltarr(2,6,3)
dalpha = fltarr(6)
magaz = fltarr(3)
magel = fltarr(3)

; get the packet date :
utc = anytim2utc(SCIDATA.TIME,/external)
if ((utc.day lt 10) and (utc.month lt 10)) then datestr = string(utc.year,utc.month,utc.day,'(I4,"0",I1,"0",I1)') $
else if ((utc.day lt 10) and (utc.month ge 10)) then datestr=string(utc.year,utc.month,utc.day,'(I4,I2,"0",I1)') $
else if ((utc.day ge 10) and (utc.month lt 10)) then datestr=string(utc.year,utc.month,utc.day,'(I4,"0",I1,I2)') $
else datestr=string(utc.year,utc.month,utc.day,'(I4,I2,I2)')



if keyword_set(pitchtime) then begin
	pitchfile = out_path+'/'+SCSTRING+'_l1_swea_pit2_'+datestr+'_v'+version+'.bin'
	unit0=21
        openu,unit0,pitchfile,/append,/GET_LUN,/SWAP_IF_LITTLE_ENDIAN
endif

if keyword_set(cl_pitch) then begin
	pitchfile = out_path+'/'+SCSTRING+'_l1_swea_pitc_'+datestr+'_v'+version+'.bin'
        filematch = file_search(pitchfile, count = filecount)
	openu,unit,pitchfile,/append,/GET_LUN,/SWAP_IF_LITTLE_ENDIAN
endif


if keyword_set(cl_pad) then begin
	pitchfile = out_path+'/'+SCSTRING+'_l1_swea_2ddi_'+datestr+'_v'+version+'.bin'
        filematch = file_search(pitchfile, count = filecount)
	openu,unit,pitchfile,/append,/GET_LUN,/SWAP_IF_LITTLE_ENDIAN

    magfile = out_path+'/'+SCSTRING+'_l1_swea_2dma_'+datestr+'_v'+version+'.bin'
        filematch = file_search(pitchfile, count = filecount)
    openu,unit2,magfile,/append,/GET_LUN,/SWAP_IF_LITTLE_ENDIAN
endif


; Pitch Angle packet :

	utcsec = utc2sec(SCIDATA.TIME)

	for i=0,2 do begin

		utcpkttim = sec2utc(utcsec + double(SCIDATA.SWEAPADINT)*(double(i)+0.5d))
		; get the packet date :
		utc = anytim2utc(utcpkttim,/external)



		magaz[i] = SCIDATA.SWEAPAD[i].MagAz
		magel[i] = SCIDATA.SWEAPAD[i].MagEl

        ; ................................
        ; Offset for the ahead satellite
        if (SCID eq 'EA'XU) then begin
            ;magel[i] = magel[i]-73
            bx = cos(magel[i]*!pi/180.)
            ;bx = (cos(magel[i]*!pi/180.)+0.925)*15.5
            ;magel[i]=acos(bx)*180./!pi
        endif else begin
            bx = cos(magel[i]*!pi/180.)
        endelse


		;bx = cos(magel[i]*!pi/180.)
		by = cos(magaz[i]*!pi/180.)*sin(magel[i]*!pi/180.)
		bz = sin(magaz[i]*!pi/180.)*sin(magel[i]*!pi/180.)
		bb=sqrt(bx*bx+by*by+bz*bz)


		for d=0,5 do begin
		;thetamax = []

			;for the=0,2 do begin
            the=1

                ; --- calculus for in the (Y,Z) SWEA Frame
				for anod=0,15 do begin
					if ((magaz[i] lt thetamax[anod]) and $
					    (magaz[i] ge thetamin[anod])) then begin
						sy=cos(thetamoy[anod]*!pi/180.)*sin(phi[d,the]*!pi/180.)
						sz=sin(thetamoy[anod]*!pi/180.)*sin(phi[d,the]*!pi/180.)
						py=cos((180+thetamoy[anod])*!pi/180.)*sin(phi[5-d,the]*!pi/180.)
						pz=sin((180+thetamoy[anod])*!pi/180.)*sin(phi[5-d,the]*!pi/180.)
						break
					endif
				endfor
                
                ; NB : les thetas donnent la vecteur vitesse corespondant a l'anode opposee :
                if ( anod lt 8 ) then anod = anod+8 $
                else anod = anod-8

				sx=cos(phi[d,the]*!pi/180.)
				px=cos(phi[5-d,the]*!pi/180.)

				;Anode 0 & 8 :
				pitcha0 = acos((sx*bx+sy*by+sz*bz))*180./!pi
				pitcha8 = acos((px*bx+py*by+pz*bz))*180./!pi

				pitchu0 = acos( cos(phi[d,the]*!pi/180.)*cos(magel[i]*!pi/180.) + $
						sin(phi[d,the]*!pi/180.)*sin(magel[i]*!pi/180.) )*180./!pi

				pitchu8 = acos( cos((180+phi[d,the])*!pi/180.)*cos(magel[i]*!pi/180.) + $
						sin((180+phi[d,the])*!pi/180.)*sin(magel[i]*!pi/180.) )*180./!pi


				pitchc=magel[i]-phi[d,the]

				pitch[0,d,the]=pitcha0
				pitch[1,d,the]=pitcha8
			;endfor
            
            ; anode following B
            dT = 11.25; delta theta
            cosT = cos(thetamoy[anod]*!pi/180.)
            sinT = sin(thetamoy[anod]*!pi/180.)

            dP = 60./6.; Delta Phi
            cosP = cos(phi[d,the]*!PI/180.)
            sinP = sin(phi[d,the]*!PI/180.)

            sinA = sin(pitch[0,d,the]*!PI/180.)
            dalpha[d] =  abs(dT*abs(-By*cosP*sinT + Bz*cosP*cosT) +dP*abs(Bx*cosP -By*sinP*cosT -Bz*sinP*sinT))/abs(sinA)


		endfor



		;----------------------------------------------------------------------
		;        Print file for my gnuplot code
		;
		if keyword_set(pitch1) then begin
			for d=0,5 do begin
				for e=0,6 do begin

					if ( utc.minute eq 0 ) then begin
					print, "-----------------------------------------------------"
						nrj = string(e,'(I1)')
						filename = SCSTRING+'_pitch_'+datestr+'-'+hourstr+':'+minstr+'-'+secstr+'_e'+nrj+'.txt'
						filematch = file_search(filename, count = filecount)
						unit10=30+e
						OPENU,unit10,filename,/append

						printf, unit10, "# ", anod,magaz[i],magel[i],e
						printf, unit10, pitch[0,d,1],pitch[1,d,1],SCIDATA.SWEAPAD[i].PAD[e,d,0],SCIDATA.SWEAPAD[i].PAD[e,d,1]
						close, unit10
					endif
				endfor
			endfor
		endif
		;
		;----------------------------------------------------------------------


		;----------------------------------------------------------------------
		;        Print file for cl
		;
		; The file name
		if keyword_set(cl_pitch) then begin

			julian= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond

			anod1 = byte(anod+1)
            if ( anod le 8 ) then anod2 = byte(anod+9) $
            else anod2 = byte(anod-7)

			writeu, unit, julian,anod1,anod2


            ;-----------------------
			; moy
			   for d = 0,5 do $
			      for a = 0,1 do $
					writeu, unit, pitch[a,d,1]

            ;-----------------------
			; delta min
            ;d=0 :
			for d = 0,5 do begin
			    for a = 0,1 do begin
					writeu, unit, dalpha[d]
				endfor
			endfor

            ;-----------------------
			; delta max

			for d = 0,5 do begin
			    for a = 0,1 do begin
					writeu, unit, dalpha[d]
				endfor
			endfor


			writeu, unit, energmoy

			; delta min (energy)
			for e = 0,6 do begin
				emin=energmoy[e]-energmin[e]
				writeu, unit, emin
			endfor

			; delta max (energy)
			for e = 0,6 do begin
				emax=energmax[e]-energmoy[e]
				writeu, unit, emax
			endfor

			   for d = 0,5 do $
			      for a = 0,1 do $
                    for e = 0,6 do $
                        writeu, unit, SCIDATA.SWEAPAD[i].PAD[e,d,a]
					

		endif
		;
		;----------------------------------------------------------------------


		;----------------------------------------------------------------------
		;        Print 2ddi (2d dist) & 2dma (2d mag) for CL
		;
		; The file name
		if keyword_set(cl_pad) then begin

			julian= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond

			anod1 = anod
            if ( anod lt 8 ) then anod2 = anod+8 $
            else anod2 = anod-8

            zeros = bytarr(7)
            zeros[*] = 0
			writeu, unit, julian
        
            ;print,anod1,utc.hour,utc.minute,utc.second

           for d = 0,5 do begin
              for a = 0,15 do begin
                if ( a eq anod1 ) then $
                    for e = 0,6 do writeu, unit, SCIDATA.SWEAPAD[i].PAD[e,d,0] $
                else if ( a eq anod2 ) then $
                    for e = 0,6 do writeu, unit, SCIDATA.SWEAPAD[i].PAD[e,d,1] $
                else writeu, unit, zeros
              endfor
           endfor


        ; MAG in the spacecraft frame :
        if (SCID eq 'EA'XU) then angle=50.625 $
        else angle=230.625
        ;angle=50.625


        magaz_sat = magaz[i]+angle

		by_sat = cos(magaz_sat*!pi/180.)*sin(magel[i]*!pi/180.)
		bz_sat = sin(magaz_sat*!pi/180.)*sin(magel[i]*!pi/180.)


        ;----------------------------------------------------------
        ; B in SC frame test :

        ;magaz2 = atan(bz_sat/by_sat)*180./!pi
        ;print," mag SWEA : ",magaz[i],angle,magaz[i]-angle
        ;print," mag SC   : ",magaz_sat
        ;stop
        ; --- calculus for in the (Y,Z) SWEA Frame
        ;for anod=0,15 do begin
        ;    if ((magaz2 lt thetamax[anod]) and $
        ;        (magaz2 ge thetamin[anod])) then begin
        ;        break
        ;    endif
        ;endfor
        ;----------------------------------------------------------


		writeu, unit2, julian, bx, by_sat, bz_sat

		endif
		;
		;----------------------------------------------------------------------


		;----------------------------------------------------------------------
		;        Pitch per time
		;
		;if ( utc.minute eq 0 ) then print,utc.hour
		;---------------------------------------
		; pitchangles per time
		if keyword_set(pitchtime) then begin
			julian= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond

			writeu, unit0, julian
			   for d = 0,5 do $
			      for a = 0,1 do $
				writeu, unit0, pitch[a,d,1]
		endif 
		;
		;----------------------------------------------------------------------
	endfor


	if keyword_set(pitchtime) then close, unit0
	if keyword_set(cl_pitch) then begin
		close, unit
		free_lun, unit
	endif else if keyword_set(cl_pad) then begin
		close, unit2
		free_lun, unit2
		close, unit
		free_lun, unit
	endif


	if keyword_set(mag) then begin
		julian= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond
		unit4 = 40
		file2 = SCSTRING+'_mag_'+datestr+'-'+hourstr+'_v'+version+'.txt'
		OPENU,unit4,file2,/append
		printf, unit4, FORMAT = '(F24.4, 3(" ",F))', julian, bx, by, bz
		close, unit4
	endif


return
end
