function PITCHANGLE, b, sat
;+
; Project     :	STEREO - IMPACT/SWEA
;
; Name        : PITCHANGLE
;
; Purpose     :	return the pitch-angle
;
; Category    :	STEREO, IMPACT, SWEA
;
; Explanation :	
;
; Syntax      :	SWEA_TO_ASCII , SCIDATA, SCID
;
; Examples    :	
;
; Inputs      :	SCIDATA - a structure including SWEA 210 science data
;               DATESTRING - the date string for the filename
;		SCID - the spacecraft ID
;
; Opt. Inputs :	None.
;
; Outputs     :	None.
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       :	None
;
; Common      : None
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 08-11-2006, Nicolas Pene,
;                  CESR.
;
; Contact     :	nicolas.pene@cesr.fr
;-
;

; Phi for the vector direction (not the cell)
;phimin = [ 133.33, 111.67,  90.00, 68.33, 46.67, 25.00 ]
;phi = [ 144.17, 122.50, 100.83, 79.17, 57.50, 35.83 ]
phi = [ 35.83, 57.50, 79.17, 100.83, 122.50, 144.17 ]
;phimax = [ 155.00, 133.33, 111.67, 90.00, 68.33, 46.67 ]


; Theta for the vector direction (not the cell)
if (sat eq 'behind') then begin
    thetamin = [  50.625, 73.125, 95.625, 118.125, 140.625, 163.125, 185.625, 208.125, 230.625, 253.125, 275.625, 298.125, 320.625, 343.125, 5.625, 28.125 ]
    thetamoy = [  61.875, 84.375, 106.875, 129.375, 151.875, 174.375, 196.875, 219.375, 241.875, 264.375, 286.875, 309.375, 331.875, 354.375, 16.875, 39.375 ]
    thetamax = [  73.125, 95.625, 118.125, 140.625, 163.125, 185.625, 208.125, 230.625, 253.125, 275.625, 298.125, 320.625, 343.125, 5.625, 28.125, 50.625 ]
endif else begin
    thetamin = [  230.625, 253.125, 275.625, 298.125, 320.625, 343.125, 5.625, 28.125, 50.625, 73.125, 95.625, 118.125, 140.625, 163.125, 185.625, 208.125 ]
    thetamoy = [  241.875, 264.375, 286.875, 309.375, 331.875, 354.375, 16.875, 39.375, 61.875, 84.375, 106.875, 129.375, 151.875, 174.375, 196.875, 219.375 ]
    thetamax = [  253.125, 275.625, 298.125, 320.625, 343.125, 5.625, 28.125, 50.625, 73.125, 95.625, 118.125, 140.625, 163.125, 185.625, 208.125, 230.625 ]
endelse


pitch = fltarr(16,6)
dalpha = fltarr(16,6)

bb=sqrt(b[0]*b[0]+b[1]*b[1]+b[2]*b[2])
bx=b[0]/bb
by=b[1]/bb
bz=b[2]/bb

for anod=0,15 do begin
    for the=0,5 do begin
                sx=-cos(phi[the]*!pi/180.)
                sy=-cos(thetamoy[anod]*!pi/180.)*sin(phi[the]*!pi/180.)
                sz=-sin(thetamoy[anod]*!pi/180.)*sin(phi[the]*!pi/180.)
                
				;Anode 0 & 8 :
                scal=sx*bx+sy*by+sz*bz
                if ( scal gt 1.00001 ) then begin
                    print,"Error : pitch angle...         scal =",scal
                    exit
                endif
                if ( (scal gt 1.) && (scal le 1.00001) ) then pitch[anod,the]=acos(0.9999999999999) $
				else pitch[anod,the] = acos(scal)*180./!pi

            ; anode following B
            dT = 11.25; delta theta
            cosT = cos(thetamoy[anod]*!pi/180.)
            sinT = sin(thetamoy[anod]*!pi/180.)

            dP = 60./6.; Delta Phi
            cosP = cos(phi[the]*!PI/180.)
            sinP = sin(phi[the]*!PI/180.)

            sinA = sin(pitch[anod,the]*!PI/180.)
            dalpha[anod,the] =  abs(dT*abs(-b[1]*cosP*sinT + b[2]*cosP*cosT) +dP*abs(b[0]*cosP -b[1]*sinP*cosT -b[2]*sinP*sinT))/abs(sinA)


    endfor
endfor

pitch_str = { $
    pitch: pitch, $
    dalpha : dalpha $
}


return, pitch_str
end
