;***************************************************************
; Scale factor, Ki, is used to translate the Magnetometer's raw count Ci (ADC) into Bi (Magnitudes)
; Bi = Ki * Cfr
; Cifr is the modified count readings after Frequency Response and Transfer function had applied, in the form of CXfr, CYfr and CZfr
; Ki is the convert matrix (3x1) for the Scale factor
;***************************************************************

function mag_scale_factor, Cfr, K
; This calibration function is used to convert the ADC readings to the Magnetic field's magnitude in the unit of nT (nano Telas)
;
; Return values initialization
BX = 0
BY = 0
BZ = 0

; Verify
    BX = K(0)*Cfr(0)
    BY = K(1)*Cfr(1)
    BZ = K(2)*Cfr(2)
B = [BX, BY, BZ]
return, B

end; end of function

