;APID 270h (624d)
function mag_load_struct2_270, packet
apid = parse_stereo_pkt(packet, /APID )
; MAG structure for APID 270h (Beacon Telemetry Packet)
MAG_DATA = {MAG_STRUCT_270, $
;;;          XX:       BYTARR(18), $
          XX:       BYTARR(7), $
          IMAGHKP:  0U, $
;          MAG_XYZ_COUNT: uintarr (6*3)}
          MAGX_01:  0, $
          MAGY_01:  0, $
          MAGZ_01:  0, $
          MAGX_02:  0, $
          MAGY_02:  0, $
          MAGZ_02:  0, $
          MAGX_03:  0, $
          MAGY_03:  0, $
          MAGZ_03:  0, $
          MAGX_04:  0, $
          MAGY_04:  0, $
          MAGZ_04:  0, $
          MAGX_05:  0, $
          MAGY_05:  0, $
          MAGZ_05:  0, $
          MAGX_06:  0, $
          MAGY_06:  0, $
          MAGZ_06:  0}
 
;; read packet (MAG PTP) from 0th bytes to (7+2+36-1)=44th bytes
;rawimpactb = packet.dat[0:7+38-1]
rawimpactb = packet.dat[0:44]
;********************************************************************
;*  William Thompson, use LOAD_STRUCT instead of temporary file.
;*
;*openw, tmpu, '/tmp/rawimpact.dat', /get_lun, error = error_flag
;*writeu, tmpu, rawimpactb
;*free_lun, tmpu
;*
;*;read back into structure
;*openr, tmpu, '/tmp/rawimpact.dat', /get_lun, error = error_flag
;*   IF (error_flag ne 0) then BEGIN
;*   printf, -2, !err_string
;*exit, /NO_CONFIRM, STATUS=-1
;*ENDIF
;*; read packet into MAG_DATA
;*readu, tmpu, MAG_DATA
;*free_lun, tmpu
;********************************************************************

;Use the /LITTLE keyword if MAG_DATA is little-endian.
load_struct, rawimpactb, MAG_DATA[0], MAG_DATA, /LITTLE

; Swap bype correction
MAG_DATA = swap_endian (MAG_DATA)
; Offset 8000h correction
;mag_sets = 6
;SETS = 0
;repeat begin
;MAG_DATA.MAG_XYZ_COUNT (SETS * 3) = MAG_DATA.MAG_XYZ_COUNT (SETS * 3) - '8000'X
;MAG_DATA.MAG_XYZ_COUNT (SETS * 3 + 1) = MAG_DATA.MAG_XYZ_COUNT (SETS * 3 + 1) - '8000'X
;MAG_DATA.MAG_XYZ_COUNT (SETS * 3 + 2) = MAG_DATA.MAG_XYZ_COUNT (SETS * 3 + 2) - '8000'X
;SETS = SETS + 1
;endrep until SETS gt (mag_sets - 1)
MAG_DATA.MAGX_01 = MAG_DATA.MAGX_01 - '8000'X
MAG_DATA.MAGY_01 = MAG_DATA.MAGY_01 - '8000'X
MAG_DATA.MAGZ_01 = MAG_DATA.MAGZ_01 - '8000'X
MAG_DATA.MAGX_02 = MAG_DATA.MAGX_02 - '8000'X
MAG_DATA.MAGY_02 = MAG_DATA.MAGY_02 - '8000'X
MAG_DATA.MAGZ_02 = MAG_DATA.MAGZ_02 - '8000'X
MAG_DATA.MAGX_03 = MAG_DATA.MAGX_03 - '8000'X
MAG_DATA.MAGY_03 = MAG_DATA.MAGY_03 - '8000'X
MAG_DATA.MAGZ_03 = MAG_DATA.MAGZ_03 - '8000'X
MAG_DATA.MAGX_04 = MAG_DATA.MAGX_04 - '8000'X
MAG_DATA.MAGY_04 = MAG_DATA.MAGY_04 - '8000'X
MAG_DATA.MAGZ_04 = MAG_DATA.MAGZ_04 - '8000'X
MAG_DATA.MAGX_05 = MAG_DATA.MAGX_05 - '8000'X
MAG_DATA.MAGY_05 = MAG_DATA.MAGY_05 - '8000'X
MAG_DATA.MAGZ_05 = MAG_DATA.MAGZ_05 - '8000'X
MAG_DATA.MAGX_06 = MAG_DATA.MAGX_06 - '8000'X
MAG_DATA.MAGY_06 = MAG_DATA.MAGY_06 - '8000'X
MAG_DATA.MAGZ_06 = MAG_DATA.MAGZ_06 - '8000'X


; Test - Set bit 11, 12, 15 to 1
; Example for setting status bits
;MAG_DATA.IMAGHKP='9800'X
SPARE_TIEDHIGH = 0
INTERFACE_PARITY = 0
INTERFACE_TIMEOUT = 0
ADC_CAL = 0
IN_FLIGHT_CAL = 0
RANGE_SENSITIVITY = 0
;MAG_DATA.range_sen = 0
IF MAG_DATA.IMAGHKP eq 0 then begin
; 1 = command parity error
;   INTERFACE_PARITY_OK = 1                      ;bit 11
; 1 = interface timout
;   INTERFACE_TIMEOUT_OK = 1                     ;bit 12
; 0 = off, 1 = on
;   ADC_CAL_OFF = 1                              ;bit 13

; 0 = off, 1 = on
;   IN_FLIGHT_CAL_OFF = 1                        ;bit 14
; 0 = low, 1 = high
;   RANGE_LOW_FIELDS_HIGH_SENSITIVITY = 1        ;bit 15
; Verify
END ELSE BEGIN IF ISHFT(MAG_DATA.IMAGHKP AND '0100'X, -8) then begin
   SPARE_TIEDHIGH = 1
END
IF ISHFT(MAG_DATA.IMAGHKP AND '0800'X, -11) then begin
   INTERFACE_PARITY = 1
END
IF ISHFT(MAG_DATA.IMAGHKP AND '1000'X, -12) then begin
   INTERFACE_TIMEOUT = 1
END
IF ISHFT(MAG_DATA.IMAGHKP AND '2000'X, -13) then begin
   ADC_CAL = 1
END
IF ISHFT(MAG_DATA.IMAGHKP AND '4000'X, -14) then begin
   IN_FLIGHT_CAL = 1
END
IF ISHFT(MAG_DATA.IMAGHKP AND '8000'X, -15) then begin
   RANGE_SENSITIVITY = 1
;   MAG_DATA.range_sen = 1
END
ENDELSE

;IF RANGE_SENSITIVITY eq 0 then print, "Range is low",RANGE_SENSITIVITY ELSE print, "Range is high", RANGE_SENSITIVITY

return, MAG_DATA
end;
