FUNCTION IMPACT_MOMENT_UNCOMP, COMP_MOMENT
;+
; Project     :	STEREO - IMPACT
;
; Name        : IMPACT_MOMENT_UNCOMP
;
; Purpose     :	Uncompress IMPACT data using moment compression scheme
;
; Category    :	STEREO, IMPACT
;
; Explanation :	
;
; Syntax      :	uncompressed = IMPACT_MOMENT_UNCOMP(COMP_MOMENT)
;
; Examples    :	
;
; Inputs      :	COMP_MOMENT - a 2 byte moment-compressed value
;
; Opt. Inputs :	None.
;
; Outputs     :	The uncompressed value
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       :	None
;
; Common      : None
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 10-Nov-2005, Peter Schroeder,
;                  UC-Berkeley.
;
; Contact     :	peters@ssl.berkeley.edu
;-
;
if comp_moment eq 0 then return,0d

bits, comp_moment, moment_bits
moment_bits = long(moment_bits)
s = moment_bits[0]
e = moment_bits[6] + ishft(moment_bits[5],1) + ishft(moment_bits[4],2) + $
   ishft(moment_bits[3],3) + ishft(moment_bits[2],4) + $
   ishft(moment_bits[1],5)
m = moment_bits[15] + ishft(moment_bits[14],1) + ishft(moment_bits[13],2) + $
   ishft(moment_bits[12],3) + ishft(moment_bits[11],4) + $
   ishft(moment_bits[10],5) + ishft(moment_bits[9],6) + $
   ishft(moment_bits[8],7) + ishft(moment_bits[7],8)

s = double(s)
e = double(e)
m = double(m)

return,((-1d)^(s)) * (512d + m) * ((2d)^(e-10d))
end

