FUNCTION IMPACT_LOG_UNCOMP, N_IN
;+
; Project     :	STEREO - IMPACT
;
; Name        : IMPACT_LOG_UNCOMP
;
; Purpose     :	Uncompress IMPACT data using log scheme
;
; Category    :	STEREO, IMPACT
;
; Explanation :	
;
; Syntax      :	uncompressed = IMPACT_LOG_UNCOMP(N_IN)
;
; Examples    :	
;
; Inputs      :	N_IN - an 8 bit number to be uncompressed
;
; Opt. Inputs :	None.
;
; Outputs     :	The uncompressed value
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       :	None
;
; Common      : None
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 10-Nov-2005, Peter Schroeder,
;                  UC-Berkeley.
;
; Contact     :	peters@ssl.berkeley.edu
;-
;

n = ulong(n_in)

if n lt '20'XUL then return, n

if n ge 'FF'XUL then return, '80000'XUL

range = ['30'XUL,'40'XUL,'50'XUL,'60'XUL,'70'XUL,'80'XUL,'90'XUL,$
   'A0'XUL,'B0'XUL,'C0'XUL,'D0'XUL,'E0'XUL,'F0'XUL,'100'XUL]

a = range - '10'XUL

b = ['20'XUL,'40'XUL,'80'XUL,'100'XUL,'200'XUL,'400'XUL,'800'XUL,'1000'XUL,$
   '2000'XUL,'4000'XUL,'8000'XUL,'10000'XUL,'20000'XUL,'40000'XUL]

c = [2UL, 4UL, 8UL, '10'XUL, '20'XUL, '40'XUL, '80'XUL, '100'XUL, $
   '200'XUL, '400'XUL, '800'XUL, '1000'XUL, '2000'XUL, '4000'XUL]
   
for i = 0, n_elements(range)-1 do $
  if n lt range[i] then return, b[i] + c[i] * (n - a[i])

end
