PRO IMPACT_BEACON, PACKET, FILENAME
;+
; Project     :	STEREO - IMPACT
;
; Name        : IMPACT_BEACON
;
; Purpose     :	Convert raw IMPACT Beacon data into physical units
;
; Category    :	STEREO, IMPACT
;
; Explanation :	
;
; Syntax      :	IMPACT_BEACON, PACKET, FILENAME
;
; Examples    :	
;
; Inputs      :	PACKET - an IMPACT Beacon packet to be processed
;               FILENAME - the name of a CDF file for output
;
; Opt. Inputs :	None.
;
; Outputs     :	None.
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       :	None
;
; Common      : None
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 10-Nov-2005, Peter Schroeder,
;                  UC-Berkeley.
;
; Contact     :	peters@ssl.berkeley.edu
;-
;

if (packet.grh.spacecraft_id eq 'EA'XU) then $
   SOURCE_FILE = 'impacta_beacon_skt.cdf' else $
   SOURCE_FILE = 'impactb_beacon_skt.cdf'
SOURCE_FILE = concat_dir('$IMPACT_CALIB_DATA', SOURCE_FILE)

filematch = file_search(filename, count = filecount)
if filecount eq 0 then file_copy, SOURCE_FILE, filename

mag_data = stereo_mag_xform_packet(packet)
sweaste_data = sweaste_beacon(packet)
sep_beacon, packet, sep_data

ISCStatus = packet.dat[2]
InterfaceActive = packet.dat[1]
SWEAModeID = packet.dat[4]
STEModeID = packet.dat[3]

utcpkttim = parse_stereo_pkt(packet,/pkt_date)
utcsec = utc2sec(utcpkttim)
utcpkktim = sec2utc(utcsec + double(packet.dat[0])/65536d)
utc = anytim2utc(utcpkttim,/external)

cdf_epoch, pktepoch, utc.year, utc.month, utc.day, utc.hour, utc.minute, $
   utc.second, utc.millisecond,/compute_epoch

utcsec = utc2sec(utcpkttim)
utcsec = utcsec + 5d
utc = sec2utc(utcsec)
utc = anytim2utc(utc,/external)

cdf_epoch, mag0epoch, utc.year, utc.month, utc.day, utc.hour, utc.minute, $
   utc.second, utc.millisecond,/compute_epoch

utcsec = utc2sec(utcpkttim)
utcsec = utcsec + 15d
utc = sec2utc(utcsec)
utc = anytim2utc(utc,/external)

cdf_epoch, mag1epoch, utc.year, utc.month, utc.day, utc.hour, utc.minute, $
   utc.second, utc.millisecond,/compute_epoch

utcsec = utc2sec(utcpkttim)
utcsec = utcsec + 25d
utc = sec2utc(utcsec)
utc = anytim2utc(utc,/external)

cdf_epoch, mag2epoch, utc.year, utc.month, utc.day, utc.hour, utc.minute, $
   utc.second, utc.millisecond,/compute_epoch

utcsec = utc2sec(utcpkttim)
utcsec = utcsec + 35d
utc = sec2utc(utcsec)
utc = anytim2utc(utc,/external)

cdf_epoch, mag3epoch, utc.year, utc.month, utc.day, utc.hour, utc.minute, $
   utc.second, utc.millisecond,/compute_epoch

utcsec = utc2sec(utcpkttim)
utcsec = utcsec + 45d
utc = sec2utc(utcsec)
utc = anytim2utc(utc,/external)

cdf_epoch, mag4epoch, utc.year, utc.month, utc.day, utc.hour, utc.minute, $
   utc.second, utc.millisecond,/compute_epoch

utcsec = utc2sec(utcpkttim)
utcsec = utcsec + 55d
utc = sec2utc(utcsec)
utc = anytim2utc(utc,/external)

cdf_epoch, mag5epoch, utc.year, utc.month, utc.day, utc.hour, utc.minute, $
   utc.second, utc.millisecond,/compute_epoch

utcsec = utc2sec(utcpkttim)
utcsec = utcsec + 61d
utc = sec2utc(utcsec)
utc = anytim2utc(utc,/external)

cdf_epoch, sweaepoch, utc.year, utc.month, utc.day, utc.hour, utc.minute, $
   utc.second, utc.millisecond,/compute_epoch

utc = anytim2utc(sep_data.header.timeCDS,/external)

cdf_epoch, sepepoch, utc.year, utc.month, utc.day, utc.hour, utc.minute, $
   utc.second, utc.millisecond,/compute_epoch

cdfid = cdf_open(filename)
if filecount eq 0 then recstart = 0 else begin
   quiet=!quiet  &  !quiet=1 
   cdf_control, cdfid, get_var_info=info, variable='Epoch'
   !quiet=quiet
   recstart = info.maxrec+1
endelse

cdf_varput, cdfid, 'Epoch', pktepoch, rec_start = recstart
cdf_varput, cdfid, 'ISCStatus', ISCStatus, rec_start = recstart
cdf_varput, cdfid, 'InterfaceActive', InterfaceActive, rec_start = recstart
cdf_varput, cdfid, 'SWEAModeID', SWEAModeID, rec_start = recstart
cdf_varput, cdfid, 'STEModeID', STEModeID, rec_start = recstart

cdf_varput, cdfid, 'Epoch_SWEA', sweaepoch, rec_start = recstart
cdf_varput, cdfid, 'Ne', sweaste_data.SWEA_N, rec_start = recstart
cdf_varput, cdfid, 'Ve', sweaste_data.SWEA_V, rec_start = recstart
cdf_varput, cdfid, 'Pe', sweaste_data.SWEA_P, rec_start = recstart
cdf_varput, cdfid, 'He', sweaste_data.SWEA_NH, rec_start = recstart
cdf_varput, cdfid, 'V0', sweaste_data.SWEA_V0, rec_start = recstart
cdf_varput, cdfid, 'MagAz', sweaste_data.SWEA_MagAz, rec_start = recstart
cdf_varput, cdfid, 'MagEl', sweaste_data.SWEA_MagEl, rec_start = recstart
cdf_varput, cdfid, 'SWEAPAD', reform(double(sweaste_data.SWEA_PAD),2,6,2), $
   rec_start = recstart
cdf_varput, cdfid, 'SWEAPAD_Energy', [sweaste_data.SWEA_PAD_E0, $
   sweaste_data.SWEA_PAD_E1], rec_start = recstart
cdf_varput, cdfid, 'STEUns', double(sweaste_data.STE_Uns), rec_start = recstart
cdf_varput, cdfid, 'STEUs', double(sweaste_data.STE_Us), rec_start = recstart
cdf_varput, cdfid, 'STED', double(sweaste_data.STE_D), rec_start = recstart

cdf_varput, cdfid, 'Epoch_SEP', sepepoch, rec_start = recstart
cdf_varput, cdfid, 'SEP_SW_Version', sep_data.header.SWversion, rec_start = recstart
cdf_varput, cdfid, 'HETLiveTime', sep_data.status.HETLiveTime, rec_start = recstart
cdf_varput, cdfid, 'HETStopEffic', sep_data.status.HETStopEffic, rec_start = recstart
cdf_varput, cdfid, 'HETPenEffic', sep_data.status.HETPenEffic, rec_start = recstart
cdf_varput, cdfid, 'HETStatus', sep_data.status.HETStatus, rec_start = recstart
cdf_varput, cdfid, 'LETLiveTime', sep_data.status.LETLiveTime, rec_start = recstart
cdf_varput, cdfid, 'LETTrigRate', sep_data.status.LETTrigCnts, rec_start = recstart
cdf_varput, cdfid, 'LETHazRate', sep_data.status.LETHazCnts, rec_start = recstart
cdf_varput, cdfid, 'LETAcceptRate', sep_data.status.LETAcceptCnts, rec_start = recstart
cdf_varput, cdfid, 'LETCodeOK', sep_data.status.LETCodeOK, rec_start = recstart
cdf_varput, cdfid, 'LETHeaterDutyCycle', sep_data.status.LETHeaterDutyCycle, rec_start = recstart
cdf_varput, cdfid, 'LETLeakConv', sep_data.status.LETLeakConv, rec_start = recstart
cdf_varput, cdfid, 'LETDyThState', sep_data.status.LETDyThState, rec_start = recstart
cdf_varput, cdfid, 'LETMinute', sep_data.status.LETMinute, rec_start = recstart
cdf_varput, cdfid, 'SEPTStatus', sep_data.status.SEPTStatus, rec_start = recstart

cdf_varput, cdfid, 'HETElectronFlux', sep_data.flux.HETElectrons, rec_start = recstart
cdf_varput, cdfid, 'HETProtonFlux', [sep_data.flux.HETProtons1, $
   sep_data.flux.HETProtons2, sep_data.flux.HETProtons3], rec_start = recstart
cdf_varput, cdfid, 'HETHeFlux', [sep_data.flux.HETHe1, $
   sep_data.flux.HETHe2, sep_data.flux.HETHe3], rec_start = recstart
cdf_varput, cdfid, 'HETCNOFlux', [sep_data.flux.HETCNO1, $
   sep_data.flux.HETCNO2], rec_start = recstart
cdf_varput, cdfid, 'HETFeFlux', sep_data.flux.HETFe, rec_start = recstart

cdf_varput, cdfid, 'SITHeFlux', [sep_data.flux.SITHe1, sep_data.flux.SITHe2, $
   sep_data.flux.SITHe3, sep_data.flux.SITHe4], rec_start = recstart
cdf_varput, cdfid, 'SITCNOFlux', [sep_data.flux.SITCNO1, $
   sep_data.flux.SITCNO2, sep_data.flux.SITCNO3, sep_data.flux.SITCNO4], rec_start = recstart
cdf_varput, cdfid, 'SITFeFlux', [sep_data.flux.SITFe1, sep_data.flux.SITFe2, $
   sep_data.flux.SITFe3, sep_data.flux.SITFe4], rec_start = recstart

cdf_varput, cdfid, 'LETProtonFlux', [sep_data.flux.LETProtons1, $
   sep_data.flux.LETProtons2A, sep_data.flux.LETProtons2B, $
   sep_data.flux.LETProtons3], rec_start = recstart
cdf_varput, cdfid, 'LET4HeFlux', [sep_data.flux.LET4He1, $
   sep_data.flux.LET4He2A, sep_data.flux.LET4He2B, sep_data.flux.LET4He3A, $
   sep_data.flux.LET4He3B], rec_start = recstart
cdf_varput, cdfid, 'LET3HeFlux', [sep_data.flux.LET3He1, $
   sep_data.flux.LET3He2], rec_start = recstart
cdf_varput, cdfid, 'LETCNOFlux', [sep_data.flux.LETCNO1, $
   sep_data.flux.LETCNO2, sep_data.flux.LETCNO3], rec_start = recstart
cdf_varput, cdfid, 'LETFeFlux', [sep_data.flux.LETFe1, sep_data.flux.LETFe2, $
   sep_data.flux.LETFe3, sep_data.flux.LETFe4], rec_start = recstart

cdf_varput, cdfid, 'SEPTElectronFlux', [sep_data.flux.SEPT0N_Electrons1, $
   sep_data.flux.SEPT2N_Electrons1, sep_data.flux.SEPT0E_Electrons1, $
   sep_data.flux.SEPT2E_Electrons1, sep_data.flux.SEPTS_Electrons2, $
   sep_data.flux.SEPTS_Electrons3, sep_data.flux.SEPT0N_Electrons4, $
   sep_data.flux.SEPT2N_Electrons4, sep_data.flux.SEPT0E_Electrons4, $
   sep_data.flux.SEPT2E_Electrons4], rec_start = recstart
cdf_varput, cdfid, 'SEPTIonFlux', [sep_data.flux.SEPT1N_Ions1, $
   sep_data.flux.SEPT3N_Ions1, sep_data.flux.SEPT1E_Ions1, $
   sep_data.flux.SEPT3E_Ions1, sep_data.flux.SEPTS_Ions2, $
   sep_data.flux.SEPTS_Ions3, sep_data.flux.SEPT1N_Ions4, $
   sep_data.flux.SEPT3N_Ions4, sep_data.flux.SEPT1E_Ions4, $
   sep_data.flux.SEPT3E_Ions4], rec_start = recstart

cdf_varput, cdfid, 'HETElectronCnts', sep_data.counts.HETElectrons, rec_start = recstart
cdf_varput, cdfid, 'HETProtonCnts', [sep_data.counts.HETProtons1, $
   sep_data.counts.HETProtons2, sep_data.counts.HETProtons3], rec_start = recstart
cdf_varput, cdfid, 'HETHeCnts', [sep_data.counts.HETHe1, $
   sep_data.counts.HETHe2, sep_data.counts.HETHe3], rec_start = recstart
cdf_varput, cdfid, 'HETCNOCnts', [sep_data.counts.HETCNO1, $
   sep_data.counts.HETCNO2], rec_start = recstart
cdf_varput, cdfid, 'HETFeCnts', sep_data.counts.HETFe, rec_start = recstart

cdf_varput, cdfid, 'SITHeCnts', [sep_data.counts.SITHe1, sep_data.counts.SITHe2, $
   sep_data.counts.SITHe3, sep_data.counts.SITHe4], rec_start = recstart
cdf_varput, cdfid, 'SITCNOCnts', [sep_data.counts.SITCNO1, $
   sep_data.counts.SITCNO2, sep_data.counts.SITCNO3, sep_data.counts.SITCNO4], rec_start = recstart
cdf_varput, cdfid, 'SITFeCnts', [sep_data.counts.SITFe1, sep_data.counts.SITFe2, $
   sep_data.counts.SITFe3, sep_data.counts.SITFe4], rec_start = recstart

cdf_varput, cdfid, 'LETProtonCnts', [sep_data.counts.LETProtons1, $
   sep_data.counts.LETProtons2A, sep_data.counts.LETProtons2B, $
   sep_data.counts.LETProtons3], rec_start = recstart
cdf_varput, cdfid, 'LET4HeCnts', [sep_data.counts.LET4He1, $
   sep_data.counts.LET4He2A, sep_data.counts.LET4He2B, sep_data.counts.LET4He3A, $
   sep_data.counts.LET4He3B], rec_start = recstart
cdf_varput, cdfid, 'LET3HeCnts', [sep_data.counts.LET3He1, $
   sep_data.counts.LET3He2], rec_start = recstart
cdf_varput, cdfid, 'LETCNOCnts', [sep_data.counts.LETCNO1, $
   sep_data.counts.LETCNO2, sep_data.counts.LETCNO3], rec_start = recstart
cdf_varput, cdfid, 'LETFeCnts', [sep_data.counts.LETFe1, sep_data.counts.LETFe2, $
   sep_data.counts.LETFe3, sep_data.counts.LETFe4], rec_start = recstart

cdf_varput, cdfid, 'SEPTElectronCnts', [sep_data.counts.SEPT0N_Electrons1, $
   sep_data.counts.SEPT2N_Electrons1, sep_data.counts.SEPT0E_Electrons1, $
   sep_data.counts.SEPT2E_Electrons1, sep_data.counts.SEPTS_Electrons2, $
   sep_data.counts.SEPTS_Electrons3, sep_data.counts.SEPT0N_Electrons4, $
   sep_data.counts.SEPT2N_Electrons4, sep_data.counts.SEPT0E_Electrons4, $
   sep_data.counts.SEPT2E_Electrons4], rec_start = recstart
cdf_varput, cdfid, 'SEPTIonCnts', [sep_data.counts.SEPT1N_Ions1, $
   sep_data.counts.SEPT3N_Ions1, sep_data.counts.SEPT1E_Ions1, $
   sep_data.counts.SEPT3E_Ions1, sep_data.counts.SEPTS_Ions2, $
   sep_data.counts.SEPTS_Ions3, sep_data.counts.SEPT1N_Ions4, $
   sep_data.counts.SEPT3N_Ions4, sep_data.counts.SEPT1E_Ions4, $
   sep_data.counts.SEPT3E_Ions4], rec_start = recstart

cdf_varput, cdfid, 'MAGHKP', mag_data.imaghkp, rec_start = recstart
cdf_varput, cdfid, 'Epoch_MAG', mag0epoch, rec_start = recstart*6
cdf_varput, cdfid, 'MAGBField', double([mag_data.MAGX_01, $
   mag_data.MAGY_01, mag_data.MAGZ_01]), rec_start = recstart*6
cdf_varput, cdfid, 'Epoch_MAG', mag1epoch, rec_start = recstart*6+1
cdf_varput, cdfid, 'MAGBField', double([mag_data.MAGX_02, $
   mag_data.MAGY_02, mag_data.MAGZ_02]), rec_start = recstart*6+1
cdf_varput, cdfid, 'Epoch_MAG', mag2epoch, rec_start = recstart*6+2
cdf_varput, cdfid, 'MAGBField', double([mag_data.MAGX_03, $
   mag_data.MAGY_03, mag_data.MAGZ_03]), rec_start = recstart*6+2
cdf_varput, cdfid, 'Epoch_MAG', mag3epoch, rec_start = recstart*6+3
cdf_varput, cdfid, 'MAGBField', double([mag_data.MAGX_04, $
   mag_data.MAGY_04, mag_data.MAGZ_04]), rec_start = recstart*6+3
cdf_varput, cdfid, 'Epoch_MAG', mag4epoch, rec_start = recstart*6+4
cdf_varput, cdfid, 'MAGBField', double([mag_data.MAGX_05, $
   mag_data.MAGY_05, mag_data.MAGZ_05]), rec_start = recstart*6+4
cdf_varput, cdfid, 'Epoch_MAG', mag5epoch, rec_start = recstart*6+5
cdf_varput, cdfid, 'MAGBField', double([mag_data.MAGX_06, $
   mag_data.MAGY_06, mag_data.MAGZ_06]), rec_start = recstart*6+5

cdf_close, cdfid

return
end
