PRO IMPACT_BEACON_CESR, PACKET, SCID, OUT_PATH, version, ascii=ascii
;+
; Project     :	STEREO - IMPACT
;
; Name        : IMPACT_BEACON
;
; Purpose     :	Convert raw IMPACT Beacon data into physical units
;
; Category    :	STEREO, IMPACT
;
; Explanation :	
;
; Syntax      :	IMPACT_BEACON, PACKET, FILENAME
;
; Examples    :	
;
; Inputs      :	PACKET - an IMPACT Beacon packet to be processed
;               FILENAME - the name of a directory for output files
;
; Opt. Inputs :	None.
;
; Outputs     :	None.
;
; Opt. Outputs:	None.
;
; Keywords    :	ascii - write ascii file instead of binary file
;
; Calls       :	None
;
; Common      : None
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 10-Nov-2005, Peter Schroeder,
;                  UC-Berkeley.
;
; Contact     :	peters@ssl.berkeley.edu
;-
;

utc = anytim2utc(parse_stereo_pkt(packet,/pkt_date),/external)



if ((utc.day lt 10) and (utc.month lt 10)) then datestr = string(utc.year,utc.month,utc.day,'(I4,"0",I1,"0",I1)') $
else if ((utc.day lt 10) and (utc.month ge 10)) then datestr=string(utc.year,utc.month,utc.day,'(I4,I2,"0",I1)') $
else if ((utc.day ge 10) and (utc.month lt 10)) then datestr=string(utc.year,utc.month,utc.day,'(I4,"0",I1,I2)') $
else datestr=string(utc.year,utc.month,utc.day,'(I4,I2,I2)')




mag_data = mag_xform_270(packet,/quiet)
sweaste_data = sweaste_270(packet,/compressed)
sep_beacon, packet, sep_data

ISCStatus = packet.dat[2]
InterfaceActive = packet.dat[1]
SWEAModeID = packet.dat[4]
STEModeID = packet.dat[3]
IAutoLUT = packet.dat[6]
SWEADHKP = packet.dat[5]

utcpkttim = parse_stereo_pkt(packet,/pkt_date)
utcsec = utc2sec(utcpkttim)
;utcpkktim = sec2utc(utcsec + double(packet.dat[0])/65536d)


;----------------------------------------------------------------
;
; Output file :

if (SCID eq 'EA'XU) then SCSTRING = 'sta' $
else SCSTRING = 'stb'


if keyword_set(ascii) then begin
;----------------------------------------------------------------
; ascii file (for test) :

	filename = SCSTRING+'_l1_beac_xxxx_'+datestr+'_v'+version+'.ascii'
	filematch = file_search(filename, count = filecount)

	unit=71
	openu,unit,filename,/append
	close,unit


endif else begin
;----------------------------------------------------------------
; binary file :

	header_file = out_path+'/'+SCSTRING+'_l1_beac_head_'+datestr+'_v'+version+'.bin'
	filematch = file_search(header_file, count = filecount)

	sweaste_file = out_path+'/'+SCSTRING+'_l1_beac_swea_'+datestr+'_v'+version+'.bin'
	filematch = file_search(sweaste_file, count = filecount)

	sep_file = out_path+'/'+SCSTRING+'_l1_beac_sepx_'+datestr+'_v'+version+'.bin'
	filematch = file_search(sep_file, count = filecount)

	mag_file = out_path+'/'+SCSTRING+'_l1_beac_magx_'+datestr+'_v'+version+'.bin'
	filematch = file_search(mag_file, count = filecount)

	;----------------------------------------------------------------
	; HEADER :
	unit0=62
	OPENU,unit0,header_file,/append,/GET_LUN,/SWAP_IF_LITTLE_ENDIAN

		utc = anytim2utc(utcpkttim,/external)
		julian= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond
	        writeu, unit0, julian, ISCStatus, InterfaceActive, SWEAModeID, STEModeID, $
		               IAutoLUT, SWEADHKP, mag_data.imaghkp, sep_data.header.SWversion

	free_lun,unit0
	close, unit0


	;----------------------------------------------------------------
	; SWEA/STE :
	unit1=72
	OPENU,unit1,sweaste_file,/append,/GET_LUN,/SWAP_IF_LITTLE_ENDIAN

		utc = sec2utc(utcsec + 61d)
		utc = anytim2utc(utc,/external)

		julian= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond
		writeu, unit1, julian
		writeu, unit1, float(sweaste_data.SWEA_N), float(sweaste_data.SWEA_V),$
		               float(sweaste_data.SWEA_P),$
		               float(sweaste_data.SWEA_NH), float(sweaste_data.SWEA_V0)

		writeu, unit1, sweaste_data.STE_Uns
		writeu, unit1, sweaste_data.STE_Us
		writeu, unit1, sweaste_data.STE_D
		writeu, unit1, sweaste_data.STE_LLD

		writeu, unit1, float(sweaste_data.SWEA_MagAz), float(sweaste_data.SWEA_MagEl)

		for a=0,11 do for e=0,1 do  writeu, unit1, sweaste_data.SWEA_PAD[e*12+a]


	free_lun,unit1
	close, unit1


        if keyword_set(var_type) then begin
		unitvar = 19
                ; B11 : begin var info
                openw,unitvar,'beacon_var',/append

                info=size(julian)
                printf,unitvar,"Julian :",info[1],julian
		close, unitvar
	endif




	;----------------------------------------------------------------
	; SEP :
	unit2=82
	OPENU,unit2,sep_file,/append,/GET_LUN,/SWAP_IF_LITTLE_ENDIAN

		utc = anytim2utc(sep_data.header.timeCDS,/external)
		julian= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond

		writeu, unit2, julian,$
		              sep_data.status.HETLiveTime, sep_data.status.HETStopEffic, sep_data.status.HETPenEffic,$
		              sep_data.status.HETStatus, sep_data.status.LETLiveTime, sep_data.status.LETTrigCnts,$
		              sep_data.status.LETHazCnts, sep_data.status.LETAcceptCnts, sep_data.status.LETCodeOK,$
		              sep_data.status.LETHeaterDutyCycle, sep_data.status.LETLeakConv,$
		              sep_data.status.LETDyThState, sep_data.status.LETMinute, sep_data.status.SEPTStatus

		;------------------ On c'est arrtéla pour SEP --------------------

		writeu, unit2, float(sep_data.HETflux.Electrons)
		writeu, unit2, [float(sep_data.HETflux.Protons1), float(sep_data.HETflux.Protons2), float(sep_data.HETflux.Protons3)],$
		              [float(sep_data.HETflux.He1), float(sep_data.HETflux.He2), float(sep_data.HETflux.He3)],$
		              [float(sep_data.HETflux.CNO1), float(sep_data.HETflux.CNO2)], float(sep_data.HETflux.Fe),$
		              [float(sep_data.SITflux.He1), float(sep_data.SITflux.He2), float(sep_data.SITflux.He3), float(sep_data.SITflux.He4)],$
		              [float(sep_data.SITflux.CNO1), float(sep_data.SITflux.CNO2), float(sep_data.SITflux.CNO3), float(sep_data.SITflux.CNO4)],$
		              [float(sep_data.SITflux.Fe1), float(sep_data.SITflux.Fe2), float(sep_data.SITflux.Fe3), float(sep_data.SITflux.Fe4)]

		writeu, unit2, [float(sep_data.LETflux.Protons1), $
			   float(sep_data.LETflux.Protons2A), float(sep_data.LETflux.Protons2B), $
			   float(sep_data.LETflux.Protons3)]
		writeu, unit2, [float(sep_data.LETflux.He4_1), $
			   float(sep_data.LETflux.He4_2A), float(sep_data.LETflux.He4_2B), float(sep_data.LETflux.He4_3A), $
			   float(sep_data.LETflux.He4_3B)]
		writeu, unit2, [float(sep_data.LETflux.He3_1), $
			   float(sep_data.LETflux.He3_2)]
		writeu, unit2, [float(sep_data.LETflux.CNO1), $
			   float(sep_data.LETflux.CNO2), float(sep_data.LETflux.CNO3)]
		writeu, unit2, [float(sep_data.LETflux.Fe1), float(sep_data.LETflux.Fe2), $
			   float(sep_data.LETflux.Fe3), float(sep_data.LETflux.Fe4)]

		writeu, unit2, [float(sep_data.SEPTflux.Electrons0N_1), $
			   float(sep_data.SEPTflux.Electrons2N_1), float(sep_data.SEPTflux.Electrons0E_1), $
			   float(sep_data.SEPTflux.Electrons2E_1), float(sep_data.SEPTflux.ElectronsSum_2), $
			   float(sep_data.SEPTflux.ElectronsSum_3), float(sep_data.SEPTflux.Electrons0N_4), $
			   float(sep_data.SEPTflux.Electrons2N_4), float(sep_data.SEPTflux.Electrons0E_4), $
			   float(sep_data.SEPTflux.Electrons2E_4)]
		writeu, unit2, [float(sep_data.SEPTflux.Ions1N_1), $
			   float(sep_data.SEPTflux.Ions3N_1), float(sep_data.SEPTflux.Ions1E_1), $
			   float(sep_data.SEPTflux.Ions3E_1), float(sep_data.SEPTflux.IonsSum_2), $
			   float(sep_data.SEPTflux.IonsSum_3), float(sep_data.SEPTflux.Ions1N_4), $
			   float(sep_data.SEPTflux.Ions3N_4), float(sep_data.SEPTflux.Ions1E_4), $
			   float(sep_data.SEPTflux.Ions3E_4)]

		writeu, unit2, sep_data.HETcounts.Electrons
		writeu, unit2, [sep_data.HETcounts.Protons1, $
			   sep_data.HETcounts.Protons2, sep_data.HETcounts.Protons3]
		writeu, unit2, [sep_data.HETcounts.He1, $
			   sep_data.HETcounts.He2, sep_data.HETcounts.He3]
		writeu, unit2, [sep_data.HETcounts.CNO1, $
			   sep_data.HETcounts.CNO2]
		writeu, unit2, sep_data.HETcounts.Fe

		writeu, unit2, [sep_data.SITcounts.He1, sep_data.SITcounts.He2, $
			   sep_data.SITcounts.He3, sep_data.SITcounts.He4]
		writeu, unit2, [sep_data.SITcounts.CNO1, $
			   sep_data.SITcounts.CNO2, sep_data.SITcounts.CNO3, sep_data.SITcounts.CNO4]
		writeu, unit2, [sep_data.SITcounts.Fe1, sep_data.SITcounts.Fe2, $
			   sep_data.SITcounts.Fe3, sep_data.SITcounts.Fe4]

		writeu, unit2, [sep_data.LETcounts.Protons1, $
			   sep_data.LETcounts.Protons2A, sep_data.LETcounts.Protons2B, $
			   sep_data.LETcounts.Protons3]
		writeu, unit2, [sep_data.LETcounts.He4_1, $
			   sep_data.LETcounts.He4_2A, sep_data.LETcounts.He4_2B, sep_data.LETcounts.He4_3A, $
			   sep_data.LETcounts.He4_3B]
		writeu, unit2, [sep_data.LETcounts.He3_1, $
			   sep_data.LETcounts.He3_2]
		writeu, unit2, [sep_data.LETcounts.CNO1, $
			   sep_data.LETcounts.CNO2, sep_data.LETcounts.CNO3]
		writeu, unit2, [sep_data.LETcounts.Fe1, sep_data.LETcounts.Fe2, $
			   sep_data.LETcounts.Fe3, sep_data.LETcounts.Fe4]

		writeu, unit2, [sep_data.SEPTcounts.Electrons0N_1, $
			   sep_data.SEPTcounts.Electrons2N_1, sep_data.SEPTcounts.Electrons0E_1, $
			   sep_data.SEPTcounts.Electrons2E_1, sep_data.SEPTcounts.ElectronsSum_2, $
			   sep_data.SEPTcounts.ElectronsSum_3, sep_data.SEPTcounts.Electrons0N_4, $
			   sep_data.SEPTcounts.Electrons2N_4, sep_data.SEPTcounts.Electrons0E_4, $
			   sep_data.SEPTcounts.Electrons2E_4]
		writeu, unit2, [sep_data.SEPTcounts.Ions1N_1, $
			   sep_data.SEPTcounts.Ions3N_1, sep_data.SEPTcounts.Ions1E_1, $
			   sep_data.SEPTcounts.Ions3E_1, sep_data.SEPTcounts.IonsSum_2, $
			   sep_data.SEPTcounts.IonsSum_3, sep_data.SEPTcounts.Ions1N_4, $
			   sep_data.SEPTcounts.Ions3N_4, sep_data.SEPTcounts.Ions1E_4, $
			   sep_data.SEPTcounts.Ions3E_4]

	free_lun,unit2
	close, unit2


	;----------------------------------------------------------------
	; MAG :
	unit3=92
	OPENU,unit3,mag_file,/append,/GET_LUN,/SWAP_IF_LITTLE_ENDIAN

	utc = sec2utc(utcsec + 5d)
	utc = anytim2utc(utc,/external)
	julian0= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond

	utc = sec2utc(utcsec + 15d)
	utc = anytim2utc(utc,/external)
	julian1= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond

	utc = sec2utc(utcsec + 25d)
	utc = anytim2utc(utc,/external)
	julian2= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond

	utc = sec2utc(utcsec +35d)
	utc = anytim2utc(utc,/external)
	julian3= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond

	utc = sec2utc(utcsec + 45d)
	utc = anytim2utc(utc,/external)
	julian4= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond

	utc = sec2utc(utcsec + 55d)
	utc = anytim2utc(utc,/external)
	julian5= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond


		writeu, unit3, julian0
		writeu, unit3, mag_data.MAGX_01, mag_data.MAGY_01, mag_data.MAGZ_01
		writeu, unit3, julian1
		writeu, unit3, mag_data.MAGX_02, mag_data.MAGY_02, mag_data.MAGZ_02
		writeu, unit3, julian2
		writeu, unit3, mag_data.MAGX_03, mag_data.MAGY_03, mag_data.MAGZ_03
		writeu, unit3, julian3
		writeu, unit3, mag_data.MAGX_04, mag_data.MAGY_04, mag_data.MAGZ_04
		writeu, unit3, julian4
		writeu, unit3, mag_data.MAGX_05, mag_data.MAGY_05, mag_data.MAGZ_05
		writeu, unit3, julian5
		writeu, unit3, mag_data.MAGX_06, mag_data.MAGY_06, mag_data.MAGZ_06


	free_lun,unit3
	close, unit3



	
endelse


return
end
