PRO IMPACT_BEACON, SCIDATA, SCID, OUT_PATH
;+
; Project     :	STEREO - IMPACT
;
; Name        : IMPACT_BEACON
;
; Purpose     :	Convert raw IMPACT Beacon data into physical units
;
; Category    :	STEREO, IMPACT
;
; Explanation :	
;
; Syntax      :	IMPACT_BEACON, PACKET, FILENAME
;
; Examples    :	
;
; Inputs      :	PACKET - an IMPACT Beacon packet to be processed
;               FILENAME - the name of a CDF file for output
;
; Opt. Inputs :	None.
;
; Outputs     :	None.
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       :	None
;
; Common      : None
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 10-Nov-2005, Peter Schroeder,
;                  UC-Berkeley.
;
; Contact     :	peters@ssl.berkeley.edu
;-
;


utc = anytim2utc(SCIDATA.TIME,/external)

if ((utc.day lt 10) and (utc.month lt 10)) then datestr = string(utc.year,utc.month,utc.day,'(I4,"0",I1,"0",I1)') $
else if ((utc.day lt 10) and (utc.month ge 10)) then datestr=string(utc.year,utc.month,utc.day,'(I4,I2,"0",I1)') $
else if ((utc.day ge 10) and (utc.month lt 10)) then datestr=string(utc.year,utc.month,utc.day,'(I4,"0",I1,I2)') $
else datestr=string(utc.year,utc.month,utc.day,'(I4,I2,I2)')

; Open output file :
if (SCID eq 'EA'XU) then SCSTRING = 'sta' $
else SCSTRING = 'stb'

filename = out_path+'/'+SCSTRING+'_l1_beaconxx_'+datestr+'_v01.bin'
filematch = file_search(filename, count = filecount)


unit=11
openu,unit,filename,/append


        julian= tu_to_date(utc.year,utc.month,utc.day,utc.hour,utc.minute,utc.second)+utc.millisecond


        Ve = dblarr(3)
        Ve[0] = SCIDATA.MOMENTS.NVx
        Ve[1] = SCIDATA.MOMENTS.NVy
        Ve[2] = SCIDATA.MOMENTS.NVz

        Pe = dblarr(6)
        Pe[0] = SCIDATA.MOMENTS.NPxx
        Pe[1] = SCIDATA.MOMENTS.NPyy
        Pe[2] = SCIDATA.MOMENTS.NPzz
        Pe[3] = SCIDATA.MOMENTS.NPxy
        Pe[4] = SCIDATA.MOMENTS.NPxz
        Pe[5] = SCIDATA.MOMENTS.NPyz

        He = dblarr(3)
        He[0] = SCIDATA.MOMENTS.NHx
        He[1] = SCIDATA.MOMENTS.NHy
        He[2] = SCIDATA.MOMENTS.NHz

        N = SCIDATA.MOMENTS.N
        V0 = SCIDATA.MOMENTS.V0

        printf, unit, 'Time',utc.year,utc.month,utc.day,utc.hour,utc.minute
        printf, unit, FORMAT = '(F16.0, 2(" ",I) )',$
                                julian, SCIDATA.SWEAModeID,SCIDATA.SWEADHKP


        printf, unit, FORMAT = '( ("SWEAMOMENT"), 13(" ",E), (" ",I) )',$
                                N, Ve[*], Pe[*], He[*], V0

        printf, unit, FORMAT = '( ("SWEAPAD"), 26(" ",E) )',$
                                SCIDATA.SWEAPAD.MagAz,SCIDATA.SWEAPAD.MagEl,$
                                SCIDATA.SWEAPAD.PAD


	; B11 : begin var info
	openu,12,'beacon_var',/append

	info=size(julian)
	printf,12,"Julian :",info[1]
	info=size(SCIDATA.SWEAModeID)
	printf,12,"SWEAModeID :",info[1]
	info=size(SCIDATA.SWEADHKP)
	printf,12,"SWEADHKP :",info[1]
	info=size(N)
	printf,12,"N :",info[1]
	info=size(E)
	printf,12,"E :",info[1]
	info=size(Ve)
	printf,12,"Ve :",info[1]
	info=size(Pe)
	printf,12,"Pe :",info[1]
	info=size(Pe[1])
	printf,12,"Pe[1] :",info[1]
	info=size(He)
	printf,12,"He :",info[1]
	info=size(V0)
	printf,12,"V0 :",info[1]

	info=size(SCIDATA.SWEAPAD.MagAz)
	printf,12,"SWEAPAD.MagAz :",info[1]
	info=size(SCIDATA.SWEAPAD.MagEl)
	printf,12,"SWEAPAD.MagEl :",info[1]
	info=size(SCIDATA.SWEAPAD.PAD)
	printf,12,"SWEAPAD.PAD :",info[1]
	info=size(SCIDATA.SWEAPAD.PAD[1])
	printf,12,"SWEAPAD.PAD[1] :",info[1]

	close, 12
	; B11 : end var info
 
 
 close, unit
 
 return
 end
