PRO ENERGY
;+
; Project     :	STEREO - IMPACT/SWEA
;
; Name        : SWEA_TO_ASCII
;
; Purpose     :	Write SWEA data to ASCII file
;
; Category    :	STEREO, IMPACT, SWEA
;
; Explanation :	
;
; Syntax      :	SWEA_TO_ASCII , SCIDATA, SCID
;
; Examples    :	
;
; Inputs      :	SCIDATA - a structure including SWEA 210 science data
;               DATESTRING - the date string for the filename
;		SCID - the spacecraft ID
;
; Opt. Inputs :	None.
;
; Outputs     :	None.
;
; Opt. Outputs:	None.
;
; Keywords    :	None
;
; Calls       :	None
;
; Common      : None
;
; Restrictions:	
;
; Side effects:	None.
;
; Prev. Hist. :	None.
;
; History     :	Version 1 (preliminary), 08-11-2006, Nicolas Pene,
;                  CESR.
;
; Contact     :	nicolas.pene@cesr.fr
;-
;

swea_l1_common
swea_l1_energies
common swea_l1_common ;use common block


    struct = { $
        ebeac: dblarr(2), $
        epitch: dblarr(7), $
        edist: dblarr(16), $
        efull: dblarr(48) }

    for i=0,15 do struct.edist[i] = $
        total(swea_energies[where(SWEA_DIST_ENERGIES eq i,ecnt)])/ecnt

    for i=0,6 do struct.epitch[i] = $
        total(swea_energies[where(SWEA_PAD_ENERGIES eq i,ecnt)])/ecnt

    struct.ebeac[0] = total(swea_energies[SWEAPADE0])/ecnt
    struct.ebeac[1] = total(swea_energies[SWEAPADE1])/ecnt

    for i=0,47 do struct.efull[i] = $
        total(swea_energies[where(SWEA_FULL_ENERGIES eq i,ecnt)])/ecnt

		unit2 = 20
		OPENU,unit2,"energies.txt",/append
			printf, unit2, "dist : ",struct.edist
			printf, unit2
			printf, unit2, "pitch : ",struct.epitch
			printf, unit2
			printf, unit2, "beacon : ",struct.ebeac
			printf, unit2
			printf, unit2, "full : ",struct.efull
		close, unit2


return
end
