;
;  GSE_DATA by Nicolas PENE
;  convert cdf files in the GSE system
;

pro gse_data, infile, out_path, version, type, day, sat

if (sat eq 'ahead') then scstring = 'sta' $
else scstring = 'stb'

if ( (type eq 'magx') || (type eq 'magb') ) then begin

    ; open the CDF file :
    id = CDF_OPEN(infile)

    lire_var_cdf, id,'Epoch',date,err,typ
    cdf_epoch, decalage, 1958, 1, 1, 0, 0, 0, /compute_epoch
    nb_date = N_ELEMENTS(date)
    newdate = date - decalage
    att = fltarr(3,3,3600)

    ; .........................................
    ; create attitude tab for the day :

    ; load attitude kernel :
    load_stereo_spice, errmsg=message, _extra=_extra

    date_to_tu,newdate[nb_date/2],year,month,dday,hour,minute,second
    numdate = tu_to_date(year,month,dday,0,0,0)

    for m=0,59 do begin
        for h=0,23 do begin
            attdate= date_to_str(numdate,format=0)
            att[*,*,h*60.+m] = float(transpose(get_stereo_cmat(attdate,sat, system="GSE")))
            numdate=numdate+60000
            ;printf,unit2,attdate,att[*,*,h*60.+m]
        endfor
    endfor

    ; .........................................
    ; file name date :
    if ((dday lt 10) and (month lt 10)) then datestr = string(year,month,dday,'(I4,"0",I1,"0",I1)') $
    else if ((dday lt 10) and (month ge 10)) then datestr=string(year,month,dday,'(I4,I2,"0",I1)') $
    else if ((dday ge 10) and (month lt 10)) then datestr=string(year,month,dday,'(I4,"0",I1,I2)') $
    else datestr=string(year,month,dday,'(I4,I2,I2)')

    ;filename=out_path+'/'+scstring+'_l1_'+type+'_xxxx_'+datestr+'_v'+version+'.bin'
    filename=out_path+'/'+scstring+'_l1_'+type+'_xxxx_'+datestr+'_v'+version+'.bin'

        ;avant
	;lire_var_cdf, id,'B_SC',data,err,typ

	;apres
        lire_var_cdf, id,'BFIELD',data,err,typ
	data=data[*,0:2]

        nb_rec = N_ELEMENTS(data)
        nb_rec = nb_rec/3
        if (nb_rec ne nb_date) then begin
            print,"ERROR : number of records and dates don't correspond"
            return
        endif
        
        nbd=nb_date-1

        OPENW,unit,filename,/GET_LUN,/SWAP_IF_LITTLE_ENDIAN

        for d = 0.,nbd,1. do begin


            date_to_tu,newdate[d],year,month,dday,hour,minute,second

            if (day eq dday) then begin 

                ;julian= tu_to_date(year,month,dday,hour,minute,second)
    
                B_GSE=att[*,*,hour*60.+minute]##data[d,*]
                ;printf,unit,FORMAT = '(F16.0, 6(" ",F))',newdate[d],B_GSE
                writeu,unit,newdate[d],B_GSE
                ;writeu,unit,newdate[d],data[d,*]
            endif
        endfor

        close,unit
        free_lun,unit

endif

CDF_CLOSE,id
return
end
