;
;  DEBUG MAG GSE, inspired by GSE_DATA
;  by Nicolas PENE
;  check mag distribution in GSE Frame
;

pro debug_mag_gse, infile, version, day, sat

if (sat eq 'ahead') then scstring = 'sta' $
else scstring = 'stb'


; delta B :
deltax=40
decal=deltax/2
B_STAT=fltarr(deltax+1,3)
B_STAT[*,*]=0
nb_bstat=0

; -----------
; Days loop :

for da=1,30 do begin
    if ( da lt 10 ) then day = string(da,'("0",I1)') $
    else day = string(da,'(I2)')

    ifile=infile+day+'_V02.cdf'
    print
    print,"           Day ",day


    ; open the CDF file :
    id = CDF_OPEN(ifile)

    lire_var_cdf, id,'Epoch',date,err,typ
    cdf_epoch, decalage, 1958, 1, 1, 0, 0, 0, /compute_epoch
    nb_date = N_ELEMENTS(date)
    newdate = date - decalage
    att = fltarr(3,3,3600)
    nb_bstat=nb_bstat+nb_date

    ; .........................................
    ; create attitude tab for the day :

    ; load attitude kernel :
    load_stereo_spice, errmsg=message, _extra=_extra

    date_to_tu,newdate[nb_date/2],year,month,dday,hour,minute,second
    numdate = tu_to_date(year,month,dday,0,0,0)

    for m=0,59 do begin
        for h=0,23 do begin
            attdate= date_to_str(numdate,format=0)
            att[*,*,h*60.+m] = float(transpose(get_stereo_cmat(attdate,sat, system="GSE")))
            ;att[*,*,h*60.+m] = float(get_stereo_cmat(attdate,sat, system="GSE"))

            numdate=numdate+60000
            ;printf,unit2,attdate,att[*,*,h*60.+m]
        endfor
    endfor

    ; .........................................
    ; file name date :
    if ((dday lt 10) and (month lt 10)) then datestr = string(year,month,dday,'(I4,"0",I1,"0",I1)') $
    else if ((dday lt 10) and (month ge 10)) then datestr=string(year,month,dday,'(I4,I2,"0",I1)') $
    else if ((dday ge 10) and (month lt 10)) then datestr=string(year,month,dday,'(I4,"0",I1,I2)') $
    else datestr=string(year,month,dday,'(I4,I2,I2)')


        lire_var_cdf, id,'B_SC',data,err,typ
        nb_rec = N_ELEMENTS(data)
        nb_rec = nb_rec/3
        if (nb_rec ne nb_date) then begin
            print,"ERROR : number of records and dates don't correspond"
            return
        endif
        
        nbd=nb_date-1
	

        for d = 0.,nbd,1. do begin
            if (day eq dday) then begin 

                ;julian= tu_to_date(year,month,dday,hour,minute,second)
                B_GSE=att[*,*,hour*60.+minute]##data[d,*]
		for i=0,2 do begin
			if ( (B_GSE[i] gt -decal) and (B_GSE[i] lt 0 )) then begin 
			   b=ceil(B_GSE[i])+decal
			   B_STAT[b,i]=B_STAT[b,i]+1
			endif else if  ( (B_GSE[i] ge 0) and (B_GSE[i] lt decal )) then begin
			   b=ceil(B_GSE[i])+decal
			   B_STAT[b,i]=B_STAT[b,i]+1
			endif
		endfor
		
            endif
        endfor

        CDF_CLOSE,id

endfor

; ------------------
; write GNUPLOT file
filename = "mag.plt"
OPENU,unit,filename,/append,/GET_LUN

for i=0,deltax-1 do begin
	printf,unit,i-decal,B_STAT[i,0]/nb_bstat,B_STAT[i,1]/nb_bstat,B_STAT[i,2]/nb_bstat
endfor


close,unit
free_lun,unit

return
end
