;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: cdf_file.pro,v $, v $Revision: 1.2 $
;
;	Date	: $Date: 2007/03/15 17:23:37 $
;
;	Auteur	: $Author: stereo $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;----------------------------------------------------------------------------
FUNCTION marray,xx
;----------------------------------------------------------------------------

ON_ERROR,1

n = N_ELEMENTS(xx)
aa = LONG (xx(0))
FOR i = 1L,n-1 DO aa = aa*xx(i)

RETURN, aa

END


;----------------------------------------------------------------------------
PRO lire_var_cdf, id,CDF_var,x,err,type,REC_COUNT=rcnt,REC_START=rstr
;----------------------------------------------------------------------------

err=0
possible=1

inq = CDF_INQUIRE (id)
vinq = CDF_VARINQ (id,CDF_var)
type = vinq.datatype

IF KEYWORD_SET(rstr) EQ 0 THEN rstr = 0

IF vinq.is_zvar EQ 0 THEN BEGIN

     dims = TOTAL (vinq.dimvar)
     dimc = vinq.dimvar * inq.dim
     dimw = WHERE (dimc EQ 0)
     IF dimw(0) NE -1 THEN dimc(dimw) = 1

     IF KEYWORD_SET(rcnt) EQ 0 THEN rcnt = inq.maxrec+1
     IF (rstr+rcnt) GT (inq.maxrec+1) THEN rcnt = inq.maxrec+1 - rstr
     CDF_VARGET, id,CDF_var,x,COUNT=dimc,REC_COUNT=rcnt,REC_START=rstr
     pb=0

END ELSE BEGIN

     dims = TOTAL (vinq.dimvar)
     dimc = vinq.dimvar * vinq.dim
     dimw = WHERE (dimc EQ 0)
     IF dimw(0) NE -1 THEN dimc(dimw) = 1

     ; L'instruction suivante est commentee sinon on peut obtenir le message suivant:
     ; "CDF_CONTROL: CDF file error. NO_WRITE_ACCESS: Write access is not allowed on the CDF file(s)."
     ;CDF_CONTROL,id,variable=CDF_var,/zvariable,set_padvalue=0.0

     CDF_CONTROL,id,variable=CDF_var,/zvariable,get_var_info=vinfo
     IF KEYWORD_SET(rcnt) EQ 0 THEN rcnt = vinfo.maxrec+1
     ;IF (rstr+rcnt) GT (vinfo.maxrec+1) THEN rcnt = vinfo.maxrec+1 - rstr

     ; Premier element a lire: rstr        qui doit etre compris entre 0 et vinfo.maxrec
     ; Dernier element a lire: rstr+rcnt-1 qui doit etre compris entre 0 et vinfo.maxrec
     IF (rstr GE 0) AND (rstr LE vinfo.maxrec) AND (rstr+rcnt-1 GE rstr) AND (rstr+rcnt-1 LE vinfo.maxrec) THEN BEGIN
       CDF_VARGET, id,CDF_var,x,COUNT=dimc,REC_COUNT=rcnt,REC_START=rstr,/zvariable
       pb=0
     END ELSE BEGIN
       CDF_VARGET, id,CDF_var,x,COUNT=dimc,REC_COUNT=1,REC_START=0,/zvariable
       pb=1
     END

END

IF rcnt EQ 1 OR pb EQ 1 THEN BEGIN ; un seul enregistrement lu
  info = SIZE(x)
  nbdimensions = info[0]
  inforeform = nbdimensions EQ 0 ? [1] : [1,info[1:nbdimensions]]
  x = REFORM (nbdimensions EQ 0 ? [x]:x,inforeform)
  RETURN
END

sa = SIZE (x)
IF sa(0) GT 0 THEN BEGIN
	sa = sa(1:sa(0))
END ELSE BEGIN
	; La variable lue ne contient aucune valeur
	x = -1
	RETURN
END

IF (vinq.recvar EQ 'VARY') AND (dims NE 0) THEN BEGIN
     x = REFORM (x,[marray(sa(0:(N_ELEMENTS(sa)-2))),sa(N_ELEMENTS(sa)-1)])
     x = TRANSPOSE (x)
     sa = SHIFT (sa,1)
     x = REFORM (x,sa)
END

saw = WHERE (sa ne 1)
x = REFORM (x,sa(saw))

END
