#!/usr/bin/env perl

use File::Basename;
use File::Copy;

use FindBin;
use lib "$FindBin::Bin/../../lib";
use perl::get_modules;
use perl::time_manip;
use perl::stereo_path;


my $VERS = "1.0";
my $PRG = basename($0);

my $idl = "/usr/local/rsi/idl_6.3/bin/idl"; # the path to IDL

my $soft_path="$FindBin::Bin"; # chemin des softs SWEA
my $solarsoft_path="/DATA/STEREO/SOFT/SOLARSOFT"; # chemin de la SOLARSOFT Lib
$soft_path =~ s|bin$||;
my $cl_path="/DATA/CLUSTER/SOFT/CLL3/pro"; # chemin des soft CL pour traiter les fichiers CDF

#-------------------------------------------------------------------------------
sub cdf_treat {
#-------------------------------------------------------------------------------
	#
	#  Treatment for CDF files
	#

	my ($L0path,$L1path,$year,$month,$day,$sat,$file,$type)=@_;

	my $file_i,$fil;
	my $home=`echo ~`;
	chomp($home);
	my $rand_nb = rand();
	my $idl_file="${home}/stereo$rand_nb.tmp";
	my $satt="a";
	if ($sat eq "behind") { $satt="b" };

	# Output directory
	my $out_path="$L1path/$sat";
	my $out_path= sprintf("%s/%04d%02d%02d",$out_path,$year,$month,$day);

	# genere the binary L1 file :

	$file =~ s/V[0-9]{2}\.cdf$/V??.cdf/; # transform the end of the extention by .fin
	my @files = glob "$L0path/$sat/${file}";

	if (@files) {
		$file_i = pop(@files);

		# file version :
		$ver = $file_i;
		$ver =~ s/.+_V([0-9]{2})\..{3}$/$1/;
		
		# remove older output files :
		#foreach $fil (<$out_path/st?_l1_mag?_*>) {
		#	unlink($fil);
		#}

		if (! -d $out_path) { `mkdir -p $out_path` } # create the directory if unexistant

		# write temporary launch file for IDL :
		open(FILE, ">$idl_file") || die "Error : can't create $idl_file !\n";
		print FILE "PREF_SET, \'IDL_DLM_PATH\', \'$soft_path/../lib/:<IDL_DEFAULT>\', /COMMIT\n";
		print FILE ".run cdf_file\n";
		print FILE ".run temps\n";
		print FILE "gse_data,\'$file_i\',\'$out_path\',\'$ver\',\'$type\',\'$day\',\'$sat\'\n";
		print FILE "flush,-1\nflush,-2\nexit, status=1";
		close(FILE);
		
		# IDL launch :
		my $full_export=perl::stereo_path::get_idl_path($soft_path,$solarsoft_path);
		$file =basename($file_i);
		printf("\tGenere $year-$month-$day $sat data from $file ...\n");
		system "$full_export
		$idl -32 -quiet $idl_file 2>&1 | sed {/Compiled/d}";

		# remove temporary file
		unlink($idl_file);
	} else {
		print "sorry, no file $file for the $year-$month-$day :(\n";
	}

}


#-------------------------------------------------------------------------------
sub L1_genere {
#-------------------------------------------------------------------------------
	#
	#  genere L1 files
	#

	my ($L0path,$L1path,$year,$month,$day,$sat)=@_;

	my $file_i,$fil;
	my $home=`echo ~`;
	chomp($home);
	my $rand_nb = rand();
	my $idl_file="${home}/stereo$rand_nb.tmp";
	my $dayofyear;
	my $satt="a";
	if ($sat eq "behind") { $satt="b" };

	# get infile :
	$dayofyear=perl::time_manip::day_to_yearday($year,$month,$day,$sat);
	$file="impact_${sat}_${year}_${dayofyear}_?_??.???";

	# Output directory
	#my $out_path="$L1path/$sat/$year$month$day";
	my $out_path="$L1path/$sat";
	my $out_path= sprintf("%s/%04d%02d%02d",$out_path,$year,$month,$day);

	# genere the binary L1 file :

	$file =~ s/\..{3}$/.fin/; # transform the end of the extention by .fin
	my @files = glob "$L0path/$sat/$year/$month/${file}";

	if (@files) {
		$file_i = @files[-1];
		# If .fin file is empty
		if (-z $file_i) {
			$file =~ s/\..{3}$/.ptp/; # transform the end of the extention by .ptp
			@files = glob "$L0path/$sat/$year/$month/${file}";
		}
	}

	# if there is no *.fin files, search *.ptp files :
	if (! @files ) {
		$file =~ s/\..{3}$/.ptp/; # transform the end of the extention by .ptp
		@files = glob "$L0path/$sat/$year/$month/${file}";
	}

	if (@files) {
		$file_i = pop(@files);

		# file version :
		$ver = $file_i;
		$ver =~ s/.+_([0-9]{2})\..{3}$/$1/;
		
		# remove older output files :
		# my $file_o= sprintf("st%01s_l1_?????????_%04d%02d%02d_v%02d.bin",$satt,$year,$month,$day,$ver);
		foreach $fil (<$out_path/st?_l1_beac_*>) {
			unlink($fil);
		}
		foreach $fil (<$out_path/st?_l1_swea_*>) {
			unlink($fil);
		}

		if (! -d $out_path) { `mkdir -p $out_path` } # create the directory if unexistant

		# write temporary launch file for IDL :
		open(FILE, ">$idl_file") || die "Error : can't create $idl_file !\n";
		print FILE "swea_l1_cesr,\'$file_i\',\'$out_path\',\'$ver\'\n";
		print FILE "flush,-1\nflush,-2\nexit, status=1";
		close(FILE);

		# IDL launch :
		$file =basename($file_i);

		# La nouvelle solarsoft ne marche pas bien ici
		#my $full_export=perl::stereo_path::get_idl_path($soft_path,$solarsoft_path);
		
		# Mais ca marche avec l'ancienne version
		my $full_export=perl::stereo_path::get_idl_path($soft_path,"/DATA/STEREO/SOFT/SOLARSOFT_old");

		$file =basename($file_i);
		printf("\tGenere $year-$month-$day $sat data from $file ...\n");
		system "$full_export
		$idl -quiet $idl_file 2>&1 | sed {/Compiled/d}";

		# remove temporary file
		unlink($idl_file);
	} else {
		print "sorry, no file $file for the $year-$month-$day :(\n";
	}

}


#-------------------------------------------------------------------------------
sub calibr {
#-------------------------------------------------------------------------------
	#
	#  calibration
	#

	my ($L0path,$L1path,$year,$month,$day,$sat)=@_;

	my $file_i,$fil;
	my $home=`echo ~`;
	chomp($home);
	my $rand_nb = rand();
	my $idl_file="${home}/stereo$rand_nb.tmp";
	my $dayofyear;
	my $satt="a";
	if ($sat eq "behind") { $satt="b" };


	# get infile :
	# $dayofyear=perl::time_manip::day_to_yearday($year,$month,$day,$sat);
	$dayofyear=perl::time_manip::day_to_yearday($year,$month,1,$sat);

	# Output directory
	my $out_path="$L1path/$sat";

	#$path_telem="$L0path/$sat/$year/$month/impact_${sat}_${year}_";
	$path_telem="$L0path/$sat";
	$file_i="impact_${sat}_${year}_";

	# file version :
	$ver = "01";
		
	if (! -d $out_path) { `mkdir -p $out_path` } # create the directory if unexistant

	# for each deflections :
	my $defl;
	for ($defl=1;$defl<5;$defl++) {
		print "\n\n==========================================================\n\n";
		print "                    Deflection $defl\n\n";
		print "==========================================================\n\n\n";

		# write temporary launch file for IDL :
		open(FILE, ">$idl_file") || die "Error : can't create $idl_file !\n";
		print FILE ".run cdf_file\n";
		print FILE ".run temps\n";
		print FILE "swea_calibr,\'$path_telem\',\'$file_i\',\'$out_path\',\'03\',\'$sat\',\'$year\',\'$month\',\'$day\',\'$dayofyear\',\'$defl\'\n";
		print FILE "flush,-1\nflush,-2\nexit, status=1";
		close(FILE);

		# IDL launch :
		$file =basename($file_i);
		my $full_export=perl::stereo_path::get_idl_path($soft_path,$solarsoft_path);
		$file =basename($file_i);
		printf("\tCalibration for $year-$month-$day $sat data from $file ...\n");
		system "$full_export
		$idl -32 -quiet $idl_file 2>&1 | sed {/Compiled/d}";

		# remove temporary file
		unlink($idl_file);
	} # deflections loops end

}



#-------------------------------------------------------------------------------
sub telem_get_old {
#-------------------------------------------------------------------------------
	#
	#  Recuperation des donnees via wget et listing des nouvelles donnees :
	#

	my ($ftp,$L0path,$L1path)=@_;

	# data_type is l0 for telemetry data, and cdf for cdf data

	my @sats = ("ahead","behind");
	my @years = ("2006","2007","2008","2009","2010","2011","2012","2013","2014","2015");
	my $instr="impact";
	my $sat,$year,$month, $day, $yearday;
	my $file, $bfile;
	my @files_bef; # tableau de listing fichiers+dates avant le wget
	my @files_aft; # tableau de listing fichiers a generer


	foreach $sat (@sats) {

		print "Treat STEREO $sat telem files :\n";

		foreach $year (@years) {

			for ($month=01;$month<13;$month++) {

				if ($month <10) { $month =~ s/^0*/0/g }

				$path = "$L0path/$sat/$year/$month";

				if (! -d $path) { `mkdir -p $path` }
                

				#  old files scan

				# Destroy all the index.html* files
				unlink glob "$path/index.html*";

				@files_bef=perl::get_modules::files_scan($path);

				# slash a la fin pour http
				# system "wget -m -np -nd -q \"$ftp/$sat/$instr/$year/$month/\" -P $path/";
	
				# pas de slash a la fin pour ftp
				# system "wget -m -np -nd -q \"$ftp/$sat/$instr/$year/$month\" -P $path/";

				# wget avec cl
				#print "cl -int -batch wget,http://stereo-ssc.nascom.nasa.gov/data/telemetry/$sat/impact/$year/$month/,$path/,'',''\n";
				system "cl -int -batch wget,http://stereo-ssc.nascom.nasa.gov/data/telemetry/$sat/impact/$year/$month/,$path/,'',''";

				#  Recherche des fichiers modifies ou ajoutes et exec. du prg. de traitemment :
				my $modif;
				my $mo=0;
				@files_aft = (); # vider le tableau

				unlink glob "$path/index.html*";

				foreach $file (<$path/*>) {

					@file_infos=stat($file); # stats du fichier

					$bfile=basename($file);
					$file="$bfile $file_infos[9]";
					$bfile =~ s/_[0-9]_[0-9]{2}\..{3}$//; 

					$modif=grep(/^$file/,@files_bef);
					if ($modif ==0) { # ici
						$modif=grep(/$bfile/,@files_aft);
					}
					if ($modif == 0) {
						$files_aft[$mo]=$file;
						$mo++;
					}
				}


				foreach $file (@files_aft) {

					$file =~ s/^(.+) [0-9]+$/$1/;

					# Extract the year day :
					$yearday = $file;
					$yearday =~ s/[a-zA-Z_]+_\d+_(\d+)_[0-9a-zA-Z\._]+/$1/;

					$day=perl::time_manip::yearday_to_day($year,$month,$yearday);
					if ($file!=-1) { 
						if (($file =~ /ptp$/) || ($file =~ /fin$/)) { 
							$file="impact_${sat}_${year}_${yearday}_?_??.???";
							L1_genere($L0path,$L1path,$year,$month,$day,$sat,$file);
							# ces tracs sont devenus inutiles system "/DATA/STEREO/SOFT/UTIL/bin/WEB_STEREO $year$month$day";
						}
					}
					#  ici il faut scanner dans file_bef si $ file existe
					# s'il n'existe pas, lets go
				}
				#print "\n";
			}
		}
	}
	# fin de la grosse boucle des "foreach"
}


#-------------------------------------------------------------------------------
sub telem_get {
#-------------------------------------------------------------------------------

	my ($ftp,$L0path,$L1path)=@_;

	my @sats = ("ahead","behind");
	my @years = ("2006","2007","2008","2009","2010","2011","2012","2013","2014","2015");
	my @months = ("01","02","03","04","05","06","07","08","09","10","11","12");
	my $instr="impact";
	my $sat,$year,$month, $day, $yearday;
	my $file, $bfile;
	my @liste_atraiter; # tableau de listing fichiers a generer

	my @liste_avant; # tableau de couple (nom_fichier,date_fichier) avant le wget
	@liste_avant=perl::get_modules::files_scan("/DATA/STEREO/DATA/L0/*/*/*");	# liste_avant est un tableau de couple (nom_fichier,date_fichier)

	system "cl -int -batch wget,http://stereo-ssc.nascom.nasa.gov/data/telemetry/ahead/impact/,/DATA/STEREO/DATA/L0/ahead/,'',''";
	system "cl -int -batch wget,http://stereo-ssc.nascom.nasa.gov/data/telemetry/behind/impact/,/DATA/STEREO/DATA/L0/behind/,'',''";

	foreach $sat (@sats) {

		print "Treat STEREO $sat telem files :\n";

		foreach $year (@years) {

			foreach $month (@months) {

				$path = "$L0path/$sat/$year/$month";
				`mkdir -p $path`;	# ca ne sert a rien de tester si le repertoire existe
                
				my $modif;
				my $no=0;
				@liste_atraiter = (); # vider le tableau

				foreach $file (<$path/impact*>) {

					@file_infos=stat($file); # stats du fichier

					$bfile=basename($file);			# "impact_ahead_2008_230_1_04.fin 1259259444"
					$file="$bfile $file_infos[9]";		# file contient nom_du_fichier date_du_fichier
					$bfile =~ s/_[0-9]_[0-9]{2}\..{3}$//;	# "impact_ahead_2008_230_1_04.fin" devient "impact_ahead_2008_230"

					$modif=grep(/^$file/,@liste_avant);
					if ($modif==0) { 
						$modif=grep(/$bfile/,@liste_atraiter);
					}
					if ($modif== 0) {
						$liste_atraiter[$no]=$file;
						$no++;
					}
				}

				foreach $file (@liste_atraiter) {

					print "Traitement de $file\n";

					$file =~ s/^(.+) [0-9]+$/$1/;

					# Extract the year day :
					$yearday = $file;
					$yearday =~ s/[a-zA-Z_]+_\d+_(\d+)_[0-9a-zA-Z\._]+/$1/;

					$day=perl::time_manip::yearday_to_day($year,$month,$yearday);
					if ($file!=-1) { 
						if (($file =~ /ptp$/) || ($file =~ /fin$/)) { 
							$file="impact_${sat}_${year}_${yearday}_?_??.???";
							L1_genere($L0path,$L1path,$year,$month,$day,$sat,$file);
							#system "/DATA/STEREO/SOFT/UTIL/bin/WEB_STEREO $year$month$day";
						}
					}
				}
			}
		}
	}
}



#-------------------------------------------------------------------------------
sub l1_get {
#-------------------------------------------------------------------------------
	#
	#  Get CDF L1 data via wget and list the new data :
	#

	my ($ftp,$L1cdfpath,$L1path)=@_;

	my @sats = ("ahead","behind");
	my $sat;
	my $file, $bfile;
	my @files_bef; # tableau de listing fichiers+dates avant le wget
	my $date, $year, $month, $day;

	foreach $sat (@sats) {

		$path = "$L1cdfpath/$sat";

		if (! -d $path) { `mkdir -p $path` }

		#  old files scan
		
		# Destroy all the index.html* files
		unlink glob "$path/index.html*";

		@files_bef=perl::get_modules::files_scan($path);

		#  get the CDF files

		print "Treat STEREO $sat CDF files :\n";
		print "wget -m -np -nd --http-user=swea --http-passwd=jasauvaud $ftp/$sat -P $path";
		system "wget -m -np -nd --http-user=swea --http-passwd=jasauvaud \"$ftp/$sat/\" -P $path/ 2>\&1 | grep $path | grep saved";

		# remove index.html* files :
		unlink glob "$path/index.html*";

		#  Recherche des fichiers modifies ou ajoutes et exec. du prg. de traitemment :

		my $modif;
		my $type;

		unlink glob "$path/index.html*";

		foreach $file (<$path/*>) {

			@file_infos=stat($file); # stats du fichier

			$bfile=basename($file);
			$file="$bfile $file_infos[9]";

			$modif=grep(/^$file/,@files_bef);

			# Le fichier est nouveau ou modifie:
			if ($modif == 0) {

				$file =~ s/^(.+) [0-9]+$/$1/;
				$date = $file;

				# hashage table for cdf file type :
				my %filestab = (
					"MAG" => "magx",
					"MAGB" => "magb"
				);

				# get year, month & day from the cdf file name :
				($type, $year, $month, $day) =  $date =~ m/^[a-zA-Z1_]+_([a-zA-Z1]+)_([0-9]{4})([0-9]{2})([0-9]*)_V[0-9]+\.cdf$/;

				if ($file!=-1) { 
					if ($type =~ /MAG/) { 
						# On ne recupere pas la V03 MAG ici, on a seulement la V01 ou V02
						# On cree les fichiers binaires MAG
						# Pas la peine de creer les fichiers GSE car on va creer un fichier errone car les offsets n'ont pas ete enleves
						# cdf_treat($L1cdfpath,$L1path,$year,$month,$day,$sat,$file,$filestab{$type});
						# Mais pas la peine de faire de trace
						# system "/DATA/STEREO/SOFT/UTIL/bin/WEB_STEREO $year$month$day";
					}
				}
			}
			#  ici il faut scanner dans file_bef si $ file existe
			# s'il n'existe pas, lets go
		}
	}
	# fin de la grosse boucle des "foreach"
}

#-------------------------------------------------------------------------------
#  Main program :
#-------------------------------------------------------------------------------

	my $mainpath="/DATA/STEREO/DATA";
	my $L0path="$mainpath/L0";
	my $L1path="$mainpath/L1_CESR";
	my $L1cdfpath="$mainpath/L1_CDF";
	my $file_i;
	my $sat="ahead";
	my $year;
	my $month;
	my $day;

	# if we have to treat L0 data;
	if (($ARGV[0] =~ /^-[a-f]$/)||($ARGV[0] =~ /^-pitch$/)) {
		$year=$ARGV[1];
		$month=$ARGV[2];
		$day=$ARGV[3];

		if ($year<100) { $year = 2000 + $year }
	}

	if ($ARGV[0] eq "-t") {
		# get and treat telemetry data :
		#telem_get("http://stereo.ssl.berkeley.edu/l0data",$L0path,$L1path);
		telem_get("ftp://stereoftp.nascom.nasa.gov/pub/telemetry",$L0path,$L1path);

	} elsif ($ARGV[0] eq "-l1") {
		# get and CDF L1 data :
		my $manip=$ARGV[1];
		l1_get("http://stereo.ssl.berkeley.edu/l1unvalid",$L1cdfpath,$L1path);

	} elsif (($ARGV[0] eq "-a") || ($ARGV[0] eq "-b")) {
		# telem treatment for Stereo SWEA
		if ($ARGV[0] eq "-b") { $sat="behind"; }
		if ($file!=-1) { L1_genere($L0path,$L1path,$year,$month,$day,$sat) }

	} elsif (($ARGV[0] eq "-e") || ($ARGV[0] eq "-f")) {
		# Calibration for Stereo SWEA
		if ($ARGV[0] eq "-f") { $sat="behind"; }
		if ($file!=-1) { calibr($L0path,"./calibr/",$year,$month,"1",$sat) }

	} elsif (($ARGV[0] eq "-c") || ($ARGV[0] eq "-d")) {
		# treatment for Stereo Ahead or Behind cdf files

        	my $keyf;
	        # table de hashage contenant les fichiers a generer :
		# Les fichiers MAGB sont tous en version V01 mais pas en V03.
		# Les offsets n'ont pas ete enleves donc pas la peine de creer un fichier GSE errone.
	        #my %filestab = (
	        #       "MAG" => "magx",
	        #       "MAGB" => "magb"
	        #);
	        my %filestab = (
	               "MAG" => "magx"
	        );

		foreach $keyf ( keys %filestab ) {
			$file_i="ST?_L1_${keyf}_$year$month${day}_V00.cdf";

			if ($ARGV[0] eq "-d") { $sat="behind"; }

			if ($file!=-1) { cdf_treat($L1cdfpath,$L1path,$year,$month,$day,$sat,$file_i,$filestab{$keyf}) }
		}


	} else {
		# help
		# afficher les infos :
		printf "$PRG version $VERS\n\n";
		printf "usage:\t $PRG -ab [year] [month] [day]\n";
		printf "usage:\t $PRG -cd [year] [month] [day]\n";
		printf "usage:\t $PRG -ef [year] [month]\n";
		printf "usage:\t $PRG -l1 [manip]\n";
		printf "\t $PRG -g\n\n";
		printf "Global Parameters:\n";
		printf "\t-t\tGet L0 files\n";
		printf "\t-l1\tGet CDF L1 files. manip can be : beacon,ste,mag...\n";
		printf "\t-a\tL1 data generation for STEREO Ahead\n";
		printf "\t-b\tL1 data generation for STEREO Behind\n";
		printf "\t-c\tL1 data generation for STEREO Ahead cdf files\n";
		printf "\t-d\tL1 data generation for STEREO Behind cdf files\n";
		printf "\t-e\tcalibration for SWEA Ahead\n";
		printf "\t-f\tcalibration for SWEA Behind\n";
	}
