#!/usr/bin/env perl

use File::Basename;
use File::Copy;

use FindBin;
use lib "$FindBin::Bin/../../lib";
use perl::get_modules;

my $stprg = "$FindBin::Bin/manipgen.pl"; 

my $VERS = "1.0";
my $PRG = basename($0);

my @cal=(31,28,31,30,31,30,31,31,30,31,30,31); # number of days for each months

# ...............................................................................
#
#  find the last day of a month :
#


sub last_day {

	my ($year,$month)=@_;
	my $i;
    my @cal2 = @cal;


	# checking error in dates :
	if ($month>12 || $month<1) { printf "ERROR : month number $month doesn't exist!\n"; return -1}


    # for bisextile year :
    if ( $year%4==0 ) { $cal2[1]++ }

	return $cal2[$month-1];
}


# ........................................................................
#
#  Main program :
#

	my (@year, @month, @day, @date);
    my ($y,$m,$d,@mth,@dy);
    my @cal2=@cal;
    my $sat;

	@date = @ARGV;


	# treatment for Stereo year month and day :
	if (@ARGV == 2) {
		foreach $i qw/0 1/ {
			($year[$i], $month[$i], $day[$i]) =  $date[$i] =~ m/^([0-9]{4})([0-9]{2})([0-9]*)$/;
		}
		if (! $day[0] ) { $day[0] = "01";}
		if (! $day[1] ) { $day[1] = last_day($year[1], $month[1]);}

        # ...............................................................
        # generation for all the days between $date[0] and $date[1] :

        # years loop :
        for ($y=$year[0]; $y<=$year[1]; $y++) {

            # for bisextile year :
            @cal2[1]=@cal[1];
            if ( $y%4==0 ) { $cal2[1]++ }

            if ($year[0] == $y) { $mth[0] = $month[0]; }
            else { $mth[0] = 1; }

            if ($year[1] == $y) { $mth[1] = $month[1]; }
            else { $mth[1] = 12; }

            # months loop :
                for ($m=$mth[0]; $m<=$mth[1]; $m++) {

                    if ( ($year[0] == $y) && ($month[0] == $m) ) { $dy[0] = $day[0]; }
                    else                                         { $dy[0] = 1; }

                    if ( ($year[1] == $y) && ($month[1] == $m) ) { $dy[1] = $day[1]; }
                    else                                         { $dy[1] = @cal2[$m-1]; }

                    # days loop :
                    for ($d=$dy[0]; $d<=$dy[1]; $d++) {
                        if ( $m < 10 ) {$m =~ s/^0*/0/}
                        if ( $d < 10 ) {$d =~ s/^0*/0/}
                        foreach $sat qw/a b/ {
                            print "\t\tregen day $y $m $d for SWEA \u$sat...\n";
                            `$stprg -$sat $y $m $d`;
                        }
                        #print "\t\tregen day $y $m $d for SWEA Pitch...\n";
                        #`$stprg -pitch $y $m $d`;
                    }



                }
        }
        # ...............................................................

	# help
	} else {
		# afficher les infos :
		printf "$PRG version $VERS\n\n";
		printf "usage:\t $PRG [year0][month0][day0] [year1][month1][day1]\n";
		printf "usage:\t $PRG [year0][month0] [year1][month1]\n";
		printf "usage:\t $PRG [year0] [year1]\n";
	}

# vim: expandtab tabstop=4 shiftwidth=4
