#!/usr/bin/env perl

use File::Basename;
use File::Copy;

use FindBin;
use lib "$FindBin::Bin/../lib";
use perl::get_modules;


my $VERS = "1.0";
my $PRG = basename($0);


# ...............................................................................
#
#  find the name of the L0 telemetry file with the date :
#


sub date_to_file {

	my ($year,$month,$day,$sat)=@_;
	my $i;
	my $nb_days=$day;
	my @cal=(31,28,31,30,31,30,31,31,30,31,30,31); # number of days for each months


	# checking error in dates
	if ($day>$cal[$month-1]) { printf "ERROR : $year-$month-$day doesn't exist\n"; return -1}
	if ($month>12 || $month<1) { printf "ERROR : month number $month doesn't exist!\n"; return -1}


	# bisextil year
        if ( $year%4==0 ) { $cal[1]++ }


	for ($i=0;$i<$month-1;$i++) { $nb_days=$nb_days+$cal[$i] }
        if ( $nb_days<10 ) { $nb_days =~ s/0*([0-9])/00$1/; }
        elsif ( $nb_days<100 ) { $nb_days =~ s/0*([0-9]{2})/0$1/; }

	$file="impact_${sat}_${year}_${nb_days}_?_??.???";
	
	return $file;
}


# ...............................................................................
#
#  genere L1 files
#

sub manip_genere {

        my ($L0path,$L1path,$year,$month,$day,$sat,$file)=@_;

	my $idl = "/usr/local/rsi/idl_6.3/bin/idl"; # the path to IDL

	my $soft_path="$FindBin::Bin"; # chemin des softs SWEA
	$soft_path =~ s|bin$|idl|;
	my $solarsoft_path="/DATA/STEREO/SOFT/SOLARSOFT"; # chemin de la SOLARSOFT Lib

	my $file_i,$fil;
	my $home=`echo ~`;
	chomp($home);
    my $rand_nb = rand();
	my $idl_file="${home}/stereo$rand_nb.tmp";
	my $satt="a";
	if ( $sat eq "behind" ) { $satt="b" };

	# Output directory
	#my $out_path="$L1path/$sat/$year$month$day";
	my $out_path="$L1path/$sat";
	my $out_path= sprintf("%s/%04d%02d%02d",$out_path,$year,$month,$day);
	


	# ..............................
	# genere the binary L1 file :

	$file =~ s/\..{3}$/.fin/; # transform the end of the extention by .fin
	my @files = glob "$L0path/$sat/$year/$month/${file}";


	# if there is no *.fin files, search *.ptp files :
	if (! @files ) {
		$file =~ s/\..{3}$/.ptp/; # transform the end of the extention by .ptp
		@files = glob "$L0path/$sat/$year/$month/${file}";
	}

	if ( @files ) {
		$file_i = pop(@files);

		# file version :
		$ver = $file_i;
		$ver =~ s/.+_([0-9]{2})\..{3}$/$1/;
		
		# remove older output files :
		# my $file_o= sprintf("st%01s_l1_?????????_%04d%02d%02d_v%02d.bin",$satt,$year,$month,$day,$ver);
		foreach $fil (<$out_path/st?_l1_swea_2d*>) {
			unlink($fil);
		}
        unlink("$out_path/st?_l1_swea_pitc*");

		if ( ! -d $out_path ) { `mkdir -p $out_path` } # create the directory if unexistant

		# write temporary launch file for IDL :
		open(FILE, ">$idl_file") || die "Error : can't create $idl_file !\n";
		print FILE "pitch_treat,\'$file_i\',\'$out_path\',\'$ver\'\n";
		print FILE "flush,-1\nflush,-2\nexit, status=1";
		close(FILE);

		# IDL launch :
		$file =basename($file_i);
		printf("\tGenere $year-$month-$day $sat data from $file ...\n");
		system "export IDL_PATH=\"+$soft_path:+$solarsoft_path/:<IDL_DEFAULT>\"
		        export TIME_CONV=\"/DATA/STEREO/SOFT/SOLARSOFT/gen/data/time/\"
                $idl -32 -quiet $idl_file 2>&1 | sed {/Compiled/d}";
                #$idl -32 $idl_file";

		# remove temporary file
		unlink($idl_file);
	} else {
		print "sorry, no file $file for the $year-$month-$day :(\n";
	}

}

# ........................................................................
#
#  Main program :
#


	my $mainpath="/DATA/STEREO/DATA";
	my $L0path="$mainpath/L0";
	my $L1path="$mainpath/L1_CESR";
	my $L1cdfpath="$mainpath/L1_CDF";
	my $file_i;
	my $sat="ahead";
	my $year;
	my $month;
	my $day;

	# if we have to treat L0 data;
	if (($ARGV[0] =~ /^-[abcd]$/)||($ARGV[0] =~ /^-pitch$/)) {
		$year=$ARGV[1];
		$month=$ARGV[2];
		$day=$ARGV[3];

		if ($year<100) { $year = 2000 + $year }
	}



	# treatment for Stereo Ahead
	if ($ARGV[0] eq "-a") {
		$file_i=date_to_file($year,$month,$day,$sat);
		if ( $file!=-1 ) { manip_genere($L0path,$L1path,$year,$month,$day,$sat,$file_i) }

	# treatment for Stereo Behind
	} elsif ($ARGV[0] eq "-b") {
		$sat="behind";
		$file_i=date_to_file($year,$month,$day,$sat);
		if ( $file!=-1 ) { manip_genere($L0path,$L1path,$year,$month,$day,$sat,$file_i) }

	# help
	} else {
		# afficher les infos :
		printf "$PRG version $VERS\n\n";
		printf "usage:\t $PRG -ab [year] [month] [day]\n";
		printf "Global Parameters:\n";
		printf "\t-t\tGet L0 files\n";
		printf "\t-a\tL1 data generation for STEREO Ahead\n";
		printf "\t-b\tL1 data generation for STEREO Behind\n";
	}
