#!/usr/bin/env perl

use File::Basename;
use File::Copy;

use FindBin;
use lib "$FindBin::Bin/../../lib";
use perl::get_modules;
use perl::stereo_path;



my $VERS = "1.0";
my $PRG = basename($0);


# ...............................................................................
#
#  Treatment for CDF files
#

sub cdf_treat {

    my ($L0path,$L1path,$year,$month,$day,$sat,$file)=@_;

	my $idl = "/usr/local/rsi/idl_6.3/bin/idl"; # the path to IDL

	my $soft_path="$FindBin::Bin"; # chemin des softs SWEA
	$soft_path =~ s|bin$||;
	my $solarsoft_path="/DATA/STEREO/SOFT/SOLARSOFT"; # chemin de la SOLARSOFT Lib
	my $cl_path="/DATA/CLUSTER/SOFT/CLL3/pro"; # chemin des soft CL pour traiter les fichiers CDF

	my $file_i,$fil;
	my $home=`echo ~`;
	chomp($home);
    my $rand_nb = rand();
	my $idl_file="${home}/stereo$rand_nb.tmp";

	# Output directory


	# ..............................
	# genere the binary L1 file :

	my $file_i = "$L0path/$sat/${file}";



	# write temporary launch file for IDL :
	open(FILE, ">$idl_file") || die "Error : can't create $idl_file !\n";
	print FILE "PREF_SET, \'IDL_DLM_PATH\', \'/DATA/STEREO/SOFT/SWEA_DECOM/lib/:<IDL_DEFAULT>\', /COMMIT\n";
	print FILE ".run cdf_file\n";
	print FILE ".run temps\n";
	print FILE "debug_mag_gse,\'$file_i\',\'$ver\',\'$day\',\'$sat\'\n";
	print FILE "flush,-1\nflush,-2\nexit, status=1";
	close(FILE);

	# IDL launch :
	my $full_export=perl::stereo_path::get_idl_path($soft_path,$solarsoft_path);
	$file =basename($file_i);
	printf("\tGenere $year-$month $sat data from $file ...\n");
	system "$full_export
       $idl -32 -quiet $idl_file 2>&1 | sed {/Compiled/d}";

	# remove temporary file
	unlink($idl_file);

}

# ........................................................................
#
#  Main program :
#


	my $mainpath="/DATA/STEREO/DATA";
	my $L0path="$mainpath/L0";
	my $L1path="$mainpath/L1_CESR";
	my $L1cdfpath="$mainpath/L1_CDF";
	my $file_i;
	my $sat="ahead";
	my $year;
	my $month;
	my $day;
	my $satt="A";

	# if we have to treat L0 data;
	if ($ARGV[0] =~ /^-[abcd]$/) {
		$year=$ARGV[1];
		$month=$ARGV[2];

		if ($year<100) { $year = 2000 + $year }
	}


	# treatment for Stereo Ahead or Behind cdf files
	if ( ($ARGV[0] eq "-c") || ($ARGV[0] eq "-d") ) {

	if ( $ARGV[0] eq "-d" ) { $sat="behind"; $satt="B" };

	unlink("./mag.plt");
        my $keyf;
        # table de hashage contenant les fichiers a generer :


	$file_i="ST${satt}_L1_MAG_$year$month";


	if ( $file!=-1 ) { cdf_treat($L1cdfpath,$L1path,$year,$month,$day,$sat,$file_i) }


	# help
	} else {
		# afficher les infos :
		printf "$PRG version $VERS\n\n";
		printf "usage:\t $PRG -cd [year] [month]\n";
		printf "\t $PRG -g\n\n";
		printf "Global Parameters:\n";
		printf "\t-c\tL1 data generation for STEREO Ahead cdf files\n";
		printf "\t-d\tL1 data generation for STEREO Behind cdf files\n";
	}
