;+
; Project     :	STEREO - SSC
;
; Name        :	ORB_ATT
;
; Purpose     :	Prints out STEREO orbital information
;
; Category    :	STEREO, Orbit
;
; Explanation :	This routine prints out "quick-look" information about the
;               positions of the two STEREO spacecraft, together with similar
;               information about Earth's position.  The information is
;               arranged by viewpoint, with the Behind spacecraft on the left,
;               the Ahead spacecraft on the right, and Earth in between.
;
;               This also serves as a good example of how the various
;               GET_STEREO_* routines work.
;
; Syntax      :	STEREO_COORD_INFO  [, DATE ]
;
; Examples    :	STEREO_COORD_INFO, '2006-05-06T11:30:00'
;
; Inputs      :	None required.
;
; Opt. Inputs :	DATE = The date and time.  This can be input in any format
;                      accepted by ANYTIM2UTC.  The default is the current
;                      date/time.
;
; Outputs     :	Information about the positions and attitude of the two STEREO
;               spacecraft are written to the screen.
;
; Opt. Outputs:	None.
;
; Keywords    : FILENAME = The name of a file to write the output to.  The
;                          default is to write to the terminal.
; Keywords    : SAT = The name of the satellite 'ahead" or 'behind'
;
;               Will also accept any LOAD_STEREO_SPICE or ANYTIM2UTC keywords.
;
; Calls       :	GET_STEREO_LONLAT, GET_STEREO_SEP_ANGLE, GET_STEREO_CARR_ROT,
;               LOAD_STEREO_SPICE
;
; Common      :	None.
;
;
;
;
; Contact     :	Pene@cesr.fr
;-

pro orb_att, date, sat, filename=filename, _extra=_extra

	utc2 = anytim2utc(date,/external)

	; get the packet date :
	if ((utc2.day lt 10) and (utc2.month lt 10)) then datestr = string(utc2.year,utc2.month,utc2.day,'(I4,"0",I1,"0",I1)') $
	else if ((utc2.day lt 10) and (utc2.month ge 10)) then datestr=string(utc2.year,utc2.month,utc2.day,'(I4,I2,"0",I1)') $
	else if ((utc2.day ge 10) and (utc2.month lt 10)) then datestr=string(utc2.year,utc2.month,utc2.day,'(I4,"0",I1,I2)') $
	else datestr=string(utc2.year,utc2.month,utc2.day,'(I4,I2,I2)')

	SCSTRING = sat eq 'ahead' ? '/DATA/STEREO/DATA/ORB/ahead/sta' : '/DATA/STEREO/DATA/ORB/behind/stb'

	;version = '01'
	file_orb = SCSTRING+'_stereo_orb_'+datestr+'_v01.bin.new'
	file_att = SCSTRING+'_stereo_att_'+datestr+'_v01.asc.new'
	file_rtn = SCSTRING+'_stereo_rtn_'+datestr+'_v01.asc.new'

	print,"    ",sat," orbit..."
	orb, date, sat, file_orb, _extra=_extra

	print,"    ",sat," attitude..."
	att, date, sat, file_att, _extra=_extra

	print,"    ",sat," rtn..."
	rtn, date, sat, file_rtn, _extra=_extra

end
