#!/usr/bin/env perl



use File::Basename;
use File::Copy;

use FindBin;
use lib "$FindBin::Bin/../../lib";
use perl::stereo_path;



my $VERS = "1.0";
my $PRG = basename($0);
# ---------------------------------------------------------------------------------
#
# get sswdb files :
#

sub sswdb {
	my $idlver =6.3;
	my $idl = "/usr/local/rsi/idl_$idlver/bin/idl"; # the path to IDL

	my $softpath="$FindBin::Bin"; # chemin des softs SWEA
	$softpath =~ s|bin$|idl|;
	my $solarsoft_path="/DATA/STEREO/SOFT/SOLARSOFT"; # chemin de la SOLARSOFT Lib

	my $home=`echo ~`;
    	chomp($home);
    	my $idl_file="${home}/stereo.tmp";


    	# write temporary launch file for IDL :
	open(FILE, ">$idl_file") || die "Error : can't create $idl_file !\n";
	print FILE "sswdb_b11_upgrade,\/spawn, \/loud, \/passive_ftp\n";
	print FILE "flush,-1\nflush,-2\nexit, status=1";
	close(FILE);

	# IDL launch :
	system "export IDL_PATH=\"+$softpath:+$solarsoft_path/:<IDL_DEFAULT>:\" 
		export SSW=\"/DATA/STEREO/SOFT/SOLARSOFT\"
		export SSW_SITE_SETUP=\"\$SSW/site/setup\"
		export SSWDB=\"/DATA/STEREO/DATA/SSWDB\"
		export SSW_GEN_SETUP=\"\$SSW/gen/setup\"
		$idl -32 -quiet $idl_file 2>&1 | sed {/Compiled/d}";

	# remove temporary file
	unlink($idl_file);

}

# ---------------------------------------------------------------------------------
#
# Orbite and attitude for a specific date :
#

sub orb_att {

	my ($outpath,$year,$month,$day,$sat)=@_;

	my $idlver =6.3;
	my $idl = "/usr/local/rsi/idl_$idlver/bin/idl"; # the path to IDL

	my $softpath="$FindBin::Bin"; # chemin des softs SWEA
	$softpath =~ s|bin$|idl|;
	my $solarsoft_path="/DATA/STEREO/SOFT/SOLARSOFT"; # chemin de la SOLARSOFT Lib

	my $home=`echo ~`;
	chomp($home);
	my $idl_file="${home}/stereo.tmp";

	# write temporary launch file for IDL :
	open(FILE, ">$idl_file") || die "Error : can't create $idl_file !\n";
	print FILE "orb_att, '$year-$month-${day}', '$sat'\n";
	print FILE "flush,-1\nflush,-2\nexit, status=1";
	close(FILE);

	# IDL launch :
	my $full_export=perl::stereo_path::get_idl_path($softpath,$solarsoft_path);
	print "$full_export
		$idl -32 -quiet $idl_file 2>&1 | sed {/Compiled/d}";
	#system "$full_export
		#$idl -32 -quiet $idl_file 2>&1 | sed {/Compiled/d}";

	# remove temporary file
	#unlink($idl_file);
	#print "st${sat}_stereo_???_$year$month${day}_v0?.???\n";

}


# ---------------------------------------------------------------------------------
#
# Main part :
#

	my $outpath="/DATA/giant/coucou";
	my $sat="ahead";
	my ($year, $month, $day);

	if (@ARGV == 2) {
		($year, $month, $day) =  $ARGV[1] =~ m/^([0-9]{4})([0-9]{2})([0-9]*)$/;
	}

	if ($ARGV[0] eq "-g") {
		sswdb;

	} elsif ($ARGV[0] eq "-a") {
    		# orbites and attitude for Stereo Ahead
		orb_att($outpath,$year,$month,$day,$sat);

	} elsif ($ARGV[0] eq "-b") {
		# orbites and attitude for Stereo Behind
		$sat="behind";
		orb_att($outpath,$year,$month,$day,$sat);

	} else {
		# afficher les infos :
		printf "$PRG version $VERS\n\n";
		printf "usage:\t $PRG -ab [year][month][day]\n";
		printf "Global Parameters:\n";
		printf "\t-a\torbit generation for STEREO Ahead\n";
		printf "\t-b\torbit generation for STEREO Behind\n";
	}
