;-------------------------------------------------------------------------------
PRO treat_file, filename_cdf, filename_hk_cdf, filename_txt
;-------------------------------------------------------------------------------

	nom = basename(filename_cdf)
	annee = STRMID(nom,11,4)
	mois = STRMID(nom,15,2)
	jour = STRMID(nom,17,2)
	SC = STRMID(nom,2,1)

	variable = 'ra_trig_full' ; variable a lire par dfaut

	; mais seulement  partir d'une certaine date (qui dpend du satellite):
	;	- pour STA: 2007DOY044: 31=31janvier 32=1er fvrier 42=11 fvrier 44=13 fvrier
	;	- pour STB: ? On prend20070210
	
	IF SC EQ 'A' THEN date = tu_to_date (2007,02,13,0,0,0) ; ok vrifi avec cdfedit (avec des -1 au dbut du fichier)
	IF SC EQ 'B' THEN date = tu_to_date (2007,03,01,0,0,0) ; ok vrifi avec cdfedit
	
	id=cdf_open(filename_cdf)
	lire_var_cdf, id,'epoch1',epoch1,err,type
	lire_var_cdf, id,'error1',error1,err,type
	lire_var_cdf, id,'s_chan1',s_chan1,err,type
	lire_var_cdf, id,'ra_trig_full',ra_trig_full,err,type
	lire_var_cdf, id,'sf0_full',sf0_full,err,type
	IF tu_to_date(annee,mois,jour,0,0,0) LT date THEN BEGIN
		ra_trig_full = sf0_full ; utiliser 'sf0_full' avant la date ci-dessus
	END ELSE IF tu_to_date(annee,mois,jour,0,0,0) EQ date THEN BEGIN
		; utiliser sf0_full la ou ra_trig_fill vaut -1
		ind = where(ra_trig_full[*,65,0] eq -1)
		IF ind[0] NE -1 THEN BEGIN
			ra_trig_full[ind,*,*] = sf0_full[ind,*,*]
		END
	END
	cdf_close,id

	id=cdf_open(filename_hk_cdf)
	lire_var_cdf, id,'epoch_analog',epoch_analog,err,type
	lire_var_cdf, id,'esa_cm_dc_eng',esa_cm_dc_eng,err,type
	cdf_close,id

	data = ra_trig_full[*,64+INDGEN(64),*]
	CDF_EPOCH, decalage, 1958, 1, 1, 0, 0, 0, /compute_epoch
	date = epoch1 - decalage

	; pb sur /DATA/STEREO/DATA/PLASTIC/L1/ahead/2009/STA_L1_PLA_20090429_119_V09.cdf: error1[1281] et epoch1[1280]
	IF N_ELEMENTS(error1) GT N_ELEMENTS(epoch1) THEN error1=error1[0:N_ELEMENTS(epoch1)-1]

	; pb sur /DATA/STEREO/DATA/PLASTIC/L1/behind/2009/STB_L1_PLA_20090128_028_V09.cdf: error1[1391], epoch1[1391], data[1126,64,32]
	nbdata = N_ELEMENTS(data[*,0,0])
	IF N_ELEMENTS(error1) GT nbdata THEN error1=error1[0:nbdata-1]
	IF N_ELEMENTS(epoch1) GT nbdata THEN epoch1=epoch1[0:nbdata-1]

	ind = WHERE (error1 EQ 0)
	IF ind[0] NE -1 THEN BEGIN
		OPENW,fd,filename_txt,/GET_LUN,WIDTH=100000L
		FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN

			ind_hk = WHERE (epoch_analog EQ epoch1[ind[i]])
			IF ind_hk[0] NE -1 THEN BEGIN
				IF esa_cm_dc_eng[ind_hk[0]] LE 50 THEN CONTINUE	; supprimer les donnes si esa_cm_dc_eng est <= 50
			END
			s=date_to_str(date[ind[i]],format=4)+' '+val_to_str(s_chan1[ind[i]])
			PRINTF, fd, s, REFORM(STRCOMPRESS(STRING(REVERSE(data[ind[i],*,*])),/REMOVE_ALL),64*32)

			; version lente avec des boucles
			;FOR j=0,31 DO BEGIN
			;	FOR k=0,63 DO BEGIN
			;		s=s+' '+val_to_str(data[ind[i],k,j])
			;	END
			;END
			;PRINTF,fd,s
		END
		FREE_LUN,fd
	END


	; Re-lecture du fichier ascii
	IF 1 EQ 0 THEN BEGIN
	annee=0
	mois=0
	jour=0
	heure=0
	minute=0
	seconde=0.0
	s_chan1=0
	data=REPLICATE(0L,64,32)
	OPENR,fd,filename_txt,/GET_LUN
	WHILE NOT EOF(fd) DO BEGIN
		READF,fd,annee,mois,jour,heure,minute,seconde,s_chan1,data
		print,annee,mois,jour,heure,minute,seconde
	END
	FREE_LUN,fd
	END

END


;-------------------------------------------------------------------------------
PRO treat_files, files_cdf, directory_txt
;-------------------------------------------------------------------------------

	ls = my_findfile (files_cdf)

	FOR i=0L,N_ELEMENTS(ls)-1 DO BEGIN

		filename = basename(ls[i])
		filename = STRMID(filename,0,STRLEN(filename)-4)

		filename_cdf = ls[i]
		filename_hk_cdf = dirname(ls[i])+'/'+STRMID(filename,0,11)+'HK_'+STRMID(filename,11,STRLEN(filename_cdf)-11)+'.cdf'
		filename_txt = directory_txt + '/' + filename+'.txt'

		PRINT,filename_cdf+' + '+filename_hk_cdf
		PRINT,'-> '+filename_txt
		treat_file, filename_cdf, filename_hk_cdf, filename_txt

	END

END


;-------------------------------------------------------------------------------
PRO treat_plastic_l1
;-------------------------------------------------------------------------------

	; Traitement de tous les fichiers de l'annee 2011 pour Ahead et behind
	FOR i=0,1 DO BEGIN
		annee='2011'
		annee='2007'
		sat = i EQ 0 ? 'ahead' : 'behind'
		filtre = 'ST'+(i EQ 0 ? 'A' : 'B')+'_L1_PLA_'+annee+'*.cdf'
		filtre = 'ST'+(i EQ 0 ? 'A' : 'B')+'_L1_PLA_'+annee+'0204*.cdf'
		treat_files, '/DATA/STEREO/DATA/PLASTIC/L1/'+sat+'/'+annee+'/'+filtre, '/DATA/STEREO/DATA/PLASTIC/L1ascii/'+sat+'/'+annee
	END

END
