FUNCTION fichiers_idem_idl, f1, f2

	info1 = FILE_INFO (f1)
	info2 = FILE_INFO (f2)

	IF info1.exists THEN BEGIN
		IF info2.exists THEN BEGIN
			; les 2 fichiers existent
			IF info1.size NE info2.size THEN RETURN, 0 ; pas la même taille
			IF info1.size EQ 0 THEN RETURN, 1 ; tous les 2 taille nulle
			OPENR, fd, f1, /GET_LUN
			tab1 = REPLICATE (0b, info1.size)
			READU, fd, tab1
			FREE_LUN, fd
			OPENR, fd, f2, /GET_LUN
			tab2 = REPLICATE (0b, info2.size)
			READU, fd, tab2
			FREE_LUN, fd
			RETURN, tableaux_idem(tab1,tab2)
		END ELSE BEGIN
			; f1 existe mais f2 n'existe pas
			RETURN, 0
		END
	END ELSE BEGIN
		IF info2.exists THEN BEGIN
			; f1 n'existe pas mais f2 existe
			RETURN, 0
		END ELSE BEGIN
			; les 2 fichiers n'existent pas
			RETURN, 1
		END
	END

END

PRO traiter_fichiers, fichier, fichier_new

	PRINT,fichier,' ',fichier_new
	cmd = 'ls -la ' + fichier + ' ' + fichier_new
	SPAWN,cmd

	IF fichiers_idem_idl (fichier, fichier_new) THEN BEGIN
		PRINT,'IDEM ', fichier
		; suppimer fichier_new
		FILE_DELETE, fichier_new, /ALLOW_NONEXISTENT
	END ELSE BEGIN
		PRINT,'MODIF ', fichier
		; déplacer fichier_new dans fichier uniquement si fichier_new existe et qu'il n'est pas vide
		info = FILE_INFO (fichier_new)
		IF info.exists AND info.size NE 0 THEN BEGIN
			; supprimer fichier
			FILE_DELETE, fichier, /ALLOW_NONEXISTENT
			FILE_MOVE, fichier_new, fichier
		END
	END

END


PRO ephemeris, YYYYMMDD, nomsat, YYYY_MM_DD, ab, option

	masque_orb = '/DATA/STEREO/DATA/ORB/'+nomsat+'/*orb*'+YYYYMMDD+'*'
	output_orb = my_findfile (masque_orb)
	file = '/DATA/STEREO/DATA/ORB/'+nomsat+'/st'+ab+'_stereo_orb_'+YYYYMMDD+'_v01.bin'

	IF option EQ 1 OR FILE_TEST(file,/REGULAR) EQ 0 THEN BEGIN
		PRINT,'orb ' + YYYY_MM_DD + ' ' + nomsat
		orb, YYYY_MM_DD, nomsat, file+'.new'
		traiter_fichiers,file,file+'.new'
	END

	masque_att = '/DATA/STEREO/DATA/ORB/'+nomsat+'/*att*'+YYYYMMDD+'*'
	output_att = my_findfile (masque_att)
	file = '/DATA/STEREO/DATA/ORB/'+nomsat+'/st'+ab+'_stereo_att_'+YYYYMMDD+'_v01.asc'
	IF option EQ 1 OR FILE_TEST(file,/REGULAR) EQ 0 THEN BEGIN
		PRINT,'att ' + YYYY_MM_DD + ' ' + nomsat
		att, YYYY_MM_DD, nomsat, file+'.new'
		traiter_fichiers,file,file+'.new'
	END

	masque_rtn = '/DATA/STEREO/DATA/ORB/'+nomsat+'/*rtn*'+YYYYMMDD+'*'
	output_rtn = my_findfile (masque_rtn)
	file = '/DATA/STEREO/DATA/ORB/'+nomsat+'/st'+ab+'_stereo_rtn_'+YYYYMMDD+'_v01.asc'
	IF option EQ 1 OR FILE_TEST(file,/REGULAR) EQ 0 THEN BEGIN
		PRINT,'rtn ' + YYYY_MM_DD + ' ' + nomsat
		rtn, YYYY_MM_DD, nomsat, file+'.new'
		traiter_fichiers,file,file+'.new'
	END

END


PRO stereo_traiter, option

	; option=0: traitement classique
	; option=1; retraitement de toutes les données EPHEMERIS

	date1 = tu_to_date (2006,10,12,0,0,0)
	date2 = get_date()

	nomsats = ['ahead','behind']
	abs = ['a','b']

	FOR date=date1,date2,86400*1000d DO BEGIN

		date_to_tu, date, annee, mois, jour, heure, minute, seconde
		doy = year_month_day_to_doy (annee, mois, jour)

		YYYYMMDD = val_to_str(annee)+int_str_0(mois,2)+int_str_0(jour,2)
		YYYY_MM_DD = val_to_str(annee)+'-'+int_str_0(mois,2)+'-'+int_str_0(jour,2)

		FOR nosat=0,1 DO BEGIN

			nomsat = nomsats[nosat]
			ab = abs[nosat]

			; Données ephemeris
			; ------------------
			IF option EQ 1 THEN BEGIN

				; Pour créer systématiquement les données ephemeris
				ephemeris, YYYYMMDD, nomsat, YYYY_MM_DD, ab, option
				CONTINUE

			END


			; Données L1_CESR + ephemeris
			; ---------------------------

                        ; fichier niveau 0: prendre le dernier ".fin" s'il existe et qu'il n'est pas vide, sinon prendre le dernier ".ptp"
			masque = '/DATA/STEREO/DATA/L0/'+nomsat+'/'+val_to_str(annee)+'/'+int_str_0(mois,2)+'/impact_'+nomsat+'_'+val_to_str(annee)+'_'+int_str_0(doy,3)+'_?_??'

			input = my_findfile (masque+".fin")
			IF input[0] NE '' THEN BEGIN
				input = input[N_ELEMENTS(input)-1] ; dernier fichier
				tmp = FILE_INFO (input)
				taille = tmp.size
				IF taille EQ 0 THEN input = ''
			END

			IF input[0] EQ '' THEN BEGIN
				input = my_findfile (masque+".ptp")
				input = input[N_ELEMENTS(input)-1] ; dernier fichier
			END
			input = input[0]
			IF input EQ '' THEN CONTINUE
			info_input = FILE_INFO (input)

			retraiter = 0


			out_path = '/DATA/STEREO/DATA/L1_CESR/' + nomsat + '/' + YYYYMMDD
			masque = out_path + '/*'
			output = my_findfile (masque)
			IF output[0] EQ '' THEN BEGIN
				retraiter = 1
			END ELSE BEGIN
				FOR i=0,N_ELEMENTS(output)-1 DO BEGIN
					info_output = FILE_INFO (output[i])
					IF info_output.mtime LT info_input.mtime THEN retraiter=1
				END
			END
			IF retraiter EQ 1 THEN BEGIN

				PRINT,YYYYMMDD + ' ' + nomsat + ' ' + input + ' retraiter='+val_to_str(retraiter)

				infile = input
				version = STRMID(infile,STRLEN(infile)-6,2)

				; Création répertoire out_path
				mkdir_p, out_path

				; supprimer les fichiers output
				FOR i=0,N_ELEMENTS(output)-1 DO BEGIN
					IF output[i] NE '' THEN FILE_DELETE,  output[i], /ALLOW_NONEXISTENT
				END

				nom_dist = out_path + '/st' + ab + '_l1_swea_dist_' + YYYYMMDD + '_v' + version + '.bin'
				nom_disb = out_path + '/st' + ab + '_l1_swea_disb_' + YYYYMMDD + '_v' + version + '.bin'

				swea_l1_cesr, infile, out_path, version, nom_dist, nom_disb

				output = my_findfile (masque)
				PRINT,'  output = ', output[0]
				FOR i=1,N_ELEMENTS(output)-1 DO PRINT,'           ' + output[i]
				PRINT

				ephemeris, YYYYMMDD, nomsat, YYYY_MM_DD, ab, option

			END

		END

	END

	exit

END
