PRO stereo_check_cef

	types = [ 'MOM', 'PAD' ]
	sats = [ 'ahead', 'behind' ]
	vers = [ 'V05', 'V04' ]

	FOR itype=0L,N_ELEMENTS(types)-1 DO BEGIN

		FOR isat=0L,N_ELEMENTS(sats)-1 DO BEGIN

			liste = my_findfile ('/DATA/STEREO/DATA/CEF/' + types[itype] + '/' + sats[isat] + '/*_'+vers[itype]+'.cef.gz')

			FOR iliste=0L,N_ELEMENTS(liste)-1 DO BEGIN

				IF liste[iliste] EQ '' THEN CONTINUE

				code = read_cef (liste[iliste], data, /quiet)
				IF code EQ 1 THEN BEGIN
					nb = N_ELEMENTS(data)
					IF nb GE 2 THEN BEGIN
						delta = data[1:nb-1].epoch - data[0:nb-2].epoch
						ind = WHERE (delta LT 0)
						IF ind[0] NE -1 THEN BEGIN
							PRINT, liste[iliste] + ' AIE delta'
							STOP
						END
						delta_moy_sec = MOYEN (delta) / 1000d
					
					END
				END ELSE BEGIN
					code = 0
					nb = 0
					delta_moy_sec = 0.
				END

				PRINT, liste[iliste], code, nb, delta_moy_sec

			END

		END

	END


END
