#!/bin/sh


YEAR_NOW=`date +%Y`
for annee in 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 2016 2017 2018 2019 2020 2021 2022 2023 2024 2025 2026 2027 2028 2029; do

	if [ $annee -gt $YEAR_NOW ]; then
		break;
	fi

	for mois in 01 02 03 04 05 06 07 08 09 10 11 12; do

		for jour in 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31; do

			for sat in ahead behind; do

				for fichier1 in `ls /DATA/STEREO/DATA/l1data/$sat/mag/SC/$annee/$mois/ST?_L1_MAG_SC_"$annee""$mois""$jour"_V??.cdf 2> /dev/null | tail -1`; do

					VERSION=`echo $fichier1 | awk -F'/' '{print substr($11,24,3)}'`
					fichier2=`ls /DATA/STEREO/DATA/CEF/MAG/$sat/*MAG1MN_"$annee""$mois""$jour"_$VERSION.cef 2> /dev/null`
					retraiter="0"
					if [ -z $fichier2 ]; then
						retraiter="1"
						#echo "traiter..."
					else
						if [ $fichier2 -ot $fichier1 ]; then
							retraiter="1"
							#echo "retraiter..."
						fi
					fi
					if [ $retraiter == "1" ]; then
						echo TRAITEMENT cl -int -batch stereo_mag_cdf2cef,$fichier1
						cl -D -int -batch stereo_mag_cdf2cef,$fichier1
					fi

				done
			
			done

		done

	done

done
