c	program 'Green'
C 
C   PROGRAM TO GENERATE NORTHCLIFFE-SCHILLING TABLES OF TOTAL RANGE 
C   AND ELECTRONIC STOPPING VERSUS ENERGY FOR ANY ION PROJECTILE IN 
C   ANY SOLID TARGET MATERIAL. ABOVE 12 MEV/NUC THE BARKAS AND BERGER 
C   VERSION OF THE BETHE-BLOCH FORMULA IS USED.  AT 11 AND 12 MEV/NUC 
C   THE N-S AND B&B STOPPING VALUES ARE AVERAGED TO SMOOTH THE
C   TRANSITION.  SOMETIMES IT STILL IS NOT VERY SMOOTH. 
C 
C   PROGRAM PRODUCES PRINTOUT AND A DISC FILE WHICH IS TO BE USED 
C   BY PROGRAMS ELOSS AND VEDEP 
C 
C 
C   AUTHOR: D. ANGLIN 
C   MODIFIED FOR HP 21MX BY D. HAMILTON (11-13-78)
c	modified for VMS 5/97 /gm
C 
C 
C   INPUT DISC FILE FORMAT: 
C 
C   1. NAMT (4A2) - NAME OF TARGET MATERIAL 
C 
C   2. IADJ,M2,IZ2 (*)
C 
C      IADJ - ADJUSTED IONIZATION VALUE FOR TARGET MATERIAL IN EV 
C             (SEE BARKAS AND BERGER) 
C 
C      M2   - ATOMIC WEIGHT OF TARGET (USE EARTH ABUNDANCES FROM CRC
C                                      HANDBOOK) (REAL VALUE) 
C 
C      IZ2  - ATOMIC NUMBER OF TARGET 
C 
C   3. RSTOP (*) - 13 CONVERSION VALUES FROM TABULATED DE/DX(ELEC) FOR
C                  ALUMINUM IN NORTHCLIFFE AND SCHILLING TO TARGET
C                  NAMT (SEE FIG. 7 OF N&S). VALUES ARE AT ENERGIES 
C                  .0125,.025,.08,.125,.2,.32,.6,1.,1.6,2.5,4.,6.,12. 
C                  MEV/A
C 
C   4. NAMP (4A2) - NAME OF INCIDENT PARTICLE 
C 
C   5. M1,IZ1 (*) - ATOMIC WEIGHT (REAL) AND ATOMIC NUMBER OF PROJECTILE
C 
C   6. ALSTOP (*) - 13 VALUES OF DE/DX (ELEC) FOR PROJECTILE IN ALUMINUM
C                   AT ENERGIES GIVEN IN 3) ABOVE 
C 
C 
C    NOTE: RECORDS 4-6 MAY BE REPEATED FOR DIFFERENT PROJECTILES IN THE 
C          SAME TARGET. END JOB WITH A BLANK RECORD.
C 
C 
C   MODIFICATION HISTORY :
C 
C   9-6-79   FOUND ANGLIN'S FIT TO DELTA R (SEE PG 245 OF N-S) GIVES
C            WRONG RESULTS FOR LIGHT PROJECTILES ON HEAVY TARGETS 
C            (I.E. FOR K.GT.1.6).   REPLACED ANGLIN'S PARABOLIC FIT WITH
C            WITH A TWO PIECE PARABOLIC FIT.
C 
C  9-2-80   FOUND THE ORIGINAL FORMULA FOR THE EFFECTIVE CHARGE 
C           FROM N-S TO GO NEGATIVE FOR LARGE Z.SO THE FORMULA
C           FOR EFFECTIVE CHARGE IS REPLACED BY THE FORMULA OF
C           OF ZEIGLER FOR Z > 26. THIS PREVENTS THE BREAKDOWN
C           THAT OCCURED BEFORE. (REVISION BY D.C. BROWN) 
C 
C  7-28-82  FOUND THAT WHEN THE ZEFF FORMULA WAS CHANGED ON 9-2-80, THE 
C           WRONG N-S FORMULA (Z1**-(2/3) TERM) WAS USED BELOW Z1=27. 
C           REPLACED IT WITH THE CORRECT N-S FORMULA (1/Z1 TERM)
C 
C   7-28-82  CHANGED PGM TO WRITE TOTAL RANGE AND ELECTRONIC STOPPING 
C            TO DISC OUTPUT FILE RATHER THAN TOAL RANGE AND ELECTRONIC
C            RANGE
C 
c	5/9/97	modify for Vax VMS fortran /gm
C 
      REAL IADJ,M1,M2 
C 
      LOGICAL RETRN 
C 
      DIMENSION E(13),RSTOP(13),EGRID(108),DLEG(38) 
      DIMENSION DEDX(3,38),STOP(108),RTOT(108),RELEC(108),TEG(108)
      DIMENSION AE(108),AK(108),AKBAR(108),S(108),S1(108) 
      DIMENSION LU(5),NAMT(4),NAMP(4) 
      DIMENSION NAMOUT(3)
	byte datew(9),timew(8)
	character*80 dsnout
C 
      EQUIVALENCE (DEDX(1),STOP(1)) 
      EQUIVALENCE (LU(1),LU1),(LU(2),LU2),(LU(3),LU3) 
	character*80 dsn
C 
      COMMON IADJ,M1,Z1,M2,Z2,RETRN 
      COMMON ALSTOP(13),DLE(13),WORK(78),NE,LU1 
C 
      DATA E/.0125,.025,.08,.125,.2,.32,.6,1.0,1.6,2.5,4.,6.,12./ 
      DATA EGRID/.0125,.016,.02,.025,.032,.04,.05,.06,.07,.08,.09,.1, 
     1           .125,.16,.2,.25,.32,.4,.5,.6,.7,.8,.9,1.,1.25,1.6,2.,
     2 2.5,3.2,4.,5.,6.,7.,8.,9.,10.,11.,12.,14.,16.,18.,20.,22.,24., 
     3 26.,28.,30.,35.,40.,45.,50.,55.,60.,65.,70.,75.,80.,85.,90.,95., 
     4 100.,110.,120.,130.,140.,150.,160.,170.,180.,190.,200.,220.,240.,
     5 260.,280.,300.,350.,400.,450.,500.,550.,600.,650.,700.,750.,800.,
     6 850.,900.,950.,1000.,1100.,1200.,1300.,1400.,1500.,1600.,1700.,
     7 1800.,2000.,2200.,2400.,2600.,2800.,3000.,3500.,4000.,4500., 
     8 5000./ 
C 
	data lu1/5/,lu2/6/

	call time(timew)
	call date(datew)

      NE = 13 
      DO 5 I=1,13 
    5 DLE(I) = ALOG(E(I)) 
      DO 10 I=1,38
   10 DLEG(I) = ALOG(EGRID(I))
C 
C   READ IN NAME OF INPUT FILE
C 
C 
C   OPEN INPUT FILE 
C 
	write(5,1555)
1555	format(' Enter name of input file: '$)
	read(5,1556) dsn
1556	format(a80)

	open(unit=10,name=dsn,type='old')
C 
C   READ INPUT DATA 
C 
      READ(10,210) NAMT
210   FORMAT(4A2) 
      READ(10,*) IADJ,M2,IZ2 
      Z2 = IZ2
      READ(10,*) RSTOP 
C 
C   BEGIN LOOP FOR DIFFERENT PROJECTILES
C 
20	READ(10,210,end=1200) NAMP
      IF (NAMP(1).EQ.2H  ) GO TO 1200 
      READ(10,*,end=1200) M1,IZ1
      Z1 = IZ1
      READ(10,*,end=1200) ALSTOP
      DO 30 I=1,13
   30 ALSTOP(I) = ALOG(RSTOP(I)*ALSTOP(I))
C 
C   OPEN OUTPUT FILE
C 
      WRITE(LU1,200) namp
200   FORMAT(' Enter name of output file for projectile '4a2)
	read(5,201,end=1200) dsnout
201	format(a80)
	open(unit=11,name=dsnout,type='new')
C 
C   CALL CUBIC SPLINE SUBROUTINE TO CALCULATE ELECTRONIC DE/DX AT THE 
C   38 E/A VALUES FROM .0125 TO 12.0 MEV/NUC USED IN NORTHCLIFFE- 
C   SCHILLING TABLES. ROUTINE RETURNS LN(DE DX) AT THE FIRST 38 VALUES
C   OF EGRID(108) IN THE ARRAY DEDX(1,1),DEDX(1,2),....DEDX(1,38).
C 
      CALL ICS1V(ALSTOP,DLE,NE,38,DLEG,WORK,DEDX,IER,LU1,LU2) 
C 
C   CALCULATE FIRST 36 VALUES OF DE/DX (UP TO 10.0 MEV/NUC) BY TAKING 
C   EXPONENTIAL OF VALUES RETURNED BY ICS1V. A GRADUAL TRANSITION 
C   A GRADUAL TRANSITION FROM N-S VALUES TO BARKAS & BERGER VALUES IS 
C   MADE AT 11.0 AND 12.0 MEV/NUC.
C 
      DO 34 I = 1,36
   34 STOP(I) = EXP(DEDX(1,I))
      RETRN = .TRUE.
C 
C   CALCULATE THE REMAINING 72 VALUES OF DE/DX (11.0 TO 5000. MEV/NUC)
C   BY CALLING THE SUBROUTINE FUN WITH RETRN=.TRUE. 
C 
      DO 35 I=37,108
35    STOP(I) = FUN(EGRID(I)) 
      RETRN = .FALSE. 
C 
C   CALCULATE PARAMETERS NEEDED TO CORRECT THE RANGE FOR NUCLEAR
C   STOPPING USING LSS THEORY 
C 
      ZZ = SQRT(Z1**(2.E0/3.E0)+Z2**(2.E0/3.E0))
      CE = 3.255E4*M1*M2/((M1+M2)*Z1*Z2*ZZ) 
      CR = 6.0277275E-6*((M1+M2)*ZZ)**2/M1
      CK = 1.086E-3*SQRT(M2*((M1+M2)*ZZ)**3/(Z1*Z2))/M1 
C 
C   BEGIN LOOP TO CALULATE RANGE AT EACH OF THE 108 ENERGIES
C 
      DO 70 I=1,108 
      TEG(I) = M1*EGRID(I)
      AE(I) = CE*EGRID(I) 
      AK(I) = CK*STOP(I)/SQRT(TEG(I)) 
      IF(I.GT.1) GO TO 40 
      AKBAR(I) = AK(I)
      GO TO 50
   40 AKBAR(I) = (AK(I)+AK(I-1))/2.E0 
   50 S(I) = EXP(0.9E0*ALOG(AE(I))+0.56E0*AE(I)**(-0.56E0)-1.29E0 
     1            +0.5E0*ALOG(10.E0*AK(I))) 
      S1(I) = S(I)/(S(I)+1.E0)
C 
C  CHOOSE ONE OF TWO PARABOLIC FITS FOR EK BASED ON VALUE OF AKBAR
C 
      IF (AKBAR(I).GE.5) GO TO 55 
      EK =CR*(1.826-.28296*AKBAR(I)+.03248*AKBAR(I)**2)*AKBAR(I)**(-1.5)
      GO TO 57
55    EK=CR*(.9964+.01747*AKBAR(I)+.002923*AKBAR(I)**2)*AKBAR(I)**(-1.5)
   57 IF(I.GT.1) GO TO 60 
C 
C   CALCULATE ELECTRONIC RANGE AT FIRST GRID POINT BY ASSUMING DE/DX
C   IS PROPORTIONAL TO V FROM ZERO TO FIRST GRID ENERGY 
C 
      RELEC(I) = 2.0*M1*EGRID(I)/STOP(I)
      RTOT(I) = RELEC(I) - EK*S1(I) 
      GO TO 70
   60 RT = ASIMP(EGRID(I-1),EGRID(I))*M1
      RELEC(I) = RELEC(I-1) + RT
      RTOT(I) = RTOT(I-1) + RT - EK*(S1(I)-S1(I-1)) 
   70 CONTINUE
C 
C   OUTPUT SECTION
C 
c      ILINE = 38
c      IF (LU2.EQ.12) ILINE=27 
c      DO 80 I=1,108 
c      IF(MOD(I-1,ILINE).NE.0) GO TO 75
c      IF(I.EQ.1) GO TO 74 
c      WRITE(LU2,2003) 
c      WRITE(LU2,2005) NAMIN,NAMOUT
c   74 WRITE(LU2,2000) datew, timew
c      WRITE(LU2,2001) NAMP,M1 
c      WRITE(LU2,2002) NAMT,NAMT,NAMT
c   75 IF(MOD(I-1,6).EQ.0) WRITE(LU2,2003) 
c   80 WRITE(LU2,2004) EGRID(I),STOP(I),RTOT(I),RELEC(I),TEG(I)
c      WRITE(LU2,2003) 
c      WRITE(LU2,2005) NAMIN,NAMOUT
      DO 250 I=1,108,2
      I2=I+1
      WRITE(11,260) (EGRID(J),RTOT(J),STOP(J),J=I,I2)
260   FORMAT(F9.4,2E15.6,2X,F9.4,2E15.6)
250   CONTINUE
	close(11)
      GO TO 20
 2000 FORMAT(' HEAVY ION RANGE AND STOPPING POWER INTERPOLATES ',20X, 
     +9a1,2x,8a1/)
 2001 FORMAT(20X,4A2' IONS'/5X'ENERGY'53X'ENERGY'/
     +6X,'PER'10X'DE/DX*',6X,'RANGE+'10X'RANGE+',12X,'FOR'/ 
     +3X,'MASS UNIT ',18X,'(TOTAL)',7X,'(ELECTRONIC)',7X,'A=',F7.3/ 
     +3X,71('-')/1H0) 
 2002 FORMAT(3X,'MEV/AMU',9X,4A2,4X,4A2,9X,4A2,9X,'MEV')
 2003 FORMAT(1H0) 
 2004 FORMAT(F10.4,4X,1PE12.3,0P,F12.3,5X,F12.3,6X,F9.4)
 2005 FORMAT(3X, 71('-')//3X,'* ELECTRONIC STOPPING POWER IN UNITS OF ' 
     1'MEV/(MG/CM**2)'15X'INPUT FILE: '3A2/3X,'+ RANGE IN UNITS OF ', 
     + 'MG/CM**2'41X'OUTPUT FILE: '3A2) 
1200	END 
      FUNCTION FUN(G1)
C 
C   THIS FUNCTION SUBROUTINE RETURNS ELECTONIC STOPPING AT ENERGY/NUC 
C   OF G1 (MEV/NUC) IF RETRN=.TRUE. OR THE RECIPROCAL OF THAT VALUE 
C    IF RETRN=.FALSE. 
C 
      REAL IADJ,M1,M2 
      LOGICAL RETRN 
      COMMON IADJ,M1,Z1,M2,Z2,RETRN 
      COMMON F(13),X(13),H(78),N
      G = ALOG(G1)
      FUN = 0.E0
      I2 = N
      I4 = 3*N
      I6 = 5*N
      I = 1 
      IF(G-X(1)) 45,30,5
    5 IF(G-X(N)) 15,20,35 
   10 IF(G-X(I)) 25,30,15 
   15 I = I+1 
      GO TO 10
C 
C  CALCULATE ELECTRONIC STOPPING FROM INTERPOLATION OF N-S VALUES 
C 
   20 I = N 
   25 I = I-1 
   30 J2 = I2+I 
      J4 = I4+I 
      J6 = I6+I 
      HT1 = G-X(I)
      HT2 = G-X(I+1)
      PROD = HT1*HT2
      HT3 = H(J4)+HT1*H(J6) 
      DELSQS = (H(J4)+H(J4+1)+HT3)/6.E0 
      FUN = EXP(F(I)+HT1*H(J2)+PROD*DELSQS) 
      IF(G1.LT.10.0) GO TO 40 
C 
C   CALCULATE ELECTRONIC STOPPING FROM BARKAS & BERGER
C 
   35 B2 = G1/931.478E0 
      B2 = B2*(B2+2.0E0)/(B2+1.E0)**2 
      ETA2 = (1.E0-B2)/B2 
      GAMI = SQRT(1.E0-B2)
      S=G1*1000.
C 
C   CALCULATE EFFECTIVE CHARGE
C 
C   USE NORTHCLIFFE-SCHILLING FORMULA FOR Z.LE.26 
C   USE ZIEGLER FORMULA FOR Z.GT.26 
C 
      IF (Z1.GT.26.) GO TO 54 
      ZEFF2 = 1.0 - 1.85*EXP(-274.0*SQRT(B2)/Z1)
      GO TO 60
   54 B=.886*SQRT(S/25.)*Z1**(-2./3.) 
      PI=3.1415927
      BA= B+.0378*SIN(PI*B*.5)
      ZHI=1.-(EXP(-BA)*(1.034-.1777*EXP(-0.8114*Z1))) 
      ZEFF2=ZHI**2. 
C 
C   FORMULA FOR CADJ FROM BARKAS & BERGER (1964), PG 20, EQ. 16.
C   VALID ONLY FOR ETA .GT. 0.13 (I.E. FOR E/A .GT. 6.22 MEV/NUC) 
C   ETA = BETA/SQRT(1-BETA**2) AND IS THE INVERSE OF THE ETA DEFINED
C   2 LINES AFTER STATEMENT 35 (ANOTHER INDICATION OF ANGLIN'S
C   PERVERSITY) 
C 
  60  CADJ = (((-0.38106E-9*ETA2+0.0304043E-6)*ETA2+0.422377E-6)*ETA2 
     1 +((1.57955E-12*ETA2-0.1667989E-9)*ETA2+3.858019E-9)*ETA2*IADJ) 
     2 *IADJ*IADJ 
C 
C   EVALUATE ELECTRONIC STOPPING USING BETHE-BLOCH FORMULA AS GIVEN 
C   IN EQ. 1 IN BARKAS AND BERGER 
C 
      STOP = ALOG(1.022012E6/ETA2/IADJ/SQRT(1.E0+1.097194E-3/M1/GAMI
     1 +(5.48597E-4/M1)**2))-B2-CADJ/Z2 
      STOP = STOP*0.30706608E-3*ZEFF2 
     1 *Z1**2*Z2/M2/B2
C 
C   FOR E/A BETWEEN 10. AND 12. MEV/NUC, AVERAGE THE VALUE OF ELECTRONIC
C   STOPPING FROM NORTHCLIFFE-SCHILLING AND THE VALUE FROM BARKAS AND 
C   BERGER TO PROVIDE A SMOOTH TRANSITION FROM PURE N-S AT 10.0 MEV/NUC 
C   TO PURE B & B AT 14 MEV/NUC.
C 
      IF(G1.LE.12.0) STOP = (STOP+FUN)/2. 
      FUN = STOP
      IF(RETRN) RETURN
   40 FUN = 1.E0/FUN
   45 RETURN
      END 
C     SUBROUTINE ICS1V (F,X,N,M,G,H,D,IER)
C 
C-ICS1VU--------D-------LIBRARY 1---------------------------------------
C 
C   FUNCTION            - CUBIC SPLINE ONE-DIMENSIONAL INTERPOLATION -
C                           UNEQUALLY SPACED DATA 
C   USAGE               - CALL ICS1VU(F,X,N,M,G,H,D,IER)
C   PARAMETERS   F      - VECTOR OF N UNEQUALLY SPACED
C                           FUNCTIONAL VALUES F(1),F(2),...,
C                           F(N), WHERE F(I) IS THE FUNCTIONAL
C                           VALUE AT X(I) 
C                X      - VECTOR OF N ABSCISSA X(1),X(2),...,X(N) 
C                N      - NUMBER OF DATA POINTS 
C                M      - NUMBER OF ANSWERS SOUGHT
C                G      - VECTOR G(1),G(2),...G(M)
C                           G(I) CONTAINS THE I-TH ABSCISSA 
C                           UPON ENTRY
C                H      - WORK AREA OF DIMENSION 6*N
C                D      - VECTOR D(1,1),D(1,2),...D(1,M)
C                           D(1,I) CONTAINS THE I-TH INTERPOLATE
C                           UPON RETURN 
C                       - VECTOR D(2,1),D(2,2),...D(2,M)
C                           D(2,I) CONTAINS THE I-TH FIRST
C                           DERIVATIVE INTERPOLATE UPON RETURN
C                       - VECTOR D(3,1),D(3,2),...D(3,M)
C                           D(3,I) CONTAINS THE I-TH SECOND 
C                           DERIVATIVE INTERPOLATE UPON RETURN
C                IER    - ERROR PARAMETER 
C                         TERMINAL ERROR = 128+N
C                           N = 1 INDICATES G(I) NOT IN INTERVAL
C                             (X(1),X(N)) FOR SOME I=1,2,...,M
C                           N = 2 INDICATES THAT CONVERGENCE WAS
C                             NOT OBTAINED IN 5*N ITERATIONS
C   PRECISION           - SINGLE
C   REQD. IMSL ROUTINES - UERTST
C   LANGUAGE            - FORTRAN 
C   REFERENCE           - T. N. E. GREVILLE, MATHEMATICAL METHODS FOR 
C                         DIGITAL COMPUTERS, VOL. 2, P. 156, 1967.
C-----------------------------------------------------------------------
C   LATEST REVISION     - APRIL 16, 1975
C 
      SUBROUTINE ICS1V(F,X,N,M,G,H,D,IER,LU1,LU2) 
C 
      DIMENSION          F(1),X(1),G(1),H(1),D(3,1) 
      DATA EPSLN,OMEGA/1.E-11,1.0717967697E0/ 
C                                  SET UP WORK AREAS
      I2=N
      I3=N+N
      I4=I3+N 
      I5=I4+N 
      I6=I5+N 
      NT=I6 
      N1 = N-1
C                                    DERIVATIVES,H(J4), USING CENTRAL 
C                                    DIFFERENCES
      DO 5  I=1,N1
         J2=I2+I
         H(I)=X(I+1)-X(I) 
         H(J2)=(F(I+1)-F(I))/H(I) 
    5 CONTINUE
      DO 10  I=2,N1 
         J2=I2+I
         J3=I3+I
         J4=I4+I
         J5=I5+I
         HT1=H(I-1)+H(I)
         H(J3)=.5E0*H(I-1)/HT1
         HT2=(H(J2)-H(J2-1))/HT1
         H(J4)=HT2+HT2
         H(J5)=H(J4)+HT2
   10 CONTINUE
      H(I4+1)=0.E0
      J4=I4+N 
      H(J4)=0.E0
C                                  BEGIN ITERATION ON SECOND DERIVATIVES
      IER = 0 
      KCOUNT=0
   15 ETA=0.E0
      KCOUNT=KCOUNT+1 
      DO 25  I=2,N1 
         J3=I3+I
         J4=I4+I
         J5=I5+I
         W=(H(J5)-H(J3)*H(J4-1)-(.5E0-H(J3))*H(J4+1)-H(J4))*OMEGA 
         IF(ABS(W).LE.ETA) GO TO 20 
         ETA=ABS(W) 
   20    H(J4)=H(J4)+W
   25 CONTINUE
      IF(KCOUNT.GT.NT) GO TO 75 
      IF (ETA.GE.EPSLN) GO TO 15
C                                  CONVERGENCE OBTAINED 
      DO 30 I=1,N1
         J4=I4+I
         J6=I6+I
         H(J6)=(H(J4+1)-H(J4))/H(I) 
   30 CONTINUE
      DO 65 J=1,M 
         I=1
         IF (G(J)-X(1)) 70,60,35
   35 IF(G(J)-X(N)) 45,50,70
   40    IF (G(J)-X(I)) 55,60,45
   45    I=I+1
         GO TO 40 
   50    I=N
   55    I=I-1
C                                  COMPUTE D(J) 
   60    J4=I4+I
         J2=I2+I
         J6=I6+I
         HT1=G(J)-X(I)
         HT2=G(J)-X(I+1)
         PROD=HT1*HT2 
         HT3=H(J4)+HT1*H(J6)
         DELSQS=(H(J4)+H(J4+1)+HT3)/6.E0
         D(1,J)=F(I)+HT1*H(J2)+PROD*DELSQS
         D(2,J) = H(J2)+(HT1+HT2)*DELSQS+PROD*H(J6)*0.166666667E0 
         D(3,J) = HT3 
   65 CONTINUE
      RETURN
   70 IER=129 
      GO TO 9000
   75 IER=130 
 9000 CONTINUE
      WRITE(LU2,100) IER
  100 FORMAT(1X'ISC1VU DETECTS ERROR,IER='I4' OUTPUT ENERGY GRID POINT ',
     * 'LIES OUTSIDE RANGE OF INPUT EGRID') 
      RETURN
      END 
      FUNCTION ASIMP(A1,B)
C 
C   SIMPSON RULE INTEGRATION ROUTINE
C   INTEGRATES (DE/DX)**-1 FROM A1 TO B MEV/NUC TO OBTAIN RANGE 
C   INCREMENT. ITERATES BY DIVIDING INTERVAL INTO MORE AND MORE PIECES
C   UNTIL INTEGRAL CONVERGES. 
C 
C 
      REAL M1,M2
C 
      DIMENSION F2(30),FBP(30),EST2(30),NRTR(30)
C 
      COMMON IADJ,M1,Z1,M2,Z2,RETRN 
      COMMON ALSOP(13),DLE(13),WORK(78),NE,LU1
C 
      A=A1
      DA=B-A
C 
C   INITIALLY DIVIDE E/A INTERVAL INTO 2 EQUAL PIECES. EVALUATE 
C   (DE/DX)**-1 AT END POINTS AND CENTER BY CALLING FUN. INTEGRATE
C   USING SIMPSON RULE. 
C 
      FA=FUN(A) 
      FM=FUN((A+B)*0.5E0) 
      FB=FUN(B) 
      EST=(FA+4.0E0*FM+FB)*DA/6.0E0 
      ASIMP=0.0E0 
      IF(EST.EQ.0.0E0) RETURN 
      EPS = 1.E-5 
      ESUM=0.0E0
      ABSAR = EST 
      LVL=1 
    1 DX = 0.5E0**LVL*DA
      F1=FUN(A+0.5E0*DX)
      F2(LVL)=FUN(A+0.5E0*DX+DX)
      EST1=(DX/6.0E0)*(FA+4.0E0*F1+FM)
      FBP(LVL)=FB 
      EST2(LVL)=(DX/6.0E0)*(FM+4.0E0*F2(LVL)+FB)
      ABSAR=EST1+EST2(LVL)-EST+ABSAR
      DIFF=ABS(EST1+EST2(LVL)-EST)
      DAFT=(EST+EST2(LVL)-EST)/1.5E1
      IF(DIFF.GT.EPS*ABSAR.AND.LVL.LT.30) GO TO 5 
      IF(LVL.EQ.1) GO TO 5
      A=DX+DX+A 
      ASIMP=EST1+EST2(LVL)+ASIMP
    3 LVL=LVL-1 
      ESUM=ESUM-DAFT
      IF(NRTR(LVL).NE.2) GO TO 4
      EPS = EPS + EPS 
      IF(LVL.GT.1) GO TO 3
      IF(ABS(ESUM).GE.DIFF/ABSAR) RETURN
      ASIMP=ASIMP-ESUM
      RETURN
    4 NRTR(LVL)=2 
      FA=FB 
      FM=F2(LVL)
      FB=FBP(LVL) 
      EST=EST2(LVL) 
      LVL=LVL+1 
      GO TO 1 
    5 NRTR(LVL)=1 
      EST=EST1
      FB=FM 
      FM=F1 
      EPS=EPS*0.5E0 
      LVL=LVL+1 
      GO TO 1 
      END 
