        pro ssd_defect, En_nuc,atomic_mass,fraction
;
;       Based on ULEIS Nov 97 flare data  gm 1/14/97
;
;
;	Modification history:
;		1/20/98	allow fraction >1 values
;		9/29/98	modify so that low mass elements always
;			have fraction = 1 above 500 keV/n
;		1/19/01 add an extra mass line for Au (197 AMU)
;			for UH calibrations /gm
;		14-Apr-09	install on Mac as IDL routine   /gm
;
;	common ssd_defect_common, mass_array_defect, fraction_array, energy_array, defect_table_address, lun_table (variables are in main pgm)
	common ssd_defect_common
	
	

	if(n_elements(mass_array_defect) eq 0 ) then begin
			mass_array_defect = [4., 16., 56., 197. ]
			fraction_array = fltarr(12,4)
			energy_array = fltarr(12)
		openr, lun_table, defect_table_address, /get_lun
		instring = ' '
		for i = 1, 2 do begin
			readf, lun_table, instring   ; skip over header lines
		endfor
		for i = 0, 11 do begin
			readf, lun_table, e0, f0, f1, f2, f3
			energy_array(i) =  e0
			fraction_array(i,0) = f0
			fraction_array(i,1) = f1
			fraction_array(i,2) = f2
			fraction_array(i,3) = f3
		endfor
		free_lun, lun_table
	endif
	
	
;	find mass index: 
	if( atomic_mass lt mass_array_defect(0) ) then begin
			m_index = 0	
	endif else begin
		for i = 0, 2 do begin
			m_index = i
			if( (atomic_mass ge mass_array_defect(i)) and (atomic_mass le mass_array_defect(i+1) )) then break
		endfor
	endelse

;	find the energy index
	if( en_nuc lt energy_array(0) ) then begin
		e_index = 0
	endif else begin
		for i = 0, 10 do begin 
			e_index = i
			if( (en_nuc ge energy_array(i)) and (en_nuc le energy_array(i+1) )) then break
		endfor
	endelse



	interpolate_ln, fract_lo, en_nuc, energy_array(e_index), energy_array(e_index+1),fraction_array(e_index,m_index), fraction_array(e_index+1,m_index) 

	interpolate_ln, fract_hi, en_nuc, energy_array(e_index), energy_array(e_index+1), fraction_array(e_index,m_index+1), fraction_array(e_index+1,m_index+1) 

	interpolate_ln, fraction, atomic_mass, mass_array_defect(m_index), mass_array_defect(m_index+1), fract_lo, fract_hi


;	print, m_index, e_index, fract_lo, fract_hi, fraction


;        if(fraction.gt.1.) fraction = 1.     ; 1/20/98 gm
        if(fraction lt 0.001) then fraction = 0.001
	if((En_nuc gt 0.5) and (atomic_mass le 4)) then fraction=1.  ; 9/29/98
	if((fraction gt 1.) and (atomic_mass le 4)) then fraction=1.  ; 9/29/98
	
	return
        end                                                    
