	pro print_tables_trim, output_folder, n_range_tables, atomic_mass, range_file_names
;	
;	routine which print input range energy table and interpolated values for representative enrgies


	common tel_response_tables
;	print out the tables
	output_file = string( atomic_mass, format="('range_tables_trim_A_eq_',f0,'.txt')" )
	openw, lun_output, output_folder + output_file, /get_lun

	for i = 0, (n_range_tables-1) do printf, lun_output, i, range_file_names(i), format="('Range file ',i2,':    ',a)"
	for i = 0, (n_range_tables-1) do printf, lun_output, i,i, format="($,'Absorber ',i0,' ln( MeV ),','Absorber ',i0,' ln( range ),')"
	printf, lun_output, ' '
	for i = 0,999 do begin
		for j = 0, (n_range_tables-1) do printf, lun_output, energies(i,j), ranges(i,j), format="($2(e12.4,','))"
		printf, lun_output, ' '
;		if(energies(i,0) gt 9.68034 ) then break
	endfor
	free_lun, lun_output
;	stop

	output_file = string( atomic_mass, format="('range_tables_trim_interpol_A_eq_',f0,'.txt')" )
	openw, lun_output, output_folder + output_file, /get_lun
	for i = 0, (n_range_tables-1) do printf, lun_output, i, range_file_names(i), format="('Range file ',i2,':    ',a)"
	for i = 0, (n_range_tables-1) do printf, lun_output, i,i, format="($,'Absorber ',i0,' ln( MeV ),','Absorber ',i0,' ln( range ),')"
		printf, lun_output, ' '
	e_inc = 0.01/1.01
	
	while( e_inc lt 20 ) do begin
	e_inc *=1.01
	
	total_energy = atomic_mass*e_inc
	total_energy = alog(total_energy)
	e_left = 0.

	for  i = 0, (n_range_tables-1) do begin
		type = i
		
;		find energy in table that is just greater than total_energy

		for j = 1, 1000 do if( energies(j,type) gt total_energy) then break
;		print, ' j = ', j

;			interpolate the range using "parabolic interpolation" (see Bevington)
			index = j-1
;			print, index, type, exp(energies(index,type)), exp(ranges(index,type))
			a1 = ranges( index, type)
			a2 = (ranges( index+1, type) - a1)/(energies( index+1,type) - energies(index,type))
			a3 = (ranges( index+2, type) - a1 - a2*(energies( index+2,type) - energies(index,type)))/    $
				((energies( index+2,type) - energies( index,type ))*(energies( index+2,type) - energies( index+1,type )))
			range_interpolated = a1 + a2*(total_energy - energies(index,type)) + $
				a3*(total_energy - energies(index,type))*(total_energy-energies(index+1,type))		


		
		printf, lun_output, total_energy, range_interpolated, format="($2(e12.4,','))"

;			print, ' a1, a2, a3, range: ', a1, a2, a3, range_interpolated
;			stop
	
		
	endfor    ; i loop for absorber type
		printf, lun_output, ' '

	endwhile
	
	free_lun, lun_output
;	stop
	
	
	end
	
