	pro loss_trim, e_inc, atomic_mass, angle, n_start, n_stop,  e_left, range_spline
;	
;	routine which calculates energy loss in a stack of absorbers and 
;	returns residual energy -- copied from routine by Doug Hamilton
;
;	e_inc			particle energy (MeV/nuc) when it hits absorber "n_start"
;	atomic_mass	atomic mass of particle
;	theta			angle of incidence (degrees - 0 = normal)
;	n_start		first absorber in the stack to be considered
;	n_stop		last absorber in the stack to be considered
;	e_left		residual energy (MeV/nuc) when particle exits absorber "n_stop"
;
;	up to 100 absorbers may be specified.  thickness in mg/cm2 and material type 
;	are passed to this subroutine in common in the variables absorber_thickness, 
;	and absorber_type.  energies(1000,100) and ranges(1000,100) contain the 
;	logs of the necessary energy-range data.
;	total_kin_en is ln (total kinetic energy in MeV)
;	range is ln (range in mg/cm2);  absorber_type is second subscript of the range array
;

	common tel_response_tables
;	print out the tables
	openw, lun_output, '/data/joey/masongm1/Programs/idl_general/telescope_response/tel_response_trim_idl_code/range_tables.txt', /get_lun
	
	for i = 0,999 do begin
		for j = 0, 3 do printf, lun_output, energies(i,j), ranges(i,j), format="($2(e12.4,','))"
		printf, lun_output, ' '
;		if(energies(i,0) gt 9.68034 ) then break
	endfor
	free_lun, lun_output
	stop

	openw, lun_output, '/data/joey/masongm1/Programs/idl_general/telescope_response/tel_response_trim_idl_code/range_tables_interpolated.txt', /get_lun

	e_inc = 0.01/1.01
	
	while( e_inc lt 20 ) do begin
	e_inc *=1.01
	
	total_energy = atomic_mass*e_inc
	total_energy = alog(total_energy)
	e_left = 0.

	for  i = 0,3 do begin
		type = i
		
		range_interpolated = poly(energies(0:num_energies(i),i),total_energy)
		
		printf, lun_output, total_energy, range_interpolated, format="($2(e12.4,','))"

;			print, ' a1, a2, a3, range: ', a1, a2, a3, range_interpolated
;			stop
	


		
	endfor    ; i loop for absorber type
		printf, lun_output, ' '

	endwhile
	
	free_lun, lun_output
	stop
	
	
	end
	
