	pro tel_response_trim_grid_losses,input_file
;
;	program to calculate losses in SIS telescope grids for LBL run interpretation 
;
;	Modification history:
;		22-Jul-2014		adapted from tel_response_trim program /gm
;						ssd defect not used
;
;	set up common table
	@/data/joey/masongm1/Programs/idl_general/telescope_response/tel_response_trim_idl_code/tel_response_tables_trim.inc
	

	forward_function speed

	

	instring = ''
	title = ''
	file_name = ''
	mass_array = fltarr(1)
	e_inc_store = fltarr(1)
	range_file_names = strarr(100)

	input_file=strtrim(input_file,2)   ; remove any leading or trailing blanks from input file string
;	read in telescope description	
	openr, lun_input, input_file, /get_lun
	readf, lun_input, title
	readf, lun_input, angle, sigma_L_ov_L
	readf, lun_input, E_lo, E_hi, E_factor
;
;	read in absorbers
;
	readf, lun_input, n_absorbers, n_range_tables
		for i = 0, n_absorbers-1 do begin
			readf, lun_input, instring
				reads, instring,  absorber_no, thickness, type
				absorber_thickness(i) = thickness
				absorber_type(i) = type - 1
				title_loc = strpos(instring, 'title')
				absorber_title(i) = strmid(instring, title_loc+7, strlen(instring))
		endfor
;
;	check that n_range_tablees is at least as large as the number of range tables read in
	if( (max(absorber_type)+1) gt n_range_tables) then begin
		print, 'input list has maximum absorber type: ', max(absorber_type)+1, ' which is greater than # range tables: ', n_range_tables
		print, ' program stopping;
		stop
	endif


;
;	read energy deposit segments
	readf, lun_input, num_ssds
		for i = 0, num_ssds - 1 do begin
			readf, lun_input, ssd_in, noise
			ssd_absorber(i) = ssd_in -1
			ssd_noise(i) = noise
		endfor

;	read in folder containg range tables
	data_folder = ''
	readf, lun_input, data_folder
	data_folder = strtrim(data_folder)


;
;	now process a single element
;

	readf, lun_input, instring
	if( strmid(instring,0,3) eq 'end' ) then goto, finish
	
;	find first blank in input string

	loc = strpos(instring,' ')
	element = strmid(instring,0,loc)

;	now read the atomic_mass
	reads, strmid(instring,loc,strlen(instring)), atomic_mass

;	store the mass being processed
	if( mass_array(0) eq 0. ) then mass_array = atomic_mass  else mass_array = [mass_array, atomic_mass]
;
;	prompt for the mass of the ion in the beam
	print, 'Mass of range table ion is: ', mass_array(0)
	read, mass_beam, prompt='Enter mass of ion beam (amu): '	


;	now read in the data tables for this element -- take logs of input ranges & energies
;	note, program can read in tables it doesn't use -- makes handling of input file easier
	for i = 0, n_range_tables-1 do begin
		readf, lun_input, instring
;	strip off the file name from the first part of the line--
		file_name = strmid(instring,0,strpos(instring,' '))
	range_file_names(i) = file_name
;	now read the atomic mass used to generate this range table from the rest of the string
		reads, strmid(instring, strpos(instring,' '),strlen(instring)-strpos(instring,' ')), atwt_range_table 
;		print, atwt_range_table
;		range_table = data_folder + file_name + '.dat' 
		range_table = data_folder + file_name
		openr, lun_table, range_table, /get_lun
;		printf, lun_output, i+1, file_name,  format="('Absorber type: ',i3,8x,' Range-energy data from file: ',a)"
;	TRIM file reading -- 
;	skip down to the first data line --
	units_e1 = ' '
	units_r1 = ' '
	while( strpos(instring, '-----------' ) eq -1 ) do begin
		readf, lun_table, instring
			if( strpos(instring, 'Target Density') ne -1 ) then begin 
			reads, instring, density, format="(t19, e12.4)"
;			printf, lun_output, density, format="('Density = ',f10.4,' g/cm3')"
		endif
	endwhile
	
	for table_entry = 0L, 1000L do begin
		readf, lun_table, instring
		if( strpos(instring, '-----------' ) ne -1 ) then break
		reads, instring, e1, units_e1, r1, units_r1, format="(f7.0,x,a4,t35,f8.0,a3)"
;		print, table_entry, e1, units_e1, r1, units_r1
;  10.00 keV   4.245E-01  7.339E-01     233 A       129 A        94 A
;	now convert energy to MeV
	case units_e1 of
		'keV ':	e1/= 1000.d0
		'MeV ':
		'GeV ':	e1 *= 1000.d0
	endcase
	energies(table_entry,i) = alog(e1)    ; convert to log of total energy
					
;	now convert ranges to mg/gm2
	case units_r1 of
		' A ':		r1 *= 1.0d-8	
		' um': 	r1 *= 1.0d-4
		' mm':	r1 *= 1.0d-1
		' cm':
		' m ':		r1 *= 1.0d2
	endcase

		r1 *= 1000.d0*density ; convert from distance to mg/cm2
		ranges(table_entry,i) = alog(r1*atomic_mass/atwt_range_table)

	endfor 	; end table reading
	
		num_energies(i) = table_entry -1
	
		free_lun, lun_table

	endfor	; loop for multiple tables


;		stop
	

;	*************************** main section for energy loss calculation **************************

;	prompt for an energy
	read, e_inc, prompt='Enter incident energy per nucleon: '
	if( e_inc le 0. ) then goto, finish

;next_absorber:

	
;	prompt for an absorber thickness of Ni (microns): 0-- this is absorber 9 (index = 8) inserted into the stack
;	read, abs_thickness, prompt="Enter Ni absorber thickness in microns: "

	for abs_thickness = 0, 60 do begin
	absorber_thickness(8) = abs_thickness*1e-4*1e3*8.908		; thickness * microns/em * milligram/g * density of Ni


	
;	now calculate the ssd deposits

		ssd = fltarr(10)
		for i = 0, num_ssds-1 do begin
			loss_trim, e_inc, atomic_mass, angle, 0, ssd_absorber(i)-1, e_ssd_in
;			print,e_inc, atomic_mass, angle, 0, ssd_absorber(i)-1, e_ssd_in

;	******** now correct e_ssd_in to take account of difference between beam mass and absorber atomic_mass
;			(assume that for dE/dx losses are identical, and only the remaining energy is affected)
		if( e_ssd_in le 0. ) then begin
			ssd(i) = 0
			goto, write_out
		endif
			e_ssd_in = (e_inc*mass_beam - (e_inc - e_ssd_in)*atomic_mass)/mass_beam

			loss_trim, e_ssd_in, atomic_mass, angle, 0, ssd_absorber(i), e_ssd_out
;			print,e_ssd_in, atomic_mass, angle, 0, ssd_absorber(i), e_ssd_out
			ssd(i) = (e_ssd_in-e_ssd_out)*mass_beam
; stop
		endfor
;		print, ssd(0:1)




;	write out the results
write_out: 
	print, 'Energy deposit in ssd, absorber thickness (microns): ', ssd(0), abs_thickness
		
	endfor	; abs_thickness loop


;stop


;	printf, lun_output, e_inc, atomic_mass, format="($,x, 2(f9.4,','))"
;	for i = 0, num_tof-1 do printf, lun_output, tof(i), format="($,x, e11.4,',')"
;	for i = 0, num_ssds-1  do printf, lun_output, ssd(i), format="($,x, e11.4,',')"

;	stop



;	goto,  next_absorber

	stop

finish:	



	close, /all

	end

	function speed, e_left

;	returns cm/ns for input energy/nucleon

	beta = sqrt(1. - (931.5/(931.5+e_left))^2)
	return, beta*29.9792458d0  ; speed in cm/ns
	end

