	pro tel_response_resolution_plotter
;
;	routine to read a tel_response_trim sav file and produce a plot of the 
;	value of sigma-m/m over the mass/energy plane

;	Modification history:
;		14-Jan-2015 adapted from sis_em_wedge_scan.pro /gm


	input_file = '/data/joey/masongm1/Text/Solar_Orbiter/SIS_instrument/eloss/sigma_plot/sis_a_fm_tel_response_trim.txt'

;startup:
;	input_file = ''
;	read, input_file, prompt='Enter tel_response_trim.txt file name (no quotes): '
;	input_file=strtrim(input_file,2)   ; remove any leading or trailing blanks
;	if( strpos(input_file,'.txt') gt -1) then begin
;		restore, input_file
;	endif else begin
;		print, '******************* input file not a .txt file **********************'
;		goto, startup
;	endelse

	output_folder = strmid(input_file, 0, strpos(input_file,'/', /reverse_search)) + '/'

;

;	************************ read the sav file and make up the array of points *****************

	openr, lun_input, input_file, /get_lun
	x_array = fltarr(100000)	; has the array of einc (MeV/nuc) values
	y_array = fltarr(100000)	; has the values of mass for each einc value
	z_array = fltarr(100000)	; has the sigma-m/m values for each point

	index = 0l
	input_string = ''
	input_array = fltarr(11)
	readf, lun_input, input_string
;	********** element loop *****************
next_element:
	while( strmid(input_string, 0, 13) ne 'Einc (MeV/n),') do readf, lun_input, input_string
next_line:
	while( ~eof( lun_input ) ) do begin
		readf, lun_input, input_string	
		if( strmid(input_string, 10, 1) ne ',' ) then goto, next_element
;		decode the input string
		reads, input_string, input_array
		if( input_array(7) eq 0. ) then goto, next_line	; if no sigma value quit
		if( input_array(5) gt 600. ) then goto, next_line	; don't put in values above saturation
		if( input_array(2) lt 4 ) then goto, next_line		; don't allow tof less than 4 ns
		if( ((input_array(1) gt 0.5) and (input_array(1) lt 1.5 )) and (input_array(0) gt 9.399 )) then goto, next_line 	; H penetration
		if( ((input_array(1) gt 3.5) and (input_array(1) lt 4.5 )) and (input_array(0) gt 9.493 )) then goto, next_line 	; 4He penetration
		if( ((input_array(1) gt 2.5) and (input_array(1) lt 3.5 )) and (input_array(0) gt 11.132 )) then goto, next_line 	; 3He penetration
			x_array(index) = input_array(0)
			y_array(index) = input_array(1)
			z_array(index) = input_array(7)
			index ++
		goto, next_line
	endwhile
	
;	get rid of the zeroes at the end of the arrays	
	x_array = x_array(0:index-1)
	y_array = y_array(0:index-1)
	z_array = z_array(0:index-1)
;	stop

;	now do contour plot

	

;stop	; save, filename = '/data/joey/masongm1/Data/SIS_tests/sis_wedge_and_telescope_tests/2013_10_21_1hr_dwell/mass_scan.sav'



	set_plot,'ps'
	psfilename = output_folder + '/' +'tel_response_sigma_plot.ps' 
     	device,/color,/landscape,filename=psfilename,bits_per_pixel=8,/helvetica,/iso
     	device,xsize=25,ysize=20
    	device,xoff=1.25,yoff=28.0
    	!p.color=1  
    	!p.font=0

; 	set plot characteristics
	!p.thick    = 2
	!p.charsize=1.1
   	!x.ticklen  = 0.02
   	!y.ticklen  = 0.02   
   	!x.thick=2
   	!y.thick=2
   	csize=1.5


;	loadct, 27	; EOS B color table
	loadct, 39	; rainbow + black

	

;	space out levels to cover range of mean values from 0.01 to 2.0 in levels of 5% 
	levels = [0.0005]
	while( max(levels) lt 2.0 ) do levels = [levels, max(levels)*1.2]

	

	num_levels = n_elements(levels)


	c_labels = 1 + fltarr(num_levels)	; turns on all labels
;	now turn off the labels above 0.023
	locs = where(levels gt 0.023 )
	c_labels(locs) = 0.	
;	now just turn on every 10th label above 0.023
	for i = locs(1), num_levels-1, 10 do c_labels(i) = 1.
	
	
	
	c_colors = bytscl(indgen(num_levels))	
	
	contour, z_array, x_array, y_array, /irregular, levels=levels, c_labels = c_labels, $ 
		c_colors = c_colors, /fill, xtitle='E incident (MeV/nucleon)', ytitle = 'Mass (AMU)', $
		xrange = [0.01,20], yrange=[0.5,300], xstyle=1, ystyle = 1, /xlog, /ylog, $	; set axis range and force selection of this range
		position = [0.125, 0.125, 0.64, 0.8]
	contour, z_array, x_array, y_array, c_charsize = 1.0, c_charthick = 1.0, c_thick=2, /irregular, $
		levels=levels, c_labels = c_labels, /overplot

;	*********************** these use coordinates used for the PLOT ************************
	xyouts, 0.01, 350, input_file, charsize = 1	; plot title
	xyouts,  30, 290, systime(), charsize = 0.7

;	these labels need to come before the oplot calls!
	xyouts, 40, 110,'sigma-m/m',charsize=0.8
	xyouts, 60,  25, string(levels(0),format="(f5.3)"),charsize=0.75,alignment = 1
	xyouts, 60,  65, string(levels(num_levels-1),format="(f5.3)"),charsize=0.75, alignment = 1

	
;	now plot a color bar   ************ switch to absolute coordinates!
	x_vals = [0.73, 0.75]
	y_start = 0.65
	y_dif=0.0025
;	for i=0,num_levels-1 do oplot, x_vals, [y_start-i*y_dif,y_start-i*y_dif],thick=2,color=c_colors(i)
	for i=0, num_levels-1 do plots, /norm, x_vals, [y_start-i*y_dif,y_start-i*y_dif],thick=5,color=c_colors(num_levels -1 -i)
	device,/close_file


	
	stop
	end


