	pro loss, e_inc, atomic_mass, angle, n_start, n_stop,  e_left
;	
;	routine which calculates energy loss in a stack of absorbers and 
;	returns residual energy -- copied from routine by Doug Hamilton
;
;	e_inc			particle energy (MeV/nuc) when it hits absorber "n_start"
;	atomic_mass	atomic mass of particle
;	theta			angle of incidence (degrees - 0 = normal)
;	n_start		first absorber in the stack to be considered
;	n_stop		last absorber in the stack to be considered
;	e_left		residual energy (MeV/nuc) when particle exits absorber "n_stop"
;
;	up to 100 absorbers may be specified.  thickness in mg/cm2 and material type 
;	are passed to this subroutine in common in the variables absorber_thickness, 
;	and absorber_type.  energies(108) and ranges(108,100) contain the 
;	logs of the necessary energy-range data.
;	total_kin_en is ln (total kinetic energy in MeV)
;	range is ln (range in mg/cm2);  absorber_type is second subscript of the range array
;

	common tel_response_tables

	total_energy = atomic_mass*e_inc
	total_energy = alog(total_energy)
	e_left = 0.

	for  i = n_start, n_stop do begin
		type = absorber_type(i)
		
;		find energy in table that is just greater than total_energy

		for j = 0, 107 do if( energies(j) gt total_energy) then break
;		print, ' j = ', j
		if( j gt 0) then begin
;			interpolate the range using "parabolic interpolation" (see Bevington)
			index = j-1
;			print, index, type, exp(energies(index)), exp(ranges(index,type))
			a1 = ranges( index, type)
			a2 = (ranges( index+1, type) - a1)/(energies( index+1) - energies(index))
			a3 = (ranges( index+2, type) - a1 - a2*(energies( index+2) - energies(index)))/    $
				((energies( index+2) - energies( index ))*(energies( index+2) - energies( index+1 )))
			range_interpolated = a1 + a2*(total_energy - energies(index)) + $
				a3*(total_energy - energies(index))*(total_energy-energies(index+1))		
;			print, ' a1, a2, a3, range: ', a1, a2, a3, range_interpolated
;			stop
		endif else begin

;			if incident energy below lowest table energy, assume that total dE/dx (electr. + nucl.) is
;			constant below 12.5 keV/n and calculate range as linear function of incident energy

			range_interpolated = total_energy - energies(0) + ranges( 0, type)		

		endelse
	
		range_interpolated = exp( range_interpolated )

;	get residual range by subtracting absorber thickness

		range_interpolated -= absorber_thickness(i)/cos(angle/!radeg)

		if( range_interpolated lt 0. ) then begin
			e_left = 0.
			return
		endif
		
		range_interpolated = alog( range_interpolated )
		
;	find energy corresponding to this residual range

		for j = 0, 107 do if( ranges( j, type ) gt range_interpolated) then break
		
		if(j gt 0) then begin
			index = j-1
			a1 = energies( index )
			a2 = (energies( index + 1 ) - a1)/(ranges(index+1, type) - ranges(index,type))

			a3 = (energies( index + 2 ) - a1 - a2*(ranges(index+2,type)-ranges(index,type)))/ $
				((ranges(index+2,type)-ranges(index,type))*(ranges(index+2,type)-ranges(index+1,type)))
			total_energy = a1 + a2*(range_interpolated - ranges(index,type))+ $ 
				a3*(range_interpolated - ranges(index,type))*(range_interpolated-ranges(index+1,type))
		
		endif else begin
			total_energy = range_interpolated - ranges( 0, type) + energies(0)
		
		endelse
		
	endfor    ; i loop for absorber type
	
	e_left = exp(total_energy)/atomic_mass

	end
	