	pro interpolate_ln, value, row, row_lo, row_hi, col_lo, col_hi 

;	traps for zero or negative values 7/7/97
	value = 0.
	if(row le 0.) then  return
	if(row_lo le 0.) then  return
	if(row_hi le 0.) then  return
	if(col_lo le 0.) then  return
	if(col_hi le 0.) then  return


	row_ln = alog(row)
	row_lo_ln = alog(row_lo)
	row_hi_ln = alog(row_hi)
	col_lo_ln = alog(col_lo)
	col_hi_ln = alog(col_hi)
	
	value = (row_ln - row_lo_ln)/(row_hi_ln - row_lo_ln)
	
	value = value*(col_hi_ln - col_lo_ln) + col_lo_ln
	if(abs(value) gt 40.) then value=40.   ; trap for large values 7/4/97
	value = exp(value)
	return
	end

