	function band, Anorm, Ezero, a, b, e
;
;	returns Band function value (Band et al. ApJ. 413, p281, 1993)
;
;	Inputs:
;		Anorm:	norm: 	normalization constant
;		Ezero:	e0: 	e0 term (break)
;		a:		alpha:	low energy segment exponent
;		b:		beta: 	high energy segment exponent
;		E:		energy:	energy at which function is evaluated
;
;
;	make sure all the parameters passed along are floating point
	norm = Anorm*1.d0
	e0 = Ezero*1.d0
	alpha = a*1.d0
	beta = b*1.d0
	energy = E*1.d0


	if( energy le (alpha-beta)*e0 ) then return, norm*(energy^alpha)*exp(-energy/e0)
	
	return, norm* ((alpha-beta)*e0)^(alpha-beta)*exp(beta-alpha)*(energy^beta)

	end