	pro spectral_fitter_band
;
;	routine to take input spectra and calculate band fit parameters and fit
;
;	Modification history:
;		15-Dec-2015	initial version /gm
;
;	useage: 
;		reads input file with title, spectral points for several species
;		calculates band fits
;		writes out a file of the data points and fits for plot checks
;		prints out tab delimited fit parameters for pasting into an excel sheet
;
;
;	*************** web reference: https://www.physics.wisc.edu/~craigm/idl/mpfittut.html *************
;	*************** or:  http://purl.com/net/mpfit
;
;	mpfitfun: citation: 
;	Markwardt, C. B. 2009, "Non-Linear Least Squares Fitting in IDL with MPFIT," in 
;	proc. Astronomical Data Analysis Software and Systems XVIII, Quebec, Canada, 
;	ASP Conference Series, Vol. 411, eds. D. Bohlender, P. Dowler & D. Durand 
;	(Astronomical Society of the Pacific: San Francisco), 
;	p. 251-254 (ISBN: 978-1-58381-702-5; Link to ASP title listing)
;	ADS Bibcode: 2009ASPC..411..251M (click for Bibtex and other citation formats)
;	Arxiv preprint: arXiv:0902.2850v1

		input_file = ''			
		read, input_file, prompt='Enter input file name (no quotes): '
;		input_file = '/data/joey/masongm1/Programs/idl_general/spectral_fitter_band/uleis_2011_221.txt'
		input_file=strtrim(input_file,2)   ; remove any leading or trailing blanks
		input_file_wo_path = strmid(input_file, strpos(input_file,'/', /reverse_search)+1, strlen(input_file))	
		
;		input file format:
;			species name #1:  format:  species: H
;			n lines with energy, fluence (or flux), sigma
;			other species....
;			
		input_string = ''
		openr, lun_input, input_file, /get_lun
		
;		open the output file
;		extract the folder where the output file will go
		output_folder = strmid(input_file, 0, strpos(input_file,'/', /reverse_search)) + '/'
		output_file = 'fit_' + input_file_wo_path
		openw, lun_output, output_folder + output_file, /get_lun
		printf, lun_output, 'Fit created with spectral_fitter_band.pro ', systime()
;		****************** fractional error parameters ***************
		errfract = 0.2
		printf, lun_output, 'intensity error:  set to a constant fraction: ', errfract
		printf, lun_output, 'input file: ', input_file_wo_path
		tabchar = string(9b)
		printf, lun_output, 'MeV/nuc,fluence,sigma data,sigma fitting,fit,'

;		printf, lun_output, 'MeV/nuc' + tabchar + 'fluence' + tabchar + 'sigma data' + tabchar + $
;						'sigma fitting' + tabchar + 'fit' + tabchar
		
;
;		loop to process multiple species
;	
		n_species = 0
		param_array = fltarr(100,11)		; array where the fit parameters and errors will be stored
		species_name = strarr(100)		; array where the species names are stored
		data = fltarr(3)
		data_no = 0
		species_no = 0
		readf, lun_input, input_string	; this gets the first species
		species_name(0) = strmid( input_string, strpos(input_string,':')+2, strlen(input_string))	; looks for ':'
		x = fltarr(100)
		y = x
		z = x
		finish = 0 	; false
		while( 1 ) do begin 		; one loop to read all species and data points; does fit when a new species encountered
			readf, lun_input, input_string
			if( strlen( input_string) lt 5 ) then finish = 1	; short record at end of file
			if( finish ) then goto, fit_species
			if( strpos(input_string, ':') ge 1 ) then begin		; encountered a new species
				if( data_no gt 0 ) then n_species ++
					species_name(n_species) = strmid( input_string, strpos(input_string,':')+2, strlen(input_string))
;					now fit the species just read in
fit_species:
						x = x(0:data_no-1)		; trim the arrays
						y = y(0:data_no-1)
						err = err(0:data_no-1)
;			make an initial guess about the parameters		
			start = [y(min(where(x gt 1))), 8., 1.5, 3.5]		; normalization is value near 1 MeV/n
			err = errfract*y 
			result = mpfitfun('band_expression', x, y, err, start, PERROR=perror)	
;stop
;		now save the fit results
			index = n_species-1
			if( finish ) then index ++
			param_array(index,0) = min(x)
			param_array(index,1) = max(x)
			param_array(index,2:5) = result
			param_array(index,6:9) = perror
;
;			now write out the data points and fit
			fit_array = band_expression(x, result)				
			chisq = total( ((y-fit_array)/err)^2 )
			param_array(index,10) = chisq			

;			now write out the data points and fit
;			for i = 0, data_no-1 do printf, lun_output, x(i), tabchar, y(i), tabchar, $
;					err(i), tabchar,  y(i)*errfract, tabchar, fit_array(i), tabchar, format = "(5(e12.4,a))"	
			for i = 0, data_no-1 do printf, lun_output, x(i),  y(i), err(i),   y(i)*errfract,  fit_array(i),  $
						format = "(5(e12.4,','))"					
			
;stop
;		now go to the next species -- reset the arrays
		if( finish ) then goto, clean_up
			x = fltarr(100)
			y = x
			z = x

					data_no = 0 
			endif else begin
				reads, input_string, data
					if( data_no eq 0 ) then begin 
						x = fltarr(100)		; set up arrays for this species+
						y = fltarr(100)
						err = fltarr(100)
					endif
				x( data_no ) = data(0)
				y( data_no ) = data(1)
				err( data_no ) = data(2)
				data_no ++
			endelse
			
;		stop

		endwhile		; file reading loop
stop
clean_up:

;	now print out the fit values for pasting into a spreadsheet
;
	print, '********** summary of fit parameters *************'
	print, input_file_wo_path
	print, 'Element', tabchar, 'Elo (MeV/n)', tabchar, 'Ehi (MeVn)', tabchar, $ 
		'normalization', tabchar, 'Ebreak', tabchar, 'gamma-a', tabchar, 'gamma-b', tabchar, $
		'sigma-norm', tabchar, 'sigma-Eb', tabchar, 'sigma g-a', tabchar, 'sigma g-b', tabchar, $
		'chisq', tabchar
	for i = 0, n_species do print, species_name(i), tabchar, param_array(i,0), tabchar, param_array(i,1), tabchar, $
													  param_array(i,2), tabchar, param_array(i,3), tabchar, $
													  param_array(i,4), tabchar, param_array(i,5), tabchar, $
													  param_array(i,6), tabchar, param_array(i,7), tabchar, $
													  param_array(i,8), tabchar, param_array(i,9), tabchar, $
													  param_array(i,10), tabchar, $
														format="(a,a,2(f8.3,a),(e12.3,a),3(f8.3,a),(e12.3,a),4(f8.3,a))"

		close,/all
		stop
		end
		
