	pro get_shock_times, ace_shock_times, stereo_a_shock_times, stereo_b_shock_times
;
;	routine to read ACE and STEREO shock lists and return arrays with SEP start mjd
;
;	Modification history:
;		9-Jun-2015	initial version /gm
;
;
;	*********************** ACE shock list ********************
	input_file = '/data/joey/masongm1/Text/Solar_Geophysical_Data/shock_list_ace/ace_shocks_2011_2014.txt'
	openr, lun_input, input_file, /get_lun
	input_line = ''
	time_no = 0l
;	skip over the header line
	readf, lun_input, input_line
	months = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December']
	while( ~eof(lun_input) ) do begin
;September 9, 2011 
;DOY 252 
;12:15 UT	F	MAG
;	first line, month, day, year	

	readf, lun_input, input_line	
;	extract the month
	for i=0,11 do if(strpos(input_line,months(i)) ne -1 ) then month=i+1
;	remove the month name
	input_line = strmid( input_line, strlen(months(month-1)), strlen(input_line) )
	reads, input_line, day, year	
	
;	skip the second line (doy)
	readf, lun_input, input_line
	
;	get the time - remove any "~"  and ":" characters
	readf, lun_input, input_line
	input_line = replace_text( input_line, '~', ' ')
	input_line = replace_text( input_line, ':', ' ')
	reads, input_line, hour, min
	mjd = date2mjd(year,month,day) + (hour/24.d0) + (min/1440.d0)
	
	if( time_no eq 0 ) then ace_shock_times = [mjd] $ 
	else ace_shock_times = [ace_shock_times, mjd]
		time_no ++
	endwhile


finish:	
	free_lun, lun_input


;
;	*********************** STEREO shock lists ********************
	names = ['a','b']
	for stereo = 0, 1 do begin
	input_file = '/data/joey/masongm1/Text/Solar_Geophysical_Data/shock_list_stereo/STEREO_' $ 
		+ names(stereo) + '_Level3_Shock-2.txt'
	openr, lun_input, input_file, /get_lun
	input_line = ''
	time_no = 0l
;	skip two header lines
	for i = 0, 1 do readf, lun_input, input_line
;#	Year	Month	Day	Hour	Minute	Second
	while( ~eof(lun_input) ) do begin	
	readf, lun_input, input_line
	reads, input_line, shock_no, year, month, day, hour, minute
	mjd = date2mjd(year,month,day) + (hour/24.d0) + (minute/1440.d0)
	case stereo of
	0:	if( time_no eq 0 ) then stereo_a_shock_times = [mjd] else stereo_a_shock_times = [stereo_a_shock_times, mjd]	
	1:	if( time_no eq 0 ) then stereo_b_shock_times = [mjd] else stereo_b_shock_times = [stereo_b_shock_times, mjd]
	endcase
	time_no ++
	
	
	endwhile	; loop for a single file
		free_lun, lun_input
	endfor	; stereo loop	


;	stop
	end
