	function get_richardson_times
;
;	routine to read Richardson event list and return an array with SEP start mjd
;
;	Modification history:
;		14-Apr-2015	initial version /gm
;
;
	input_file = '/data/joey/masongm1/Text/Solar_Geophysical_Data/SEP_list_Richardson/SEPlist2_times_reformatted.txt'
	openr, lun_input, input_file, /get_lun

	input_line = ''
	time_no = 0l

	while( ~eof(lun_input) ) do begin
;2013/12/05 10:00:00,2013/12/05 14:00:00, 2013,339.416656, 2013,339.583344,	
	
	readf, lun_input, input_line
	test = strmid( input_line, 40, strlen(input_line) )
	if( strlen(test) lt 10 ) then goto, finish
	reads, test, year, decday
	mjd = date2mjdfract(year, decday)
	if( time_no eq 0 ) then richardson_times = [mjd] $ 
		else richardson_times = [richardson_times, mjd]
		time_no ++
	endwhile
finish:	
	free_lun, lun_input

	return, richardson_times

;	stop
	end
