	pro find_tof, e_measure, j, k, value

;	input: 	e_measure		measured energy
;			j			tof number to look up
;			k			mass number to interpolate

;	output:  	value			the tof for this value of energy deposit, tof number, and mass number
;
;	subroutine interpolates values in einc_array to find tof for a given measured energy for every mass
;
	common tel_response_tables
;
	value=0.
	if(e_measure le 0.) then return



;	note:  ssd_num is the ssd # being used for looking up this value of e_measure
	ssd_num = 0    ; just doing the first ssd


;	find the approximate location in einc_array
	i_test=einc_number/2
	i_delta=i_test/2
	while( i_delta gt 2 ) do begin
		if( e_measure ge einc_array(i_test, num_tof + ssd_num, k) ) then i_test += i_delta else i_test -= i_delta
 		i_delta /= 2.
 	endwhile

 	i_delta *= 2.     ; restore i_delta to prior value
	i_scan_test = floor(i_test - i_delta)
	
;	now find the surrounding array elements
	for i_scan = i_scan_test, einc_number-3 do if ((e_measure ge einc_array(i_scan, num_tof + ssd_num, k)) and (e_measure lt einc_array(i_scan+1, num_tof + ssd_num, k))) then break
	
;	print, ' i,j,k,i_scan: ',i,j,k,i_scan, einc_array(i_scan, num_tof + ssd_num, k), einc_array(i_scan+1, num_tof + ssd_num, k)
	
	interpolate_ln, value, e_measure, einc_array(i_scan, num_tof + ssd_num, k), einc_array(i_scan+1, num_tof + ssd_num, k), einc_array(i_scan, j, k), einc_array(i_scan+1, j, k)
;	print,value, e_measure, einc_array(i_scan, num_tof + ssd_num, k), einc_array(i_scan+1, num_tof + ssd_num, k), einc_array(i_scan, j, k), einc_array(i_scan+1, j, k)	


	end
;	****************************
;	old search codes:
;	for this mass value, find the tof values on either side of e_measure
;	for i_scan = 0, einc_number-3 do if ((e_measure ge einc_array(i_scan, num_tof + ssd_num, k)) and (e_measure lt einc_array(i_scan+1, num_tof + ssd_num, k))) then break

;	if(emeas_first(j,k) lt (einc_number-3) ) then i_start = emeas_first(j,k)-1 else i_start = einc_number-4
;	if( i_start lt 0 ) then i_start = 0
;	for i_scan = i_start, einc_number-3 do begin
;			if(e_measure ge einc_array(i_scan, num_tof + ssd_num, k)) then $
;				if (e_measure lt einc_array(i_scan+1, num_tof + ssd_num, k)) then break
;	endfor