;	pro find_mass_einc
	pro find_mass_einc,  tof1, tof2, e_measure, tof1_mass, tof2_mass, einc_tof1, einc_tof2, einc_ssd

;
;	finds mass, e_incident for tof telescope
;	adapted from fortran version for ULEIS,  gm 6/21-24/96
;
;	input:  tof(), Emeas    -- tof may be an array
;	units:    ns  ,   MeV
;
;	output:  tof_mass(), einc_tof(), einc_ssd
;	units:          AMU         MeV/n      MeV/n   
;
;	Modification history:
;		16-29-Apr-2009	initial IDL version
;
	common tel_response_tables, title, run_time, num_tof, num_ssds, num_mass, mass_array, einc_number, max_einc_number, einc, einc_array, $
			emeas_number, emeas, emeas_array, tof_first, emeas_first
;	
;	**************** variables to save file ****************
;	title:   		run title array
;	run_time:  	run time of the tel_response program that made the .sav file
;	num_tof:  		number of TOF measurements 
;	num_ssds:		number of SSD energy measurements
;	num_mass		number of element masses calculated in this run
;	mass_array:	array of masses calculated for the run
;	einc_number:	number of energy values of incident energies
;	max_einc_number: array of maximum einc number for each element (ie max value before it penetrates the 1st ssd)
;	einc:			array with incident energy values for each used line of einc_array
;	einc_array:	array with indices (energy step, num_tof + num_ssds, masses) -- energy steps are incident energy
;	emeas_number:	number of measured energies in the ssd for the array keyed to measured energy
;	emeas:		array with measured energy values
;	emeas_array	array with indices (energy step, num_tof + num_ssds, masses) -- energy steps are measured energy
;	tof_first:		array with indices (num_tof, num_mass) of first non-zero tof value for each tof & mass
;	emeas_first:		array with indices (num_tof, num_mass) of first non-zero e_meas value for each tof & mass
;	*****************************************************

	forward_function find_mass, find_einc, find_tof

;	restore data at startup
	if( ~n_elements(run_time) ) then begin
		filename=''
		read,filename,prompt='enter tel_response sav filename: '
		restore,strtrim(filename)
	endif

;	read, tof1, tof2, e_measure, prompt='enter: tof1, tof2, e_measure: '

;
;
	find_mass, tof1, tof2, e_measure, tof1_mass, tof2_mass 
;	print, tof1, tof2, e_measure, tof1_mass, tof2_mass 


	find_einc, tof1, tof2, e_measure, tof1_mass, tof2_mass, einc_tof1, einc_tof2, einc_ssd
;	print, tof1, tof2, e_measure, tof1_mass, tof2_mass, einc_tof1, einc_tof2, einc_ssd


	end



