	pro find_mass, tof1, tof2, e_measure, tof1_mass, tof2_mass 
;
;	routine to interpolate mass given e_measure and tof values
;	interpolation is done using the array e_measure_array
;
;	input:		tof1, tof2, e_measure:	tof-1, -2, and measured energy (ns, ns, MeV)
;	output:		tof1_mass, tof2_mass	interpolated mass from the tof-1 and -2 values

	common tel_response_tables


;	look up the index for the energy deposit
	for i_scan = 0, emeas_number-3 do if( (e_measure ge emeas(i_scan)) and (e_measure lt emeas(i_scan+1)) ) then break	

	for j = 0, num_tof-1 do begin
	
	if(j eq 0) then tof_measure = tof1 else tof_measure = tof2


;		look up the tofs at i_scan that bracket the measured tof -- will interpolate using these mass values
		for k_scan = 0, num_mass-3 do if( (tof_measure ge emeas_array(i_scan,j,k_scan)) and (tof_measure lt emeas_array(i_scan,j,k_scan+1)) ) then break
	
;		interpolate tof values for the 2 mass lines at e_measure:
			find_tof, e_measure, j, k_scan, value_0
			find_tof, e_measure, j, k_scan + 1, value_1
;			print, e_measure, i_scan, j, k_scan, value_0
;			print,  e_measure, i_scan, j, k_scan + 1, value_1
			

		interpolate_ln, value, tof_measure, value_0, value_1, mass_array(k_scan), mass_array(k_scan+1)
	
		if(j eq 0) then tof1_mass = value else tof2_mass = value
	
	endfor

	end
