	pro 	find_einc, tof1, tof2, e_measure, tof1_mass, tof2_mass, einc_tof1, einc_tof2, einc_ssd
;
;	routine to interpolate mass given e_measure, tof values, and tof masses
;	interpolation is done using the array einc_array

;	input			tof1, tof2, Emeas, tof1_mass, tof2_mass
;	output		einc_tof1:  this is the Eincident value for mass tof1_mass and tof1
;				einc_tof2:  this is the Eincident value for mass tof2_mass and tof2
;				einc_ssd:  this is the Eincident value for mass (tof1_mass+tof2_mass)/2. and Emeas

	common tel_response_tables

	einc_tof1=0.
	einc_tof2=0.
	einc_ssd=0.
	if(e_measure le 0.) then return

;	***************************************** find einc_tof *******************************	
	for j = 0, num_tof-1 do begin
	
	if(j eq 0) then tof_measure = tof1 else tof_measure = tof2
	if(j eq 0) then mass = tof1_mass else mass = tof2_mass

;	look up the mass array values that bracket this mass
	for m_scan = 0, num_mass-3 do if( (mass ge mass_array(m_scan)) and (mass lt mass_array(m_scan+1)) ) then break
	if( mass lt mass_array(0) ) then m_scan = 0   ; trap for low masses
	
;	print, mass, mass_array(m_scan), mass_array(m_scan+1)
	
;	find the interpolated Einc at each of the two mass lines
	einc_temp=fltarr(2)
	index = 0
		for k = m_scan, m_scan+ 1 do begin


;			find the approximate location in einc_array
			i_test=einc_number/2
			i_delta=i_test/2
			while( i_delta gt 2 ) do begin
				if( tof_measure le einc_array(i_test, j, k) ) then i_test += i_delta else i_test -= i_delta
 				i_delta /= 2.
 			endwhile

		 	i_delta *= 2.     ; restore i_delta to prior value
			i_scan_test = floor(i_test - i_delta)

;	now find the surrounding array elements

			for i_scan = i_scan_test, einc_number -3 do if( (tof_measure le einc_array(i_scan,j,k)) and (tof_measure gt einc_array(i_scan+1,j,k)) ) then break

;			print, 'tofs: ', j, i_scan, tof_measure, einc_array(i_scan,j,k), einc_array(i_scan+1,j,k)
				interpolate_ln, einc_temp_call, tof_measure, einc_array(i_scan,j,k), einc_array(i_scan+1,j,k), einc(i_scan),einc(i_scan+1)
				einc_temp(index)=einc_temp_call
;				print, index, einc_temp(index)
				index ++
;			print, 'interpolates: ', k, einc_temp(j), tof_measure, einc_array(i_scan,j,k), einc_array(i_scan+1,j,k), einc_temp(0), einc_temp(1)
		endfor
	
;	we now have the einc values at the two mass lines for this tof;  now interpolate a value for the measured mass
			interpolate_ln, einc_tof, mass,  mass_array(m_scan), mass_array(m_scan+1), einc_temp(0), einc_temp(1)
			if(j eq 0 ) then einc_tof1 = einc_tof else einc_tof2 = einc_tof
;	print,' final values: ',  einc_tof, mass,  mass_array(m_scan), mass_array(m_scan+1), einc_temp(0), einc_temp(1)
	
		
	endfor

;	***************************************** find einc_ssd *******************************	

;	find the interpolated Einc at each of the two mass lines
	if( tof1_mass eq 0. ) then mass_avg = tof2_mass
	if( tof2_mass eq 0. ) then mass_avg = tof1_mass
	if( ( tof1_mass gt 0. ) and ( tof2_mass gt 0. ) ) then mass_avg = (tof1_mass + tof2_mass)/2.
	
	einc_temp=fltarr(2)
	index = 0
		for k = m_scan, m_scan+ 1 do begin

;			find the approximate location in einc_array
			i_test=einc_number/2
			i_delta=i_test/2
			while( i_delta gt 2 ) do begin
				if( e_measure gt einc_array(i_test,num_tof,k) ) then i_test += i_delta else i_test -= i_delta
 				i_delta /= 2.
 			endwhile

		 	i_delta *= 2.     ; restore i_delta to prior value
			i_scan_test = floor(i_test - i_delta)

			for i_scan = i_scan_test, einc_number -3 do if( (e_measure ge einc_array(i_scan,num_tof,k)) and (e_measure lt einc_array(i_scan+1,num_tof,k)) ) then break 
				
;			print, 'e_measure: ', num_tof, i_scan, e_measure, einc_array(i_scan,num_tof,k), einc_array(i_scan+1,num_tof,k)
				interpolate_ln, einc_temp_call, e_measure, einc_array(i_scan,num_tof,k), einc_array(i_scan+1,num_tof,k), einc(i_scan),einc(i_scan+1)
				einc_temp(index)=einc_temp_call
;				print, index, einc_temp(index)
				index ++
;			print, 'interpolates: ', k, e_measure, einc_array(i_scan,num_tof,k), einc_array(i_scan+1,num_tof,k), einc_temp(0), einc_temp(1)
		endfor
	
;	we now have the einc values at the two mass lines for this tof;  now interpolate a value for the measured mass
			interpolate_ln, einc_ssd, mass_avg,  mass_array(m_scan), mass_array(m_scan+1), einc_temp(0), einc_temp(1)
;	print,' final values: ',  einc_ssd, mass_avg,  mass_array(m_scan), mass_array(m_scan+1), einc_temp(0), einc_temp(1)

;	stop
	end
	
	
;	*********** old search codes *************

;			if(emeas_first(j,k) lt (einc_number-3) ) then i_start = tof_first(j,k) -1 else i_start = einc_number-4
;			if( i_start lt 0 ) then i_start = 0
;			for i_scan = i_start, einc_number -3 do begin
;				if(tof_measure le einc_array(i_scan,j,k)) then $
;					if(tof_measure gt einc_array(i_scan+1,j,k)) then break

;			if(emeas_first(0,k) lt (einc_number-3) ) then i_start = emeas_first(0,k) -1  else i_start = einc_number-4
;			if( i_start lt 0 ) then i_start = 0
;			for i_scan = i_start, einc_number -3 do begin
;				if(e_measure ge einc_array(i_scan,num_tof,k)) then $
;					if(e_measure lt einc_array(i_scan+1,num_tof,k)) then break
;			endfor	
			