	function carr_long, mjd
;
;	calculates approximate Carrington longitude of CM at time mjd
;
;
;	Original version:  1/16/09  /gm
;	ref:  http://umtof.umd.edu/pm/crn/CARRTIMETABLE.HTML
;
;	reference:  1/1/1995 00:00 is Carrington Long 340.03
;	1/1/95 mjd is 49718
;	sideral solar rotation rate = 27.2753 days

	deg = 349.03-(360.0*(mjd-49718.d0)/27.2753) mod 360.0	
	if(deg lt 0) then deg = deg+360
	return, deg
	end